# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CancelMacOrderDetails(object):
    """
    The data to cancel a MacOrder.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CancelMacOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cancel_reason:
            The value to assign to the cancel_reason property of this CancelMacOrderDetails.
        :type cancel_reason: str

        """
        self.swagger_types = {
            'cancel_reason': 'str'
        }
        self.attribute_map = {
            'cancel_reason': 'cancelReason'
        }
        self._cancel_reason = None

    @property
    def cancel_reason(self):
        """
        Gets the cancel_reason of this CancelMacOrderDetails.
        The reason for the MacOrder cancellation.


        :return: The cancel_reason of this CancelMacOrderDetails.
        :rtype: str
        """
        return self._cancel_reason

    @cancel_reason.setter
    def cancel_reason(self, cancel_reason):
        """
        Sets the cancel_reason of this CancelMacOrderDetails.
        The reason for the MacOrder cancellation.


        :param cancel_reason: The cancel_reason of this CancelMacOrderDetails.
        :type: str
        """
        self._cancel_reason = cancel_reason

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
