# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDbSystemDetails(object):
    """
    Details required to create a DB System.
    """

    #: A constant which can be used with the crash_recovery property of a CreateDbSystemDetails.
    #: This constant has a value of "ENABLED"
    CRASH_RECOVERY_ENABLED = "ENABLED"

    #: A constant which can be used with the crash_recovery property of a CreateDbSystemDetails.
    #: This constant has a value of "DISABLED"
    CRASH_RECOVERY_DISABLED = "DISABLED"

    #: A constant which can be used with the database_management property of a CreateDbSystemDetails.
    #: This constant has a value of "ENABLED"
    DATABASE_MANAGEMENT_ENABLED = "ENABLED"

    #: A constant which can be used with the database_management property of a CreateDbSystemDetails.
    #: This constant has a value of "DISABLED"
    DATABASE_MANAGEMENT_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDbSystemDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDbSystemDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDbSystemDetails.
        :type compartment_id: str

        :param rest:
            The value to assign to the rest property of this CreateDbSystemDetails.
        :type rest: oci.mysql.models.CreateRestDetails

        :param is_highly_available:
            The value to assign to the is_highly_available property of this CreateDbSystemDetails.
        :type is_highly_available: bool

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateDbSystemDetails.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this CreateDbSystemDetails.
        :type fault_domain: str

        :param configuration_id:
            The value to assign to the configuration_id property of this CreateDbSystemDetails.
        :type configuration_id: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateDbSystemDetails.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this CreateDbSystemDetails.
        :type mysql_version: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateDbSystemDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateDbSystemDetails.
        :type nsg_ids: list[str]

        :param admin_username:
            The value to assign to the admin_username property of this CreateDbSystemDetails.
        :type admin_username: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateDbSystemDetails.
        :type admin_password: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this CreateDbSystemDetails.
        :type data_storage_size_in_gbs: int

        :param data_storage:
            The value to assign to the data_storage property of this CreateDbSystemDetails.
        :type data_storage: oci.mysql.models.DataStorageDetails

        :param hostname_label:
            The value to assign to the hostname_label property of this CreateDbSystemDetails.
        :type hostname_label: str

        :param ip_address:
            The value to assign to the ip_address property of this CreateDbSystemDetails.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this CreateDbSystemDetails.
        :type port: int

        :param port_x:
            The value to assign to the port_x property of this CreateDbSystemDetails.
        :type port_x: int

        :param backup_policy:
            The value to assign to the backup_policy property of this CreateDbSystemDetails.
        :type backup_policy: oci.mysql.models.CreateBackupPolicyDetails

        :param source:
            The value to assign to the source property of this CreateDbSystemDetails.
        :type source: oci.mysql.models.CreateDbSystemSourceDetails

        :param maintenance:
            The value to assign to the maintenance property of this CreateDbSystemDetails.
        :type maintenance: oci.mysql.models.CreateMaintenanceDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDbSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDbSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param deletion_policy:
            The value to assign to the deletion_policy property of this CreateDbSystemDetails.
        :type deletion_policy: oci.mysql.models.CreateDeletionPolicyDetails

        :param crash_recovery:
            The value to assign to the crash_recovery property of this CreateDbSystemDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type crash_recovery: str

        :param database_management:
            The value to assign to the database_management property of this CreateDbSystemDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type database_management: str

        :param secure_connections:
            The value to assign to the secure_connections property of this CreateDbSystemDetails.
        :type secure_connections: oci.mysql.models.SecureConnectionDetails

        :param encrypt_data:
            The value to assign to the encrypt_data property of this CreateDbSystemDetails.
        :type encrypt_data: oci.mysql.models.EncryptDataDetails

        :param database_mode:
            The value to assign to the database_mode property of this CreateDbSystemDetails.
        :type database_mode: str

        :param access_mode:
            The value to assign to the access_mode property of this CreateDbSystemDetails.
        :type access_mode: str

        :param customer_contacts:
            The value to assign to the customer_contacts property of this CreateDbSystemDetails.
        :type customer_contacts: list[oci.mysql.models.CustomerContact]

        :param read_endpoint:
            The value to assign to the read_endpoint property of this CreateDbSystemDetails.
        :type read_endpoint: oci.mysql.models.CreateReadEndpointDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'rest': 'CreateRestDetails',
            'is_highly_available': 'bool',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'configuration_id': 'str',
            'shape_name': 'str',
            'mysql_version': 'str',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'admin_username': 'str',
            'admin_password': 'str',
            'data_storage_size_in_gbs': 'int',
            'data_storage': 'DataStorageDetails',
            'hostname_label': 'str',
            'ip_address': 'str',
            'port': 'int',
            'port_x': 'int',
            'backup_policy': 'CreateBackupPolicyDetails',
            'source': 'CreateDbSystemSourceDetails',
            'maintenance': 'CreateMaintenanceDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'deletion_policy': 'CreateDeletionPolicyDetails',
            'crash_recovery': 'str',
            'database_management': 'str',
            'secure_connections': 'SecureConnectionDetails',
            'encrypt_data': 'EncryptDataDetails',
            'database_mode': 'str',
            'access_mode': 'str',
            'customer_contacts': 'list[CustomerContact]',
            'read_endpoint': 'CreateReadEndpointDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'rest': 'rest',
            'is_highly_available': 'isHighlyAvailable',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'configuration_id': 'configurationId',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'admin_username': 'adminUsername',
            'admin_password': 'adminPassword',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'data_storage': 'dataStorage',
            'hostname_label': 'hostnameLabel',
            'ip_address': 'ipAddress',
            'port': 'port',
            'port_x': 'portX',
            'backup_policy': 'backupPolicy',
            'source': 'source',
            'maintenance': 'maintenance',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'deletion_policy': 'deletionPolicy',
            'crash_recovery': 'crashRecovery',
            'database_management': 'databaseManagement',
            'secure_connections': 'secureConnections',
            'encrypt_data': 'encryptData',
            'database_mode': 'databaseMode',
            'access_mode': 'accessMode',
            'customer_contacts': 'customerContacts',
            'read_endpoint': 'readEndpoint'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._rest = None
        self._is_highly_available = None
        self._availability_domain = None
        self._fault_domain = None
        self._configuration_id = None
        self._shape_name = None
        self._mysql_version = None
        self._subnet_id = None
        self._nsg_ids = None
        self._admin_username = None
        self._admin_password = None
        self._data_storage_size_in_gbs = None
        self._data_storage = None
        self._hostname_label = None
        self._ip_address = None
        self._port = None
        self._port_x = None
        self._backup_policy = None
        self._source = None
        self._maintenance = None
        self._freeform_tags = None
        self._defined_tags = None
        self._deletion_policy = None
        self._crash_recovery = None
        self._database_management = None
        self._secure_connections = None
        self._encrypt_data = None
        self._database_mode = None
        self._access_mode = None
        self._customer_contacts = None
        self._read_endpoint = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDbSystemDetails.
        The user-friendly name for the DB System. It does not have to be unique.


        :return: The display_name of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDbSystemDetails.
        The user-friendly name for the DB System. It does not have to be unique.


        :param display_name: The display_name of this CreateDbSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDbSystemDetails.
        User-provided data about the DB System.


        :return: The description of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDbSystemDetails.
        User-provided data about the DB System.


        :param description: The description of this CreateDbSystemDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDbSystemDetails.
        The OCID of the compartment.


        :return: The compartment_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDbSystemDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CreateDbSystemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def rest(self):
        """
        Gets the rest of this CreateDbSystemDetails.

        :return: The rest of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateRestDetails
        """
        return self._rest

    @rest.setter
    def rest(self, rest):
        """
        Sets the rest of this CreateDbSystemDetails.

        :param rest: The rest of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateRestDetails
        """
        self._rest = rest

    @property
    def is_highly_available(self):
        """
        Gets the is_highly_available of this CreateDbSystemDetails.
        Specifies if the DB System is highly available.

        When creating a DB System with High Availability, three instances
        are created and placed according to your region- and
        subnet-type. The secondaries are placed automatically in the other
        two availability or fault domains.  You can choose the preferred
        location of your primary instance, only.


        :return: The is_highly_available of this CreateDbSystemDetails.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this CreateDbSystemDetails.
        Specifies if the DB System is highly available.

        When creating a DB System with High Availability, three instances
        are created and placed according to your region- and
        subnet-type. The secondaries are placed automatically in the other
        two availability or fault domains.  You can choose the preferred
        location of your primary instance, only.


        :param is_highly_available: The is_highly_available of this CreateDbSystemDetails.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this CreateDbSystemDetails.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :return: The availability_domain of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateDbSystemDetails.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :param availability_domain: The availability_domain of this CreateDbSystemDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this CreateDbSystemDetails.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :return: The fault_domain of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this CreateDbSystemDetails.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :param fault_domain: The fault_domain of this CreateDbSystemDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this CreateDbSystemDetails.
        The OCID of the Configuration to be used for this DB System.


        :return: The configuration_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this CreateDbSystemDetails.
        The OCID of the Configuration to be used for this DB System.


        :param configuration_id: The configuration_id of this CreateDbSystemDetails.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this CreateDbSystemDetails.
        The name of the shape. The shape determines the resources allocated
        - CPU cores and memory for VM shapes; CPU cores, memory and storage
        for non-VM (or bare metal) shapes. To get a list of shapes, use the
        :func:`list_shapes` operation.


        :return: The shape_name of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateDbSystemDetails.
        The name of the shape. The shape determines the resources allocated
        - CPU cores and memory for VM shapes; CPU cores, memory and storage
        for non-VM (or bare metal) shapes. To get a list of shapes, use the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this CreateDbSystemDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this CreateDbSystemDetails.
        The specific MySQL version identifier.


        :return: The mysql_version of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this CreateDbSystemDetails.
        The specific MySQL version identifier.


        :param mysql_version: The mysql_version of this CreateDbSystemDetails.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateDbSystemDetails.
        The OCID of the subnet the DB System is associated with.


        :return: The subnet_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateDbSystemDetails.
        The OCID of the subnet the DB System is associated with.


        :param subnet_id: The subnet_id of this CreateDbSystemDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateDbSystemDetails.
        Network Security Group OCIDs used for the VNIC attachment.


        :return: The nsg_ids of this CreateDbSystemDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateDbSystemDetails.
        Network Security Group OCIDs used for the VNIC attachment.


        :param nsg_ids: The nsg_ids of this CreateDbSystemDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def admin_username(self):
        """
        Gets the admin_username of this CreateDbSystemDetails.
        The username for the administrative user.


        :return: The admin_username of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this CreateDbSystemDetails.
        The username for the administrative user.


        :param admin_username: The admin_username of this CreateDbSystemDetails.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def admin_password(self):
        """
        Gets the admin_password of this CreateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :return: The admin_password of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :param admin_password: The admin_password of this CreateDbSystemDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this CreateDbSystemDetails.
        Initial size of the data volume in GBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume,
        the log volume for the database will be scaled appropriately with its shape.


        :return: The data_storage_size_in_gbs of this CreateDbSystemDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this CreateDbSystemDetails.
        Initial size of the data volume in GBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume,
        the log volume for the database will be scaled appropriately with its shape.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this CreateDbSystemDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def data_storage(self):
        """
        Gets the data_storage of this CreateDbSystemDetails.

        :return: The data_storage of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.DataStorageDetails
        """
        return self._data_storage

    @data_storage.setter
    def data_storage(self, data_storage):
        """
        Sets the data_storage of this CreateDbSystemDetails.

        :param data_storage: The data_storage of this CreateDbSystemDetails.
        :type: oci.mysql.models.DataStorageDetails
        """
        self._data_storage = data_storage

    @property
    def hostname_label(self):
        """
        Gets the hostname_label of this CreateDbSystemDetails.
        The hostname for the primary endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :return: The hostname_label of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._hostname_label

    @hostname_label.setter
    def hostname_label(self, hostname_label):
        """
        Sets the hostname_label of this CreateDbSystemDetails.
        The hostname for the primary endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :param hostname_label: The hostname_label of this CreateDbSystemDetails.
        :type: str
        """
        self._hostname_label = hostname_label

    @property
    def ip_address(self):
        """
        Gets the ip_address of this CreateDbSystemDetails.
        The IP address the DB System is configured to listen on.
        A private IP address of your choice to assign to the primary endpoint of the DB System.
        Must be an available IP address within the subnet's CIDR. If you don't specify a value,
        Oracle automatically assigns a private IP address from the subnet. This should be a
        \"dotted-quad\" style IPv4 address.


        :return: The ip_address of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this CreateDbSystemDetails.
        The IP address the DB System is configured to listen on.
        A private IP address of your choice to assign to the primary endpoint of the DB System.
        Must be an available IP address within the subnet's CIDR. If you don't specify a value,
        Oracle automatically assigns a private IP address from the subnet. This should be a
        \"dotted-quad\" style IPv4 address.


        :param ip_address: The ip_address of this CreateDbSystemDetails.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        Gets the port of this CreateDbSystemDetails.
        The port for primary endpoint of the DB System to listen on.


        :return: The port of this CreateDbSystemDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CreateDbSystemDetails.
        The port for primary endpoint of the DB System to listen on.


        :param port: The port of this CreateDbSystemDetails.
        :type: int
        """
        self._port = port

    @property
    def port_x(self):
        """
        Gets the port_x of this CreateDbSystemDetails.
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.


        :return: The port_x of this CreateDbSystemDetails.
        :rtype: int
        """
        return self._port_x

    @port_x.setter
    def port_x(self, port_x):
        """
        Sets the port_x of this CreateDbSystemDetails.
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.


        :param port_x: The port_x of this CreateDbSystemDetails.
        :type: int
        """
        self._port_x = port_x

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this CreateDbSystemDetails.

        :return: The backup_policy of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateBackupPolicyDetails
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this CreateDbSystemDetails.

        :param backup_policy: The backup_policy of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateBackupPolicyDetails
        """
        self._backup_policy = backup_policy

    @property
    def source(self):
        """
        Gets the source of this CreateDbSystemDetails.

        :return: The source of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateDbSystemSourceDetails
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateDbSystemDetails.

        :param source: The source of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateDbSystemSourceDetails
        """
        self._source = source

    @property
    def maintenance(self):
        """
        Gets the maintenance of this CreateDbSystemDetails.

        :return: The maintenance of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateMaintenanceDetails
        """
        return self._maintenance

    @maintenance.setter
    def maintenance(self, maintenance):
        """
        Sets the maintenance of this CreateDbSystemDetails.

        :param maintenance: The maintenance of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateMaintenanceDetails
        """
        self._maintenance = maintenance

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDbSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDbSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDbSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDbSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def deletion_policy(self):
        """
        Gets the deletion_policy of this CreateDbSystemDetails.

        :return: The deletion_policy of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateDeletionPolicyDetails
        """
        return self._deletion_policy

    @deletion_policy.setter
    def deletion_policy(self, deletion_policy):
        """
        Sets the deletion_policy of this CreateDbSystemDetails.

        :param deletion_policy: The deletion_policy of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateDeletionPolicyDetails
        """
        self._deletion_policy = deletion_policy

    @property
    def crash_recovery(self):
        """
        Gets the crash_recovery of this CreateDbSystemDetails.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The crash_recovery of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._crash_recovery

    @crash_recovery.setter
    def crash_recovery(self, crash_recovery):
        """
        Sets the crash_recovery of this CreateDbSystemDetails.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.


        :param crash_recovery: The crash_recovery of this CreateDbSystemDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(crash_recovery, allowed_values):
            raise ValueError(
                f"Invalid value for `crash_recovery`, must be None or one of {allowed_values}"
            )
        self._crash_recovery = crash_recovery

    @property
    def database_management(self):
        """
        Gets the database_management of this CreateDbSystemDetails.
        Whether to enable monitoring via the Database Management service.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The database_management of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._database_management

    @database_management.setter
    def database_management(self, database_management):
        """
        Sets the database_management of this CreateDbSystemDetails.
        Whether to enable monitoring via the Database Management service.


        :param database_management: The database_management of this CreateDbSystemDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(database_management, allowed_values):
            raise ValueError(
                f"Invalid value for `database_management`, must be None or one of {allowed_values}"
            )
        self._database_management = database_management

    @property
    def secure_connections(self):
        """
        Gets the secure_connections of this CreateDbSystemDetails.

        :return: The secure_connections of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.SecureConnectionDetails
        """
        return self._secure_connections

    @secure_connections.setter
    def secure_connections(self, secure_connections):
        """
        Sets the secure_connections of this CreateDbSystemDetails.

        :param secure_connections: The secure_connections of this CreateDbSystemDetails.
        :type: oci.mysql.models.SecureConnectionDetails
        """
        self._secure_connections = secure_connections

    @property
    def encrypt_data(self):
        """
        Gets the encrypt_data of this CreateDbSystemDetails.

        :return: The encrypt_data of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.EncryptDataDetails
        """
        return self._encrypt_data

    @encrypt_data.setter
    def encrypt_data(self, encrypt_data):
        """
        Sets the encrypt_data of this CreateDbSystemDetails.

        :param encrypt_data: The encrypt_data of this CreateDbSystemDetails.
        :type: oci.mysql.models.EncryptDataDetails
        """
        self._encrypt_data = encrypt_data

    @property
    def database_mode(self):
        """
        Gets the database_mode of this CreateDbSystemDetails.
        The database mode indicating the types of statements that will be allowed to run in the DB system.
        This mode will apply only to statements run by user connections. Replicated write statements will continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE (default): allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :return: The database_mode of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._database_mode

    @database_mode.setter
    def database_mode(self, database_mode):
        """
        Sets the database_mode of this CreateDbSystemDetails.
        The database mode indicating the types of statements that will be allowed to run in the DB system.
        This mode will apply only to statements run by user connections. Replicated write statements will continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE (default): allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :param database_mode: The database_mode of this CreateDbSystemDetails.
        :type: str
        """
        self._database_mode = database_mode

    @property
    def access_mode(self):
        """
        Gets the access_mode of this CreateDbSystemDetails.
        The access mode indicating if the database access will be restricted only to administrators or not:
         - UNRESTRICTED (default): the access to the database is not restricted;
         - RESTRICTED: the access will be allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :return: The access_mode of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._access_mode

    @access_mode.setter
    def access_mode(self, access_mode):
        """
        Sets the access_mode of this CreateDbSystemDetails.
        The access mode indicating if the database access will be restricted only to administrators or not:
         - UNRESTRICTED (default): the access to the database is not restricted;
         - RESTRICTED: the access will be allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :param access_mode: The access_mode of this CreateDbSystemDetails.
        :type: str
        """
        self._access_mode = access_mode

    @property
    def customer_contacts(self):
        """
        Gets the customer_contacts of this CreateDbSystemDetails.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :return: The customer_contacts of this CreateDbSystemDetails.
        :rtype: list[oci.mysql.models.CustomerContact]
        """
        return self._customer_contacts

    @customer_contacts.setter
    def customer_contacts(self, customer_contacts):
        """
        Sets the customer_contacts of this CreateDbSystemDetails.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :param customer_contacts: The customer_contacts of this CreateDbSystemDetails.
        :type: list[oci.mysql.models.CustomerContact]
        """
        self._customer_contacts = customer_contacts

    @property
    def read_endpoint(self):
        """
        Gets the read_endpoint of this CreateDbSystemDetails.

        :return: The read_endpoint of this CreateDbSystemDetails.
        :rtype: oci.mysql.models.CreateReadEndpointDetails
        """
        return self._read_endpoint

    @read_endpoint.setter
    def read_endpoint(self, read_endpoint):
        """
        Sets the read_endpoint of this CreateDbSystemDetails.

        :param read_endpoint: The read_endpoint of this CreateDbSystemDetails.
        :type: oci.mysql.models.CreateReadEndpointDetails
        """
        self._read_endpoint = read_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
