# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpgradeOpenSearchClusterDetails(object):
    """
    Minor or major version upgrade of a cluster.
    """

    #: A constant which can be used with the upgrade_type property of a UpgradeOpenSearchClusterDetails.
    #: This constant has a value of "MINOR"
    UPGRADE_TYPE_MINOR = "MINOR"

    #: A constant which can be used with the upgrade_type property of a UpgradeOpenSearchClusterDetails.
    #: This constant has a value of "MAJOR"
    UPGRADE_TYPE_MAJOR = "MAJOR"

    def __init__(self, **kwargs):
        """
        Initializes a new UpgradeOpenSearchClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param original_cluster_display_name:
            The value to assign to the original_cluster_display_name property of this UpgradeOpenSearchClusterDetails.
        :type original_cluster_display_name: str

        :param desired_software_version:
            The value to assign to the desired_software_version property of this UpgradeOpenSearchClusterDetails.
        :type desired_software_version: str

        :param upgrade_type:
            The value to assign to the upgrade_type property of this UpgradeOpenSearchClusterDetails.
            Allowed values for this property are: "MINOR", "MAJOR"
        :type upgrade_type: str

        :param is_clone:
            The value to assign to the is_clone property of this UpgradeOpenSearchClusterDetails.
        :type is_clone: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpgradeOpenSearchClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpgradeOpenSearchClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this UpgradeOpenSearchClusterDetails.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'original_cluster_display_name': 'str',
            'desired_software_version': 'str',
            'upgrade_type': 'str',
            'is_clone': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'original_cluster_display_name': 'originalClusterDisplayName',
            'desired_software_version': 'desiredSoftwareVersion',
            'upgrade_type': 'upgradeType',
            'is_clone': 'isClone',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._original_cluster_display_name = None
        self._desired_software_version = None
        self._upgrade_type = None
        self._is_clone = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def original_cluster_display_name(self):
        """
        **[Required]** Gets the original_cluster_display_name of this UpgradeOpenSearchClusterDetails.
        The display name of the original cluster.
        This is required to validate that the cluster ID has the same display name.


        :return: The original_cluster_display_name of this UpgradeOpenSearchClusterDetails.
        :rtype: str
        """
        return self._original_cluster_display_name

    @original_cluster_display_name.setter
    def original_cluster_display_name(self, original_cluster_display_name):
        """
        Sets the original_cluster_display_name of this UpgradeOpenSearchClusterDetails.
        The display name of the original cluster.
        This is required to validate that the cluster ID has the same display name.


        :param original_cluster_display_name: The original_cluster_display_name of this UpgradeOpenSearchClusterDetails.
        :type: str
        """
        self._original_cluster_display_name = original_cluster_display_name

    @property
    def desired_software_version(self):
        """
        **[Required]** Gets the desired_software_version of this UpgradeOpenSearchClusterDetails.
        The software version the cluster is desired.


        :return: The desired_software_version of this UpgradeOpenSearchClusterDetails.
        :rtype: str
        """
        return self._desired_software_version

    @desired_software_version.setter
    def desired_software_version(self, desired_software_version):
        """
        Sets the desired_software_version of this UpgradeOpenSearchClusterDetails.
        The software version the cluster is desired.


        :param desired_software_version: The desired_software_version of this UpgradeOpenSearchClusterDetails.
        :type: str
        """
        self._desired_software_version = desired_software_version

    @property
    def upgrade_type(self):
        """
        **[Required]** Gets the upgrade_type of this UpgradeOpenSearchClusterDetails.
        The upgrade type of cluster (major or minor).

        Allowed values for this property are: "MINOR", "MAJOR"


        :return: The upgrade_type of this UpgradeOpenSearchClusterDetails.
        :rtype: str
        """
        return self._upgrade_type

    @upgrade_type.setter
    def upgrade_type(self, upgrade_type):
        """
        Sets the upgrade_type of this UpgradeOpenSearchClusterDetails.
        The upgrade type of cluster (major or minor).


        :param upgrade_type: The upgrade_type of this UpgradeOpenSearchClusterDetails.
        :type: str
        """
        allowed_values = ["MINOR", "MAJOR"]
        if not value_allowed_none_or_none_sentinel(upgrade_type, allowed_values):
            raise ValueError(
                f"Invalid value for `upgrade_type`, must be None or one of {allowed_values}"
            )
        self._upgrade_type = upgrade_type

    @property
    def is_clone(self):
        """
        Gets the is_clone of this UpgradeOpenSearchClusterDetails.
        The cluster would be cloned for true and updated for false with the provided version.


        :return: The is_clone of this UpgradeOpenSearchClusterDetails.
        :rtype: bool
        """
        return self._is_clone

    @is_clone.setter
    def is_clone(self, is_clone):
        """
        Sets the is_clone of this UpgradeOpenSearchClusterDetails.
        The cluster would be cloned for true and updated for false with the provided version.


        :param is_clone: The is_clone of this UpgradeOpenSearchClusterDetails.
        :type: bool
        """
        self._is_clone = is_clone

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpgradeOpenSearchClusterDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpgradeOpenSearchClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpgradeOpenSearchClusterDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpgradeOpenSearchClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpgradeOpenSearchClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpgradeOpenSearchClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpgradeOpenSearchClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpgradeOpenSearchClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this UpgradeOpenSearchClusterDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this UpgradeOpenSearchClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this UpgradeOpenSearchClusterDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this UpgradeOpenSearchClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
