# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200909


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateEndpointMetadata(object):
    """
    The private endpoint metadata for the connector's source or target.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateEndpointMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rce_traffic_ip_address:
            The value to assign to the rce_traffic_ip_address property of this PrivateEndpointMetadata.
        :type rce_traffic_ip_address: str

        :param rce_dns_proxy_ip_address:
            The value to assign to the rce_dns_proxy_ip_address property of this PrivateEndpointMetadata.
        :type rce_dns_proxy_ip_address: str

        """
        self.swagger_types = {
            'rce_traffic_ip_address': 'str',
            'rce_dns_proxy_ip_address': 'str'
        }
        self.attribute_map = {
            'rce_traffic_ip_address': 'rceTrafficIpAddress',
            'rce_dns_proxy_ip_address': 'rceDnsProxyIpAddress'
        }
        self._rce_traffic_ip_address = None
        self._rce_dns_proxy_ip_address = None

    @property
    def rce_traffic_ip_address(self):
        """
        Gets the rce_traffic_ip_address of this PrivateEndpointMetadata.
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.


        :return: The rce_traffic_ip_address of this PrivateEndpointMetadata.
        :rtype: str
        """
        return self._rce_traffic_ip_address

    @rce_traffic_ip_address.setter
    def rce_traffic_ip_address(self, rce_traffic_ip_address):
        """
        Sets the rce_traffic_ip_address of this PrivateEndpointMetadata.
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.


        :param rce_traffic_ip_address: The rce_traffic_ip_address of this PrivateEndpointMetadata.
        :type: str
        """
        self._rce_traffic_ip_address = rce_traffic_ip_address

    @property
    def rce_dns_proxy_ip_address(self):
        """
        Gets the rce_dns_proxy_ip_address of this PrivateEndpointMetadata.
        The reverse connection endpoint (RCE) IP address for DNS lookups.


        :return: The rce_dns_proxy_ip_address of this PrivateEndpointMetadata.
        :rtype: str
        """
        return self._rce_dns_proxy_ip_address

    @rce_dns_proxy_ip_address.setter
    def rce_dns_proxy_ip_address(self, rce_dns_proxy_ip_address):
        """
        Sets the rce_dns_proxy_ip_address of this PrivateEndpointMetadata.
        The reverse connection endpoint (RCE) IP address for DNS lookups.


        :param rce_dns_proxy_ip_address: The rce_dns_proxy_ip_address of this PrivateEndpointMetadata.
        :type: str
        """
        self._rce_dns_proxy_ip_address = rce_dns_proxy_ip_address

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
