# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestSummarizedMetricExtensionsResourcesDetails(object):
    """
    Filtering criteria data to be specified in the request. Either metricExtensionId or compartmentId must be passed even when no other filter property is passed.
    """

    #: A constant which can be used with the association_status property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "ENABLED"
    ASSOCIATION_STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the association_status property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "DISABLED"
    ASSOCIATION_STATUS_DISABLED = "DISABLED"

    #: A constant which can be used with the group_by property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "METRIC_EXTENSION_ID"
    GROUP_BY_METRIC_EXTENSION_ID = "METRIC_EXTENSION_ID"

    #: A constant which can be used with the sort_by property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "COUNT"
    SORT_BY_COUNT = "COUNT"

    #: A constant which can be used with the sort_order property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "ASC"
    SORT_ORDER_ASC = "ASC"

    #: A constant which can be used with the sort_order property of a RequestSummarizedMetricExtensionsResourcesDetails.
    #: This constant has a value of "DESC"
    SORT_ORDER_DESC = "DESC"

    def __init__(self, **kwargs):
        """
        Initializes a new RequestSummarizedMetricExtensionsResourcesDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_extension_id:
            The value to assign to the metric_extension_id property of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type metric_extension_id: str

        :param resource_type:
            The value to assign to the resource_type property of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type resource_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type compartment_id: str

        :param association_status:
            The value to assign to the association_status property of this RequestSummarizedMetricExtensionsResourcesDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type association_status: str

        :param resource_id:
            The value to assign to the resource_id property of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type resource_id: str

        :param group_by:
            The value to assign to the group_by property of this RequestSummarizedMetricExtensionsResourcesDetails.
            Allowed values for this property are: "METRIC_EXTENSION_ID"
        :type group_by: str

        :param sort_by:
            The value to assign to the sort_by property of this RequestSummarizedMetricExtensionsResourcesDetails.
            Allowed values for this property are: "COUNT"
        :type sort_by: str

        :param sort_order:
            The value to assign to the sort_order property of this RequestSummarizedMetricExtensionsResourcesDetails.
            Allowed values for this property are: "ASC", "DESC"
        :type sort_order: str

        """
        self.swagger_types = {
            'metric_extension_id': 'str',
            'resource_type': 'str',
            'compartment_id': 'str',
            'association_status': 'str',
            'resource_id': 'str',
            'group_by': 'str',
            'sort_by': 'str',
            'sort_order': 'str'
        }
        self.attribute_map = {
            'metric_extension_id': 'metricExtensionId',
            'resource_type': 'resourceType',
            'compartment_id': 'compartmentId',
            'association_status': 'associationStatus',
            'resource_id': 'resourceId',
            'group_by': 'groupBy',
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder'
        }
        self._metric_extension_id = None
        self._resource_type = None
        self._compartment_id = None
        self._association_status = None
        self._resource_id = None
        self._group_by = None
        self._sort_by = None
        self._sort_order = None

    @property
    def metric_extension_id(self):
        """
        Gets the metric_extension_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        The `OCID`__ of Metric Extension resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The metric_extension_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._metric_extension_id

    @metric_extension_id.setter
    def metric_extension_id(self, metric_extension_id):
        """
        Sets the metric_extension_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        The `OCID`__ of Metric Extension resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param metric_extension_id: The metric_extension_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        self._metric_extension_id = metric_extension_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this RequestSummarizedMetricExtensionsResourcesDetails.
        Resource type to which Metric Extension applies


        :return: The resource_type of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this RequestSummarizedMetricExtensionsResourcesDetails.
        Resource type to which Metric Extension applies


        :param resource_type: The resource_type of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def association_status(self):
        """
        Gets the association_status of this RequestSummarizedMetricExtensionsResourcesDetails.
        Filter to return metric extensions based on input enable status i.e. Enabled/Disabled

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The association_status of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._association_status

    @association_status.setter
    def association_status(self, association_status):
        """
        Sets the association_status of this RequestSummarizedMetricExtensionsResourcesDetails.
        Filter to return metric extensions based on input enable status i.e. Enabled/Disabled


        :param association_status: The association_status of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(association_status, allowed_values):
            raise ValueError(
                f"Invalid value for `association_status`, must be None or one of {allowed_values}"
            )
        self._association_status = association_status

    @property
    def resource_id(self):
        """
        Gets the resource_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        The `OCID`__ of Monitored Resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        The `OCID`__ of Monitored Resource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def group_by(self):
        """
        Gets the group_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        The field to group by

        Allowed values for this property are: "METRIC_EXTENSION_ID"


        :return: The group_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """
        Sets the group_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        The field to group by


        :param group_by: The group_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        allowed_values = ["METRIC_EXTENSION_ID"]
        if not value_allowed_none_or_none_sentinel(group_by, allowed_values):
            raise ValueError(
                f"Invalid value for `group_by`, must be None or one of {allowed_values}"
            )
        self._group_by = group_by

    @property
    def sort_by(self):
        """
        Gets the sort_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        Result will ne sorted by this parameter value

        Allowed values for this property are: "COUNT"


        :return: The sort_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        Result will ne sorted by this parameter value


        :param sort_by: The sort_by of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        allowed_values = ["COUNT"]
        if not value_allowed_none_or_none_sentinel(sort_by, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_by`, must be None or one of {allowed_values}"
            )
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this RequestSummarizedMetricExtensionsResourcesDetails.
        Sort orders

        Allowed values for this property are: "ASC", "DESC"


        :return: The sort_order of this RequestSummarizedMetricExtensionsResourcesDetails.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this RequestSummarizedMetricExtensionsResourcesDetails.
        Sort orders


        :param sort_order: The sort_order of this RequestSummarizedMetricExtensionsResourcesDetails.
        :type: str
        """
        allowed_values = ["ASC", "DESC"]
        if not value_allowed_none_or_none_sentinel(sort_order, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_order`, must be None or one of {allowed_values}"
            )
        self._sort_order = sort_order

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
