# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMaintenanceWindowDetails(object):
    """
    Infomation to create a new Maintenance Window.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMaintenanceWindowDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateMaintenanceWindowDetails.
        :type description: str

        :param resources:
            The value to assign to the resources property of this UpdateMaintenanceWindowDetails.
        :type resources: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]

        :param schedule:
            The value to assign to the schedule property of this UpdateMaintenanceWindowDetails.
        :type schedule: oci.stack_monitoring.models.MaintenanceWindowSchedule

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateMaintenanceWindowDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateMaintenanceWindowDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'resources': 'list[CreateMaintenanceWindowResourceDetails]',
            'schedule': 'MaintenanceWindowSchedule',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'description': 'description',
            'resources': 'resources',
            'schedule': 'schedule',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._description = None
        self._resources = None
        self._schedule = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateMaintenanceWindowDetails.
        Maintenance Window description.


        :return: The description of this UpdateMaintenanceWindowDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateMaintenanceWindowDetails.
        Maintenance Window description.


        :param description: The description of this UpdateMaintenanceWindowDetails.
        :type: str
        """
        self._description = description

    @property
    def resources(self):
        """
        Gets the resources of this UpdateMaintenanceWindowDetails.
        List of resource Ids which are part of the Maintenance Window


        :return: The resources of this UpdateMaintenanceWindowDetails.
        :rtype: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this UpdateMaintenanceWindowDetails.
        List of resource Ids which are part of the Maintenance Window


        :param resources: The resources of this UpdateMaintenanceWindowDetails.
        :type: list[oci.stack_monitoring.models.CreateMaintenanceWindowResourceDetails]
        """
        self._resources = resources

    @property
    def schedule(self):
        """
        Gets the schedule of this UpdateMaintenanceWindowDetails.

        :return: The schedule of this UpdateMaintenanceWindowDetails.
        :rtype: oci.stack_monitoring.models.MaintenanceWindowSchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this UpdateMaintenanceWindowDetails.

        :param schedule: The schedule of this UpdateMaintenanceWindowDetails.
        :type: oci.stack_monitoring.models.MaintenanceWindowSchedule
        """
        self._schedule = schedule

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateMaintenanceWindowDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateMaintenanceWindowDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateMaintenanceWindowDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateMaintenanceWindowDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateMaintenanceWindowDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateMaintenanceWindowDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateMaintenanceWindowDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateMaintenanceWindowDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
