# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicablePatchSummary(object):
    """
    Details of a patch that can be installed in a WebLogic domain.
    """

    #: A constant which can be used with the middleware_type property of a ApplicablePatchSummary.
    #: This constant has a value of "FMW"
    MIDDLEWARE_TYPE_FMW = "FMW"

    #: A constant which can be used with the middleware_type property of a ApplicablePatchSummary.
    #: This constant has a value of "WLS"
    MIDDLEWARE_TYPE_WLS = "WLS"

    #: A constant which can be used with the middleware_type property of a ApplicablePatchSummary.
    #: This constant has a value of "OPATCH"
    MIDDLEWARE_TYPE_OPATCH = "OPATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicablePatchSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ApplicablePatchSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ApplicablePatchSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ApplicablePatchSummary.
        :type description: str

        :param weblogic_version:
            The value to assign to the weblogic_version property of this ApplicablePatchSummary.
        :type weblogic_version: str

        :param middleware_type:
            The value to assign to the middleware_type property of this ApplicablePatchSummary.
            Allowed values for items in this list are: "FMW", "WLS", "OPATCH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type middleware_type: list[str]

        :param os_arch:
            The value to assign to the os_arch property of this ApplicablePatchSummary.
        :type os_arch: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'weblogic_version': 'str',
            'middleware_type': 'list[str]',
            'os_arch': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'weblogic_version': 'weblogicVersion',
            'middleware_type': 'middlewareType',
            'os_arch': 'osArch'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._weblogic_version = None
        self._middleware_type = None
        self._os_arch = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ApplicablePatchSummary.
        The ID of the WebLogic patch.


        :return: The id of this ApplicablePatchSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ApplicablePatchSummary.
        The ID of the WebLogic patch.


        :param id: The id of this ApplicablePatchSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ApplicablePatchSummary.
        The name of the WebLogic patch.


        :return: The display_name of this ApplicablePatchSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApplicablePatchSummary.
        The name of the WebLogic patch.


        :param display_name: The display_name of this ApplicablePatchSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this ApplicablePatchSummary.
        The description of the WebLogic patch.


        :return: The description of this ApplicablePatchSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApplicablePatchSummary.
        The description of the WebLogic patch.


        :param description: The description of this ApplicablePatchSummary.
        :type: str
        """
        self._description = description

    @property
    def weblogic_version(self):
        """
        **[Required]** Gets the weblogic_version of this ApplicablePatchSummary.
        The WebLogic version for this patch. The patch can be installed to domains with this version.


        :return: The weblogic_version of this ApplicablePatchSummary.
        :rtype: str
        """
        return self._weblogic_version

    @weblogic_version.setter
    def weblogic_version(self, weblogic_version):
        """
        Sets the weblogic_version of this ApplicablePatchSummary.
        The WebLogic version for this patch. The patch can be installed to domains with this version.


        :param weblogic_version: The weblogic_version of this ApplicablePatchSummary.
        :type: str
        """
        self._weblogic_version = weblogic_version

    @property
    def middleware_type(self):
        """
        **[Required]** Gets the middleware_type of this ApplicablePatchSummary.
        The type of middleware for which this patch is applicable. A patch can be applicable to more than one type of middleware.

        Allowed values for items in this list are: "FMW", "WLS", "OPATCH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The middleware_type of this ApplicablePatchSummary.
        :rtype: list[str]
        """
        return self._middleware_type

    @middleware_type.setter
    def middleware_type(self, middleware_type):
        """
        Sets the middleware_type of this ApplicablePatchSummary.
        The type of middleware for which this patch is applicable. A patch can be applicable to more than one type of middleware.


        :param middleware_type: The middleware_type of this ApplicablePatchSummary.
        :type: list[str]
        """
        allowed_values = ["FMW", "WLS", "OPATCH"]
        if middleware_type:
            middleware_type[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in middleware_type]
        self._middleware_type = middleware_type

    @property
    def os_arch(self):
        """
        **[Required]** Gets the os_arch of this ApplicablePatchSummary.
        The operating system architecture for which the patch can be applied.


        :return: The os_arch of this ApplicablePatchSummary.
        :rtype: str
        """
        return self._os_arch

    @os_arch.setter
    def os_arch(self, os_arch):
        """
        Sets the os_arch of this ApplicablePatchSummary.
        The operating system architecture for which the patch can be applied.


        :param os_arch: The os_arch of this ApplicablePatchSummary.
        :type: str
        """
        self._os_arch = os_arch

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
