from ubiquerg import VersionInHelpParser

from ._version import __version__
from .const import *


def build_preprocess_argparser(
    parser: VersionInHelpParser,
) -> VersionInHelpParser:
    parser.add_argument(
        "-i",
        "--input",
        dest="input",
        help="Path to input bed files",
    )

    parser.add_argument("-m", "--metadata", dest="metadata", help="Path to metadata file")

    parser.add_argument(
        "-u",
        "--universe",
        dest="universe",
        help="Path to universe file",
    )

    parser.add_argument(
        "-o",
        "--output",
        default="out",
        dest="output",
        help="Path to output folder",
    )

    parser.add_argument(
        "-l",
        "--labels",
        default="cell_type,target",
        dest="labels",
        help="Labels string",
    )


def build_train_argparser(parser: VersionInHelpParser) -> VersionInHelpParser:
    parser.add_argument(
        "-s",
        "--path-to-starsapce",
        dest="path_to_starsapce",
        help="Path to starspace folder (must be prebuilt)",
    )

    parser.add_argument(
        "-i",
        "--input",
        dest="input",
        help="Path to input file generated by preprocess",
    )

    parser.add_argument(
        "-n",
        "--epochs",
        dest="num_epochs",
        help="Number of epochs",
    )

    parser.add_argument(
        "-d",
        "--dim",
        dest="dim",
        help="Dimension of embeddings",
    )

    parser.add_argument(
        "-l",
        "--lr",
        dest="learning_rate",
        help="Learning rate",
    )

    parser.add_argument(
        "-o",
        "--output",
        default="out",
        dest="output",
        help="Path to output folder",
    )


def build_distance_argparser(
    parser: VersionInHelpParser,
) -> VersionInHelpParser:
    parser.add_argument(
        "-i",
        "--input",
        dest="input",
        help="Path to a trained model",
    )

    parser.add_argument(
        "-m",
        "--metadata",
        dest="metadata",
        help="Path to metadata file",
    )

    parser.add_argument(
        "-u",
        "--universe",
        dest="universe",
        help="Path to universe file",
    )

    parser.add_argument(
        "-f",
        "--files",
        dest="files",
        help="Path to files to be embedded (the data)",
    )

    parser.add_argument(
        "-l",
        "--labels",
        dest="labels",
        default="cell_type,target",
        help="Labels string",
    )

    parser.add_argument(
        "-o",
        "--output",
        default="out",
        dest="output",
        help="Path to output folder",
    )

    parser.add_argument(
        "-t",
        "--threshold",
        dest="threshold",
        default=0.5,
        help="Threshold for classification",
    )


def build_search_argparser(parser: VersionInHelpParser) -> VersionInHelpParser:
    parser.add_argument("query", help="Search query")
    parser.add_argument(
        "-t",
        "--type",
        dest="type",
        type=SearchType,
        help="Search type. Can be one of the following: 1) Label2Region (l2r) 2) Region2Label (r2l) 3) Region2Region (r2r)",
    )

    parser.add_argument(
        "-d",
        "--distances",
        dest="distances",
        help="Path to distances file",
    )

    parser.add_argument(
        "-n",
        "--num-results",
        dest="num_results",
        default=10,
        help="Number of results to return",
    )
