# generated by datamodel-codegen:
#   filename:  api/data/createFile.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import file
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateFileRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this file.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this file.'),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the file.')
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the drive service fully qualified name where this file is hosted in'
        ),
    ]
    directory: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Link to the parent directory fully qualified name'),
    ]
    fileType: Annotated[
        Optional[file.FileType],
        Field(None, description='Type of file based on content'),
    ]
    mimeType: Annotated[Optional[str], Field(None, description='MIME type of the file')]
    fileExtension: Annotated[Optional[str], Field(None, description='File extension')]
    path: Annotated[Optional[str], Field(None, description='Full path to the file')]
    size: Annotated[Optional[int], Field(None, description='File size in bytes')]
    checksum: Annotated[Optional[str], Field(None, description='File checksum/hash')]
    webViewLink: Annotated[
        Optional[AnyUrl], Field(None, description='Web link to view the file')
    ]
    downloadLink: Annotated[
        Optional[AnyUrl], Field(None, description='Direct download link')
    ]
    isShared: Annotated[
        Optional[bool], Field(False, description='Whether this file is shared')
    ]
    fileVersion: Annotated[
        Optional[str], Field(None, description='File version information')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of file.')
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this File.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this file'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the File belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
