# generated by datamodel-codegen:
#   filename:  api/data/createPipeline.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import pipeline
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreatePipelineRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Pipeline. It could be title or label from the source services.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the pipeline instance. What it has and how to use it.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(
            None,
            description='Pipeline URL suffix to visit/manage. This URL points to respective pipeline service UI',
        ),
    ]
    concurrency: Annotated[
        Optional[int], Field(None, description='Concurrency of the Pipeline')
    ]
    pipelineLocation: Annotated[
        Optional[str], Field(None, description='Pipeline Code Location')
    ]
    startDate: Annotated[
        Optional[basic.DateTime], Field(None, description='Start date of the workflow')
    ]
    tasks: Annotated[
        Optional[List[pipeline.Task]],
        Field(None, description='All the tasks that are part of pipeline.'),
    ]
    state: Annotated[
        Optional[pipeline.PipelineState],
        Field(None, description='State of the pipeline.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Pipeline.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this pipeline'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the pipeline service fqn where this pipeline is hosted in'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    scheduleInterval: Annotated[
        Optional[str],
        Field(None, description='Scheduler Interval for the pipeline in cron format.'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Pipeline belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
