# generated by datamodel-codegen:
#   filename:  api/data/createSpreadsheet.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import spreadsheet
from ...type import basic, entityReference, entityReferenceList, lifeCycle, tagLabel


class CreateSpreadsheetRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this spreadsheet.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this spreadsheet.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the spreadsheet.'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the drive service fully qualified name where this spreadsheet is hosted in'
        ),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the parent entity (directory). If not provided, the spreadsheet will be created directly under the service.',
        ),
    ]
    mimeType: Annotated[
        Optional[spreadsheet.SpreadsheetMimeType],
        Field(None, description='MIME type of the spreadsheet file'),
    ]
    path: Annotated[
        Optional[str], Field(None, description='Full path to the spreadsheet file')
    ]
    driveFileId: Annotated[
        Optional[str], Field(None, description='Native file ID in the source system')
    ]
    size: Annotated[
        Optional[int],
        Field(
            None,
            description='File size in bytes (may be null for cloud-native files like Google Sheets)',
        ),
    ]
    fileVersion: Annotated[
        Optional[str], Field(None, description='File version information')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(
            None,
            description='Link to view/edit this spreadsheet in the source system (e.g., Google Sheets URL, SharePoint URL).',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Spreadsheet.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this spreadsheet'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the Spreadsheet belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
