# generated by datamodel-codegen:
#   filename:  api/policies/createPolicy.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.policies import policy
from ...type import basic, entityReferenceList


class CreatePolicyRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this Policy.')
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Title for this Policy.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='A short description of the Policy, comprehensible to regular users.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Policy.'),
    ]
    rules: policy.Rules
    enabled: Annotated[
        Optional[bool], Field(True, description='Is the policy enabled.')
    ]
    location: Annotated[
        Optional[basic.Uuid],
        Field(None, description='UUID of Location where this policy is applied'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Policy belongs to.',
        ),
    ]
