# generated by datamodel-codegen:
#   filename:  api/scim/scimGroup.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AwareDatetime, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Member(BaseModel):
    value: Annotated[str, Field(description='ID of the member (user)')]
    display: Annotated[
        Optional[str], Field(None, description='Display name of the member')
    ]
    type: Annotated[
        Optional[str], Field(None, description="Type of member - typically 'User'")
    ]


class Meta(BaseModel):
    resourceType: Optional[str] = None
    created: Optional[AwareDatetime] = None
    lastModified: Optional[AwareDatetime] = None
    location: Optional[str] = None


class ScimGroup(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    schemas: Annotated[
        List[str], Field(description='SCIM schemas used for this resource')
    ]
    id: Annotated[
        Optional[str], Field(None, description='Unique identifier for the group')
    ]
    displayName: Annotated[str, Field(description='Human-readable name of the group')]
    externalId: Annotated[
        Optional[str], Field(None, description='External system identifier')
    ]
    active: Annotated[
        Optional[bool], Field(None, description='Whether the group is active')
    ]
    members: Annotated[
        Optional[List[Member]], Field(None, description='Members of the group')
    ]
    meta: Annotated[Optional[Meta], Field(None, description='Metadata about the group')]
