# generated by datamodel-codegen:
#   filename:  api/services/createPipelineService.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import pipelineService
from ...type import basic, entityReference, entityReferenceList, lifeCycle, tagLabel


class CreatePipelineServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this pipeline service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of pipeline service entity.'),
    ]
    serviceType: pipelineService.PipelineServiceType
    connection: Optional[pipelineService.PipelineConnection] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Pipeline Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this pipeline service.'),
    ]
    scheduleInterval: Annotated[
        Optional[str],
        Field(None, description='Scheduler Interval for the pipeline in cron format.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Pipeline Service belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
