# generated by datamodel-codegen:
#   filename:  configuration/cacheConfiguration.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class AwsConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    region: Annotated[Optional[str], Field(None, description='AWS region')]
    accessKey: Annotated[
        Optional[str],
        Field(
            None,
            description='AWS access key (used when authType is PASSWORD for ElastiCache)',
        ),
    ]
    secretKey: Annotated[
        Optional[str],
        Field(
            None,
            description='AWS secret key (used when authType is PASSWORD for ElastiCache)',
        ),
    ]
    useIamRole: Annotated[
        Optional[bool],
        Field(False, description='Set to true to use IAM role based authentication'),
    ]


class AzureConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    resourceGroup: Annotated[
        Optional[str], Field(None, description='Azure resource group')
    ]
    subscriptionId: Annotated[
        Optional[str], Field(None, description='Azure subscription ID')
    ]
    useManagedIdentity: Annotated[
        Optional[bool],
        Field(
            False,
            description='Set to true to use Azure Managed Identity authentication',
        ),
    ]


class CacheProvider(Enum):
    REDIS_STANDALONE = 'REDIS_STANDALONE'
    REDIS_CLUSTER = 'REDIS_CLUSTER'
    ELASTICACHE_STANDALONE = 'ELASTICACHE_STANDALONE'
    ELASTICACHE_CLUSTER = 'ELASTICACHE_CLUSTER'
    AZURE_REDIS = 'AZURE_REDIS'


class AuthType(Enum):
    PASSWORD = 'PASSWORD'
    IAM = 'IAM'
    AZURE_MANAGED_IDENTITY = 'AZURE_MANAGED_IDENTITY'


class CacheConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[bool, Field(description='Enable/disable the cache layer')]
    provider: Optional[CacheProvider] = CacheProvider.REDIS_STANDALONE
    host: Annotated[
        Optional[str], Field(None, description='Redis host / cluster endpoint')
    ]
    port: Annotated[Optional[int], Field(6379, description='Redis port number')]
    authType: Optional[AuthType] = AuthType.PASSWORD
    password: Annotated[
        Optional[str],
        Field(None, description='Auth password / key (used when authType is PASSWORD)'),
    ]
    useSsl: Annotated[
        Optional[bool], Field(False, description='Use SSL/TLS for Redis connection')
    ]
    database: Annotated[
        Optional[int],
        Field(
            0,
            description='Redis database number (not applicable for cluster mode)',
            ge=0,
            le=15,
        ),
    ]
    ttlSeconds: Annotated[
        Optional[int],
        Field(
            3600,
            description='Default TTL for cache entries in seconds (0 = no expiry)',
            ge=0,
        ),
    ]
    connectionTimeoutSecs: Annotated[
        Optional[int], Field(5, description='Connection timeout in seconds')
    ]
    socketTimeoutSecs: Annotated[
        Optional[int], Field(60, description='Socket timeout in seconds')
    ]
    maxRetries: Annotated[
        Optional[int], Field(3, description='Maximum number of retry attempts')
    ]
    warmupEnabled: Annotated[
        Optional[bool], Field(True, description='Enable cache warmup on startup')
    ]
    warmupBatchSize: Annotated[
        Optional[int],
        Field(100, description='Batch size for cache warmup operations', ge=1),
    ]
    warmupThreads: Annotated[
        Optional[int], Field(2, description='Number of threads for cache warmup', ge=1)
    ]
    awsConfig: Annotated[
        Optional[AwsConfig],
        Field(None, description='AWS-specific configuration for ElastiCache'),
    ]
    azureConfig: Annotated[
        Optional[AzureConfig],
        Field(
            None, description='Azure-specific configuration for Azure Cache for Redis'
        ),
    ]
