# generated by datamodel-codegen:
#   filename:  configuration/workflowSettings.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class ExecutorConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    corePoolSize: Annotated[
        Optional[int],
        Field(
            10,
            description='Default worker Pool Size. The Workflow Executor by default has this amount of workers.',
        ),
    ]
    maxPoolSize: Annotated[
        Optional[int],
        Field(
            20,
            description='Maximum worker Pool Size. The Workflow Executor could grow up to this number of workers.',
        ),
    ]
    queueSize: Annotated[
        Optional[int],
        Field(
            1000,
            description='Amount of Tasks that can be queued to be picked up by the Workflow Executor.',
        ),
    ]
    tasksDuePerAcquisition: Annotated[
        Optional[int],
        Field(
            20,
            description='The amount of Tasks that the Workflow Executor is able to pick up each time it looks for more.',
        ),
    ]
    jobLockTimeInMillis: Annotated[
        Optional[int],
        Field(
            1296000000,
            description='The amount of time a Job gets locked before being retried. Default: 15 Days. This avoids jobs that takes too long to run being retried while running.',
        ),
    ]


class HistoryCleanUpConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cleanAfterNumberOfDays: Annotated[
        Optional[int],
        Field(
            7,
            description='Cleans the Workflow Task that were finished, after given number of days.',
        ),
    ]


class WorkflowSettings(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    executorConfiguration: Annotated[
        Optional[ExecutorConfiguration],
        Field(None, description='Used to set up the Workflow Executor Settings.'),
    ]
    historyCleanUpConfiguration: Annotated[
        Optional[HistoryCleanUpConfiguration],
        Field(None, description='Used to set up the History CleanUp Settings.'),
    ]
