# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/metadataExporterConnectors/redshiftConnection.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from ......security.ssl import verifySSLConfig
from .....services.connections import connectionBasicType


class RedshiftType(Enum):
    Redshift = 'Redshift'


class RedshiftScheme(Enum):
    redshift_psycopg2 = 'redshift+psycopg2'


class RedshiftConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[RedshiftType],
        Field(RedshiftType.Redshift, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[RedshiftScheme],
        Field(
            RedshiftScheme.redshift_psycopg2,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Redshift. This user should have privileges to read all the metadata in Redshift.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Redshift.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Redshift service.', title='Host and Port'
        ),
    ]
    database: Annotated[
        str,
        Field(
            description='Initial Redshift database to connect to. If you want to ingest all databases, set ingestAllDatabases to true.',
            title='Database',
        ),
    ]
    sslMode: Optional[verifySSLConfig.SslMode] = verifySSLConfig.SslMode.disable
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
