# generated by datamodel-codegen:
#   filename:  entity/data/apiEndpoint.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    apiSchema,
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import apiService


class ApiRequestMethod(Enum):
    GET = 'GET'
    POST = 'POST'
    PUT = 'PUT'
    PATCH = 'PATCH'
    DELETE = 'DELETE'
    HEAD = 'HEAD'
    CONNECT = 'CONNECT'
    OPTIONS = 'OPTIONS'
    TRACE = 'TRACE'


class APIEndpoint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies a API Endpoint instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this API Endpoint.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this API Endpoint.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="A unique name that identifies a API Collection in the format 'ServiceName.ApiCollectionName.APIEndpoint'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the API Endpoint, what it is, and how to use it.',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    endpointURL: Annotated[
        AnyUrl,
        Field(
            description='EndPoint URL for the API Collection. Capture the Root URL of the collection.',
            title='Endpoint URL',
        ),
    ]
    requestMethod: Annotated[
        Optional[ApiRequestMethod],
        Field(ApiRequestMethod.GET, description='Request Method for the API Endpoint.'),
    ]
    requestSchema: Annotated[
        Optional[apiSchema.APISchema],
        Field(None, description='Request Schema for the API Endpoint.'),
    ]
    responseSchema: Annotated[
        Optional[apiSchema.APISchema],
        Field(None, description='Response Schema for the API Endpoint.'),
    ]
    apiCollection: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to API Collection that contains this API Endpoint.',
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this API Collection.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this API Collection.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this API Collection.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to service where this API Collection is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[apiService.ApiServiceType],
        Field(None, description='Service type where this API Collection is hosted in.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the API Collection belongs to. When not set, the API Collection inherits the domain from the API service it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
