# generated by datamodel-codegen:
#   filename:  entity/data/metric.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReferenceList,
    tagLabel,
    votes,
)


class Language(Enum):
    SQL = 'SQL'
    Java = 'Java'
    JavaScript = 'JavaScript'
    Python = 'Python'
    External = 'External'


class MetricExpression(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    language: Annotated[
        Optional[Language],
        Field(
            None,
            description='This schema defines the type of the language used for Metric Expression Code.',
        ),
    ]
    code: Annotated[
        Optional[str],
        Field(
            None,
            description="This schema defines the type of the language used for Metric Formula's Code.",
        ),
    ]


class MetricType(Enum):
    COUNT = 'COUNT'
    SUM = 'SUM'
    AVERAGE = 'AVERAGE'
    RATIO = 'RATIO'
    PERCENTAGE = 'PERCENTAGE'
    MIN = 'MIN'
    MAX = 'MAX'
    MEDIAN = 'MEDIAN'
    MODE = 'MODE'
    STANDARD_DEVIATION = 'STANDARD_DEVIATION'
    VARIANCE = 'VARIANCE'
    OTHER = 'OTHER'


class UnitOfMeasurement(Enum):
    COUNT = 'COUNT'
    DOLLARS = 'DOLLARS'
    PERCENTAGE = 'PERCENTAGE'
    TIMESTAMP = 'TIMESTAMP'
    SIZE = 'SIZE'
    REQUESTS = 'REQUESTS'
    EVENTS = 'EVENTS'
    TRANSACTIONS = 'TRANSACTIONS'


class MetricGranularity(Enum):
    SECOND = 'SECOND'
    MINUTE = 'MINUTE'
    HOUR = 'HOUR'
    DAY = 'DAY'
    WEEK = 'WEEK'
    MONTH = 'MONTH'
    QUARTER = 'QUARTER'
    YEAR = 'YEAR'


class Metric(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies this Metric instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this Metric instance uniquely.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="A unique name that identifies a metric in the format 'ServiceName.MetricName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this metric.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of metrics instance, what it is, and how to use it.',
        ),
    ]
    metricExpression: Annotated[
        Optional[MetricExpression],
        Field(None, description='Expression used to compute the metric.'),
    ]
    metricType: Annotated[
        Optional[MetricType], Field(None, description='Type of the metric.')
    ]
    unitOfMeasurement: Annotated[
        Optional[UnitOfMeasurement],
        Field(None, description='Unit of measurement for the metric.'),
    ]
    granularity: Annotated[
        Optional[MetricGranularity], Field(None, description="Metric's granularity.")
    ]
    relatedMetrics: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Related Metrics.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this metrics.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this API Collection.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]], Field([], description='Tags for this chart.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Glossary belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
