# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/domoDashboardConnection.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class DomoDashboardType(Enum):
    DomoDashboard = 'DomoDashboard'


class DomoDashboardConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DomoDashboardType],
        Field(
            DomoDashboardType.DomoDashboard,
            description='Service Type',
            title='Service Type',
        ),
    ]
    clientId: Annotated[str, Field(description='Client ID for DOMO', title='Client ID')]
    secretToken: Annotated[
        CustomSecretStr,
        Field(description='Secret Token to connect DOMO', title='Secret Token'),
    ]
    accessToken: Annotated[
        Optional[str],
        Field(
            None, description='Access token to connect to DOMO', title='Access Token'
        ),
    ]
    apiHost: Annotated[
        Optional[str],
        Field(
            'api.domo.com',
            description='API Host to connect to DOMO instance',
            title='API Host',
        ),
    ]
    instanceDomain: Annotated[
        AnyUrl,
        Field(
            description='URL of your Domo instance, e.g., https://openmetadata.domo.com',
            title='Instance Domain',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
