# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/alationConnection.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import apiAccessTokenAuth, basicAuth
from .....type import filterPattern
from .. import connectionBasicType
from ..database import mysqlConnection, postgresConnection


class AlationType(Enum):
    Alation = 'Alation'


class AlationConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AlationType], Field(AlationType.Alation, description='Service Type')
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and port of the Alation service.', title='Host and Port'
        ),
    ]
    authType: Annotated[
        Union[basicAuth.BasicAuth, apiAccessTokenAuth.ApiAccessTokenAuth],
        Field(
            description='Types of methods used to authenticate to the alation instance',
            title='Authentication type for Alation',
        ),
    ]
    connection: Annotated[
        Optional[
            Union[
                postgresConnection.PostgresConnection,
                mysqlConnection.MysqlConnection,
                Dict[str, Any],
            ]
        ],
        Field(
            None,
            description='Choose between mysql and postgres connection for alation database',
            title='Alation Database Connection',
        ),
    ]
    projectName: Annotated[
        Optional[str],
        Field(
            'AlationAPI',
            description='Project name to create the refreshToken. Can be anything',
            title='Project Name',
        ),
    ]
    paginationLimit: Annotated[
        Optional[int],
        Field(
            10,
            description='Pagination limit used for Alation APIs pagination',
            title='Pagination Limit',
        ),
    ]
    includeUndeployedDatasources: Annotated[
        Optional[bool],
        Field(
            False,
            description='Specifies if undeployed datasources should be included while ingesting.',
            title='Include Undeployed Datasources',
        ),
    ]
    includeHiddenDatasources: Annotated[
        Optional[bool],
        Field(
            False,
            description='Specifies if hidden datasources should be included while ingesting.',
            title='Include Hidden Datasources',
        ),
    ]
    ingestDatasources: Annotated[
        Optional[bool],
        Field(
            True,
            description='Specifies if Datasources are to be ingested while running the ingestion job.',
            title='Ingest Datasources',
        ),
    ]
    ingestUsersAndGroups: Annotated[
        Optional[bool],
        Field(
            True,
            description='Specifies if Users and Groups are to be ingested while running the ingestion job.',
            title='Ingest Users and Groups',
        ),
    ]
    ingestDomains: Annotated[
        Optional[bool],
        Field(
            True,
            description='Specifies if Domains are to be ingested while running the ingestion job.',
            title='Ingest Domains',
        ),
    ]
    ingestKnowledgeArticles: Annotated[
        Optional[bool],
        Field(
            True,
            description='Specifies if Knowledge Articles are to be ingested while running the ingestion job.',
            title='Ingest Knowledge Articles',
        ),
    ]
    ingestDashboards: Annotated[
        Optional[bool],
        Field(
            True,
            description='Specifies if Dashboards are to be ingested while running the ingestion job.',
            title='Ingest Dashboards',
        ),
    ]
    alationTagClassificationName: Annotated[
        Optional[str],
        Field(
            'alationTags',
            description='Custom OpenMetadata Classification name for alation tags.',
            title='Alation Tags Classification Name',
        ),
    ]
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
