# generated by datamodel-codegen:
#   filename:  entity/services/connections/security/rangerConnection.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .ranger import basicAuth


class RangerType(Enum):
    Ranger = 'Ranger'


class RangerConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[RangerType],
        Field(RangerType.Ranger, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Apache Ranger Admin URL.', title='Host and Port')
    ]
    authType: Annotated[
        basicAuth.RangerBasicAuth,
        Field(
            description='Authentication type to connect to Apache Ranger.',
            title='Authentication Type',
        ),
    ]
