# generated by datamodel-codegen:
#   filename:  entity/services/connections/testConnectionDefinition.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....type import basic, entityHistory, entityReferenceList


class TestConnectionStep(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='Name of the step being tested')]
    description: Annotated[str, Field(description='What is the goal of the step')]
    errorMessage: Annotated[
        Optional[str],
        Field(
            None,
            description='In case of error this message should be displayed on UI, We define this message manually on test connection definition',
        ),
    ]
    mandatory: Annotated[
        bool, Field(description='Is this step mandatory to be passed?')
    ]
    shortCircuit: Annotated[
        Optional[bool],
        Field(
            False,
            description='This field if set to true, indicates that the step is important enough to break the process in case of failure.',
        ),
    ]


class TestConnectionDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(
            None, description='Unique identifier of this test case definition instance.'
        ),
    ]
    name: Annotated[
        basic.EntityName,
        Field(
            description='Name of the Test Connection Definition. It should be the `type` of the service being tested, e.g., Mysql, or Snowflake.'
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test definition.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the test connection def.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    steps: Annotated[
        List[TestConnectionStep],
        Field(description='Steps to test the connection. Order matters.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this TestConnection definition.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
