# generated by datamodel-codegen:
#   filename:  entity/services/driveService.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from .connections import testConnectionResult
from .connections.drive import (
    customDriveConnection,
    googleDriveConnection,
    sharePointConnection,
)


class DriveServiceType(Enum):
    GoogleDrive = 'GoogleDrive'
    SharePoint = 'SharePoint'
    CustomDrive = 'CustomDrive'


class DriveConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[
            googleDriveConnection.GoogleDriveConnection,
            sharePointConnection.SharePointConnection,
            customDriveConnection.CustomDriveConnection,
        ]
    ] = None


class DriveService(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of this drive service instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this drive service.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this drive service.'),
    ]
    serviceType: Annotated[
        DriveServiceType,
        Field(description='Type of drive service such as Google Drive...'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of a drive service instance.'),
    ]
    connection: Optional[DriveConnection] = None
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this drive service to extract metadata, usage, lineage etc..',
        ),
    ]
    testConnectionResult: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Last test connection results for this service'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this drive Service.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Link to the resource corresponding to this drive service.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this drive service.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Drive service belongs to.'),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
