# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/triggers/eventBasedEntityTrigger.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Event(Enum):
    Created = 'Created'
    Updated = 'Updated'


class Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityType: Annotated[
        str, Field(description='Entity Type for which it should be triggered.')
    ]
    events: Annotated[List[Event], Field(title='Events')]
    exclude: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Select fields that should not trigger the workflow if only them are modified.',
            title='Exclude Fields',
        ),
    ]
    filter: Annotated[
        Optional[str],
        Field(
            None,
            description='JSON Logic expression to determine if the workflow should be triggered. The expression has access to: entity (current entity), changeDescription (what changed), updatedBy (user who made the change), changedFields (array of field names that changed).',
            title='Filter Condition',
        ),
    ]


class EventBasedEntityTriggerDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Optional[str] = 'eventBasedEntity'
    config: Optional[Config] = None
    output: Annotated[
        Optional[List[str]], Field(['relatedEntity'], max_length=1, min_length=1)
    ]
