# generated by datamodel-codegen:
#   filename:  metadataIngestion/engine/sparkEngineConfig.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class Type(Enum):
    Spark = 'Spark'


class Config(BaseModel):
    tempPath: Annotated[
        Optional[str],
        Field('/tmp/openmetadata', description='Temporary path to store the data.'),
    ]
    extraConfig: Annotated[
        Optional[basic.Map],
        Field(
            None,
            description='Additional Spark configuration properties as key-value pairs.',
            title='Additional Spark Configuration',
        ),
    ]


class SparkEngineConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    remote: Annotated[str, Field(description='Spark Connect Remote URL.')]
    config: Optional[Config] = None
