# generated by datamodel-codegen:
#   filename:  metadataIngestion/pipelineServiceMetadataPipeline.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class LineageInformation(BaseModel):
    dbServiceNames: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of Database Service Names for creation of lineage',
            title='Database Service Names List',
        ),
    ]
    storageServiceNames: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of Storage Service Names for creation of lineage',
            title='Storage Service Names List',
        ),
    ]


class PipelineMetadataConfigType(Enum):
    PipelineMetadata = 'PipelineMetadata'


class PipelineServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[PipelineMetadataConfigType],
        Field(PipelineMetadataConfigType.PipelineMetadata, description='Pipeline type'),
    ]
    includeLineage: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching lineage from pipelines.',
            title='Include Lineage',
        ),
    ]
    includeOwners: Annotated[
        Optional[bool],
        Field(
            True,
            description="Set the 'Include Owners' toggle to control whether to include owners to the ingested entity if the owner email matches with a user stored in the OM server as part of metadata ingestion. If the ingested entity already exists and has an owner, the owner will not be overwritten.",
            title='Include Owners',
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Pipeline Filter Pattern',
        ),
    ]
    lineageInformation: Annotated[
        Optional[LineageInformation],
        Field(
            None,
            description='Details required to generate Lineage',
            title='Lineage Information',
        ),
    ]
    overrideLineage: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Lineage' toggle to control whether to override the existing lineage.",
            title='Override Lineage',
        ),
    ]
    markDeletedPipelines: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete Pipelines in OpenMetadata if the source Pipelines are deleted. Also, if the Pipeline is deleted, all the associated entities like lineage, etc., with that Pipeline will be deleted',
            title='Mark Deleted Pipeline',
        ),
    ]
    includeTags: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the tags ingestion.',
            title='Include Tags',
        ),
    ]
    includeUnDeployedPipelines: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle whether the un-deployed pipelines should be ingested or not. If set to false, only deployed pipelines will be ingested.',
            title='Include UnDeployed Pipelines',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
