# generated by datamodel-codegen:
#   filename:  type/entityProfile.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table
from . import basic, entityReference


class ProfileTypeEnum(Enum):
    column = 'column'
    table = 'table'
    system = 'system'


class EntityProfile(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this profile instance')
    ]
    entityReference: Annotated[
        entityReference.EntityReference,
        Field(description='Reference to the entity for which this profile is created.'),
    ]
    timestamp: Annotated[
        basic.Timestamp, Field(description='Data one which test case result is taken.')
    ]
    profileData: Annotated[
        Union[table.TableProfile, table.ColumnProfile, table.SystemProfile],
        Field(description='Profile data specific to the entity type.'),
    ]
    profileType: Annotated[
        Optional[ProfileTypeEnum], Field(None, description='type of profile')
    ]
