# generated by datamodel-codegen:
#   filename:  type/function.json
#   timestamp: 2025-10-02T06:38:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class ParameterType(Enum):
    NotRequired = 'NotRequired'
    AllIndexElasticSearch = 'AllIndexElasticSearch'
    SpecificIndexElasticSearch = 'SpecificIndexElasticSearch'
    ReadFromParamContext = 'ReadFromParamContext'
    ReadFromParamContextPerEntity = 'ReadFromParamContextPerEntity'


class ParamAdditionalContext(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    data: Annotated[Optional[Any], Field(None, description='List of Entities')]


class Function(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Name of the function.')]
    input: Annotated[
        Optional[str],
        Field(None, description='Description of input taken by the function.'),
    ]
    description: Annotated[
        Optional[str], Field(None, description='Description for the function.')
    ]
    examples: Annotated[
        Optional[List],
        Field(
            None,
            description='Examples of the function to help users author conditions.',
        ),
    ]
    parameterInputType: Annotated[
        Optional[ParameterType],
        Field(None, description='List of receivers to send mail to'),
    ]
    paramAdditionalContext: Optional[ParamAdditionalContext] = None
