"""
Historical and reference implementations of map-folding algorithms.

This directory contains various implementations of the map-folding algorithm,
serving both as historical references and as benchmarks for performance comparison.
These implementations range from direct translations of Lunnon's original 1971 code
to highly specialized versions using modern optimization techniques.

Categories of reference implementations:

1. Historical transcripts:
   - foldings.txt - Original algorithm from Lunnon's 1971 paper
   - foldings.AA - Reconstructed Atlas Autocode version with corrections

2. Direct translations:
   - lunnonWhile.py - Python translation using while loops
   - lunnonNumpy.py - NumPy-based translation with array operations

3. Alternative implementations:
   - irvineJavaPort.py - Port from Sean A. Irvine's Java implementation
   - hunterNumba.py - Numba-optimized implementation
   - jaxCount.py - JAX implementation for GPU acceleration
   - flattened.py - Semantically decomposed version with operation grouping

4. Specialized variants:
   - total_countPlus1vsPlusN.py - Optimized counting with different increment strategies
   - rotatedEntryPoint.py - Alternative entry point implementation (demonstration)

5. Published computations:
   - jobsCompleted/ - Contains the source code and results of significant new computations:
     - [2,19] - First-ever computation of the 2x19 map (completed Jan 2025)
     - [2,20] - First-ever computation of the 2x20 map (completed Jan 2025)
     - These calculations extend the known values for OEIS sequence A001415

These reference implementations are valuable for:
- Understanding the algorithm's historical development
- Comparing performance characteristics across implementation strategies
- Studying optimization techniques and their effects
- Verifying the correctness of the core algorithm against known solutions
- Reproducing published computational results that extend mathematical knowledge

Note: These implementations are for reference only and not used in the production
code path of the package. The active implementation resides in theDao.py with
optimized variants generated by the someAssemblyRequired framework.
"""
