# generated by datamodel-codegen:
#   filename:  bom-1.6.schema.json
#   timestamp: 2024-11-07T23:10:33+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated, List, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, EmailStr, Field, RootModel

from . import spdx


class BomFormat(Enum):
    CycloneDX = "CycloneDX"


class Confidence(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    score: Annotated[
        Optional[float],
        Field(
            description="The confidence of the claim between and inclusive of 0 and 1, where 1 is 100% confidence.",
            ge=0.0,
            le=1.0,
            title="Score",
        ),
    ] = None
    rationale: Annotated[
        Optional[str],
        Field(description="The rationale for the confidence score.", title="Rationale"),
    ] = None


class RefType(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="Identifier for referable and therefore interlinkable elements.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            min_length=1,
        ),
    ]


class RefLinkType(RootModel[RefType]):
    root: Annotated[
        RefType,
        Field(
            description="Descriptor for an element identified by the attribute 'bom-ref' in the same BOM document.\nIn contrast to `bomLinkElementType`."
        ),
    ]


class BomLinkDocumentType(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="Descriptor for another BOM document. See https://cyclonedx.org/capabilities/bomlink/",
            pattern="^urn:cdx:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/[1-9][0-9]*$",
            title="BOM-Link Document",
        ),
    ]


class BomLinkElementType(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="Descriptor for an element in a BOM document. See https://cyclonedx.org/capabilities/bomlink/",
            pattern="^urn:cdx:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/[1-9][0-9]*#.+$",
            title="BOM-Link Element",
        ),
    ]


class BomLink(RootModel[Union[BomLinkDocumentType, BomLinkElementType]]):
    root: Annotated[Union[BomLinkDocumentType, BomLinkElementType], Field(title="BOM-Link")]


class Phase(Enum):
    design = "design"
    pre_build = "pre-build"
    build = "build"
    post_build = "post-build"
    operations = "operations"
    discovery = "discovery"
    decommission = "decommission"


class Lifecycles(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    phase: Annotated[
        Phase, Field(description="A pre-defined phase in the product lifecycle.", title="Phase")
    ]


class Lifecycles1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[str, Field(description="The name of the lifecycle phase", title="Name")]
    description: Annotated[
        Optional[str],
        Field(description="The description of the lifecycle phase", title="Description"),
    ] = None


class OrganizationalContact(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of a contact", examples=["Contact name"], title="Name"),
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(
            description="The email address of the contact.",
            examples=["firstname.lastname@example.com"],
            title="Email Address",
        ),
    ] = None
    phone: Annotated[
        Optional[str],
        Field(
            description="The phone number of the contact.",
            examples=["800-555-1212"],
            title="Phone",
        ),
    ] = None


class Type(Enum):
    application = "application"
    framework = "framework"
    library = "library"
    container = "container"
    platform = "platform"
    operating_system = "operating-system"
    device = "device"
    device_driver = "device-driver"
    firmware = "firmware"
    file = "file"
    machine_learning_model = "machine-learning-model"
    data = "data"
    cryptographic_asset = "cryptographic-asset"


class Scope(Enum):
    required = "required"
    optional = "optional"
    excluded = "excluded"


class Encoding(Enum):
    base64 = "base64"


class Attachment(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    contentType: Annotated[
        Optional[str],
        Field(
            description="Specifies the format and nature of the data being attached, helping systems correctly interpret and process the content. Common content type examples include `application/json` for JSON data and `text/plain` for plan text documents.\n [RFC 2045 section 5.1](https://www.ietf.org/rfc/rfc2045.html#section-5.1) outlines the structure and use of content types. For a comprehensive list of registered content types, refer to the [IANA media types registry](https://www.iana.org/assignments/media-types/media-types.xhtml).",
            examples=["text/plain", "application/json", "image/png"],
            title="Content-Type",
        ),
    ] = "text/plain"
    encoding: Annotated[
        Optional[Encoding],
        Field(
            description="Specifies the optional encoding the text is represented in.",
            title="Encoding",
        ),
    ] = None
    content: Annotated[
        str,
        Field(
            description="The attachment data. Proactive controls such as input validation and sanitization should be employed to prevent misuse of attachment text.",
            title="Attachment Text",
        ),
    ]


class HashAlg(Enum):
    MD5 = "MD5"
    SHA_1 = "SHA-1"
    SHA_256 = "SHA-256"
    SHA_384 = "SHA-384"
    SHA_512 = "SHA-512"
    SHA3_256 = "SHA3-256"
    SHA3_384 = "SHA3-384"
    SHA3_512 = "SHA3-512"
    BLAKE2b_256 = "BLAKE2b-256"
    BLAKE2b_384 = "BLAKE2b-384"
    BLAKE2b_512 = "BLAKE2b-512"
    BLAKE3 = "BLAKE3"


class HashContent(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="The value of the hash.",
            examples=["3942447fac867ae5cdb3229b658f4d48"],
            pattern="^([a-fA-F0-9]{32}|[a-fA-F0-9]{40}|[a-fA-F0-9]{64}|[a-fA-F0-9]{96}|[a-fA-F0-9]{128})$",
            title="Hash Value",
        ),
    ]


class LicenseType(Enum):
    academic = "academic"
    appliance = "appliance"
    client_access = "client-access"
    concurrent_user = "concurrent-user"
    core_points = "core-points"
    custom_metric = "custom-metric"
    device = "device"
    evaluation = "evaluation"
    named_user = "named-user"
    node_locked = "node-locked"
    oem = "oem"
    perpetual = "perpetual"
    processor_points = "processor-points"
    subscription = "subscription"
    user = "user"
    other = "other"


class LicenseAcknowledgementEnumeration(Enum):
    declared = "declared"
    concluded = "concluded"


class LicenseChoice(RootModel[List]):
    root: Annotated[
        List,
        Field(
            description="EITHER (list of SPDX licenses and/or named licenses) OR (tuple of one SPDX License Expression)",
            title="License Choice",
        ),
    ]


class Type1(Enum):
    unofficial = "unofficial"
    monkey = "monkey"
    backport = "backport"
    cherry_pick = "cherry-pick"


class Diff(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    text: Annotated[
        Optional[Attachment],
        Field(description="Specifies the optional text of the diff", title="Diff text"),
    ] = None
    url: Annotated[
        Optional[str], Field(description="Specifies the URL to the diff", title="URL")
    ] = None


class Type2(Enum):
    defect = "defect"
    enhancement = "enhancement"
    security = "security"


class Source(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source.",
            examples=["National Vulnerability Database", "NVD", "Apache"],
            title="Name",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The url of the issue documentation as provided by the source", title="URL"
        ),
    ] = None


class Issue(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[Type2, Field(description="Specifies the type of issue", title="Issue Type")]
    id: Annotated[
        Optional[str],
        Field(
            description="The identifier of the issue assigned by the source of the issue",
            title="Issue ID",
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the issue", title="Issue Name")
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the issue", title="Issue Description")
    ] = None
    source: Annotated[
        Optional[Source],
        Field(description="The source of the issue where it is documented", title="Source"),
    ] = None
    references: Annotated[
        Optional[List[str]],
        Field(
            description="A collection of URL's for reference. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="References",
        ),
    ] = None


class IdentifiableAction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    timestamp: Annotated[
        Optional[datetime],
        Field(description="The timestamp in which the action occurred", title="Timestamp"),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the individual who performed the action", title="Name"),
    ] = None
    email: Annotated[
        Optional[EmailStr],
        Field(
            description="The email address of the individual who performed the action",
            title="E-mail",
        ),
    ] = None


class Type3(Enum):
    vcs = "vcs"
    issue_tracker = "issue-tracker"
    website = "website"
    advisories = "advisories"
    bom = "bom"
    mailing_list = "mailing-list"
    social = "social"
    chat = "chat"
    documentation = "documentation"
    support = "support"
    source_distribution = "source-distribution"
    distribution = "distribution"
    distribution_intake = "distribution-intake"
    license = "license"
    build_meta = "build-meta"
    build_system = "build-system"
    release_notes = "release-notes"
    security_contact = "security-contact"
    model_card = "model-card"
    log = "log"
    configuration = "configuration"
    evidence = "evidence"
    formulation = "formulation"
    attestation = "attestation"
    threat_model = "threat-model"
    adversary_model = "adversary-model"
    risk_assessment = "risk-assessment"
    vulnerability_assertion = "vulnerability-assertion"
    exploitability_statement = "exploitability-statement"
    pentest_report = "pentest-report"
    static_analysis_report = "static-analysis-report"
    dynamic_analysis_report = "dynamic-analysis-report"
    runtime_analysis_report = "runtime-analysis-report"
    component_analysis_report = "component-analysis-report"
    maturity_report = "maturity-report"
    certification_report = "certification-report"
    codified_infrastructure = "codified-infrastructure"
    quality_metrics = "quality-metrics"
    poam = "poam"
    electronic_signature = "electronic-signature"
    digital_signature = "digital-signature"
    rfc_9116 = "rfc-9116"
    other = "other"


class Dependency(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ref: Annotated[
        RefLinkType,
        Field(
            description="References a component or service by its bom-ref attribute",
            title="Reference",
        ),
    ]
    dependsOn: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The bom-ref identifiers of the components or services that are dependencies of this dependency object.",
            title="Depends On",
        ),
    ] = None
    provides: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The bom-ref identifiers of the components or services that define a given specification or standard, which are provided or implemented by this dependency object.\nFor example, a cryptographic library which implements a cryptographic algorithm. A component which implements another component does not imply that the implementation is in use.",
            title="Provides",
        ),
    ] = None


class DataFlowDirection(Enum):
    inbound = "inbound"
    outbound = "outbound"
    bi_directional = "bi-directional"
    unknown = "unknown"


class Copyright(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    text: Annotated[
        str, Field(description="The textual content of the copyright.", title="Copyright Text")
    ]


class Occurrence(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the occurrence elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    location: Annotated[
        str,
        Field(
            description="The location or path to where the component was found.", title="Location"
        ),
    ]
    line: Annotated[
        Optional[int],
        Field(
            description="The line number where the component was found.", ge=0, title="Line Number"
        ),
    ] = None
    offset: Annotated[
        Optional[int],
        Field(description="The offset where the component was found.", ge=0, title="Offset"),
    ] = None
    symbol: Annotated[
        Optional[str],
        Field(
            description="The symbol name that was found associated with the component.",
            title="Symbol",
        ),
    ] = None
    additionalContext: Annotated[
        Optional[str],
        Field(
            description="Any additional context of the detected component (e.g. a code snippet).",
            title="Additional Context",
        ),
    ] = None


class Frame(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    package: Annotated[
        Optional[str],
        Field(
            description="A package organizes modules into namespaces, providing a unique namespace for each type it contains.",
            title="Package",
        ),
    ] = None
    module: Annotated[
        str,
        Field(
            description="A module or class that encloses functions/methods and other code.",
            title="Module",
        ),
    ]
    function: Annotated[
        Optional[str],
        Field(
            description="A block of code designed to perform a particular task.", title="Function"
        ),
    ] = None
    parameters: Annotated[
        Optional[List[str]],
        Field(
            description="Optional arguments that are passed to the module or function.",
            title="Parameters",
        ),
    ] = None
    line: Annotated[
        Optional[int],
        Field(description="The line number the code that is called resides on.", title="Line"),
    ] = None
    column: Annotated[
        Optional[int],
        Field(description="The column the code that is called resides.", title="Column"),
    ] = None
    fullFilename: Annotated[
        Optional[str],
        Field(description="The full path and filename of the module.", title="Full Filename"),
    ] = None


class Callstack(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    frames: Annotated[
        Optional[List[Frame]],
        Field(
            description="Within a call stack, a frame is a discrete unit that encapsulates an execution context, including local variables, parameters, and the return address. As function calls are made, frames are pushed onto the stack, forming an array-like structure that orchestrates the flow of program execution and manages the sequence of function invocations.",
            title="Frames",
        ),
    ] = None


class AggregateType(Enum):
    complete = "complete"
    incomplete = "incomplete"
    incomplete_first_party_only = "incomplete_first_party_only"
    incomplete_first_party_proprietary_only = "incomplete_first_party_proprietary_only"
    incomplete_first_party_opensource_only = "incomplete_first_party_opensource_only"
    incomplete_third_party_only = "incomplete_third_party_only"
    incomplete_third_party_proprietary_only = "incomplete_third_party_proprietary_only"
    incomplete_third_party_opensource_only = "incomplete_third_party_opensource_only"
    unknown = "unknown"
    not_specified = "not_specified"


class Property(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[
        str,
        Field(
            description="The name of the property. Duplicate names are allowed, each potentially having a different value.",
            title="Name",
        ),
    ]
    value: Annotated[
        Optional[str], Field(description="The value of the property.", title="Value")
    ] = None


class LocaleType(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="Defines a syntax for representing two character language code (ISO-639) followed by an optional two character country code. The language code must be lower case. If the country code is specified, the country code must be upper case. The language code and country code must be separated by a minus sign. Examples: en, en-US, fr, fr-CA",
            pattern="^([a-z]{2})(-[A-Z]{2})?$",
            title="Locale",
        ),
    ]


class ReleaseType(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="The software versioning type. It is recommended that the release type use one of 'major', 'minor', 'patch', 'pre-release', or 'internal'. Representing all possible software release types is not practical, so standardizing on the recommended values, whenever possible, is strongly encouraged.\n\n* __major__ = A major release may contain significant changes or may introduce breaking changes.\n* __minor__ = A minor release, also known as an update, may contain a smaller number of changes than major releases.\n* __patch__ = Patch releases are typically unplanned and may resolve defects or important security issues.\n* __pre-release__ = A pre-release may include alpha, beta, or release candidates and typically have limited support. They provide the ability to preview a release prior to its general availability.\n* __internal__ = Internal releases are not for public consumption and are intended to be used exclusively by the project or manufacturer that produced it.",
            examples=["major", "minor", "patch", "pre-release", "internal"],
        ),
    ]


class Note(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    locale: Annotated[
        Optional[LocaleType],
        Field(
            description='The ISO-639 (or higher) language code and optional ISO-3166 (or higher) country code. Examples include: "en", "en-US", "fr" and "fr-CA"',
            title="Locale",
        ),
    ] = None
    text: Annotated[
        Attachment,
        Field(
            description="Specifies the full content of the release note.",
            title="Release note content",
        ),
    ]


class Advisory(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    title: Annotated[
        Optional[str], Field(description="An optional name of the advisory.", title="Title")
    ] = None
    url: Annotated[
        str, Field(description="Location where the advisory can be obtained.", title="URL")
    ]


class Cwe(RootModel[int]):
    root: Annotated[
        int,
        Field(
            description="Integer representation of a Common Weaknesses Enumerations (CWE). For example 399 (of https://cwe.mitre.org/data/definitions/399.html)",
            ge=1,
            title="CWE",
        ),
    ]


class Severity(Enum):
    critical = "critical"
    high = "high"
    medium = "medium"
    low = "low"
    info = "info"
    none = "none"
    unknown = "unknown"


class ScoreMethod(Enum):
    CVSSv2 = "CVSSv2"
    CVSSv3 = "CVSSv3"
    CVSSv31 = "CVSSv31"
    CVSSv4 = "CVSSv4"
    OWASP = "OWASP"
    SSVC = "SSVC"
    other = "other"


class ImpactAnalysisState(Enum):
    resolved = "resolved"
    resolved_with_pedigree = "resolved_with_pedigree"
    exploitable = "exploitable"
    in_triage = "in_triage"
    false_positive = "false_positive"
    not_affected = "not_affected"


class ImpactAnalysisJustification(Enum):
    code_not_present = "code_not_present"
    code_not_reachable = "code_not_reachable"
    requires_configuration = "requires_configuration"
    requires_dependency = "requires_dependency"
    requires_environment = "requires_environment"
    protected_by_compiler = "protected_by_compiler"
    protected_at_runtime = "protected_at_runtime"
    protected_at_perimeter = "protected_at_perimeter"
    protected_by_mitigating_control = "protected_by_mitigating_control"


class VulnerabilitySource(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    url: Annotated[
        Optional[str],
        Field(
            description="The url of the vulnerability documentation as provided by the source.",
            examples=["https://nvd.nist.gov/vuln/detail/CVE-2021-39182"],
            title="URL",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the source.",
            examples=[
                "NVD",
                "National Vulnerability Database",
                "OSS Index",
                "VulnDB",
                "GitHub Advisories",
            ],
            title="Name",
        ),
    ] = None


class Reference(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: Annotated[
        str,
        Field(
            description="An identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ]
    source: Annotated[
        VulnerabilitySource, Field(description="The source that published the vulnerability.")
    ]


class ProofOfConcept(BaseModel):
    reproductionSteps: Annotated[
        Optional[str],
        Field(
            description="Precise steps to reproduce the vulnerability.", title="Steps to Reproduce"
        ),
    ] = None
    environment: Annotated[
        Optional[str],
        Field(
            description="A description of the environment in which reproduction was possible.",
            title="Environment",
        ),
    ] = None
    supportingMaterial: Annotated[
        Optional[List[Attachment]],
        Field(
            description="Supporting material that helps in reproducing or understanding how reproduction is possible. This may include screenshots, payloads, and PoC exploit code.",
            title="Supporting Material",
        ),
    ] = None


class ResponseEnum(Enum):
    can_not_fix = "can_not_fix"
    will_not_fix = "will_not_fix"
    update = "update"
    rollback = "rollback"
    workaround_available = "workaround_available"


class Analysis(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    state: Optional[ImpactAnalysisState] = None
    justification: Optional[ImpactAnalysisJustification] = None
    response: Annotated[
        Optional[List[ResponseEnum]],
        Field(
            description="A response to the vulnerability by the manufacturer, supplier, or project responsible for the affected component or service. More than one response is allowed. Responses are strongly encouraged for vulnerabilities where the analysis state is exploitable.",
            title="Response",
        ),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description="Detailed description of the impact including methods used during assessment. If a vulnerability is not exploitable, this field should include specific details on why the component or service is not impacted by this vulnerability.",
            title="Detail",
        ),
    ] = None
    firstIssued: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the analysis was first issued.",
            title="First Issued",
        ),
    ] = None
    lastUpdated: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the analysis was last updated.",
            title="Last Updated",
        ),
    ] = None


class AffectedStatus(Enum):
    affected = "affected"
    unaffected = "unaffected"
    unknown = "unknown"


class Version(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="A single disjunctive version identifier, for a component or service.",
            examples=["9.0.14", "v1.33.7", "7.0.0-M1", "2.0pre1", "1.0.0-beta1", "0.8.15"],
            max_length=1024,
        ),
    ]


class VersionRange(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="A version range specified in Package URL Version Range syntax (vers) which is defined at https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst",
            examples=[
                "vers:cargo/9.0.14",
                "vers:npm/1.2.3|>=2.0.0|<5.0.0",
                "vers:pypi/0.0.0|0.0.1|0.0.2|0.0.3|1.0|2.0pre1",
                "vers:tomee/>=1.0.0-beta1|<=1.7.5|>=7.0.0-M1|<=7.0.7|>=7.1.0|<=7.1.2|>=8.0.0-M1|<=8.0.1",
                "vers:gem/>=2.2.0|!= 2.2.1|<2.3.0",
            ],
            max_length=4096,
            min_length=1,
        ),
    ]


class Range(RootModel[VersionRange]):
    root: Annotated[
        VersionRange,
        Field(description="Deprecated definition. use definition `versionRange` instead."),
    ]


class Type4(Enum):
    supervised = "supervised"
    unsupervised = "unsupervised"
    reinforcement_learning = "reinforcement-learning"
    semi_supervised = "semi-supervised"
    self_supervised = "self-supervised"


class Approach(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type4],
        Field(
            description="Learning types describing the learning problem or hybrid learning problem.",
            title="Learning Type",
        ),
    ] = None


class Datasets(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ref: Annotated[
        Optional[Union[RefLinkType, BomLinkElementType]],
        Field(
            description="References a data component by the components bom-ref attribute",
            title="Reference",
        ),
    ] = None


class InputOutputMLParameters(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    format: Annotated[
        Optional[str],
        Field(
            description="The data format for input/output to the model.",
            examples=["string", "image", "time-series"],
            title="Input/Output Format",
        ),
    ] = None


class Type5(Enum):
    source_code = "source-code"
    configuration = "configuration"
    dataset = "dataset"
    definition = "definition"
    other = "other"


class Contents1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    attachment: Annotated[
        Optional[Attachment],
        Field(
            description="An optional way to include textual or encoded data.",
            title="Data Attachment",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(description="The URL to where the data can be retrieved.", title="Data URL"),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document name-value parameters used for configuration.",
            title="Configuration Properties",
        ),
    ] = None


class Graphic(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[Optional[str], Field(description="The name of the graphic.", title="Name")] = (
        None
    )
    image: Annotated[
        Optional[Attachment],
        Field(
            description="The graphic (vector or raster). Base64 encoding must be specified for binary images.",
            title="Graphic Image",
        ),
    ] = None


class ConfidenceInterval(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    lowerBound: Annotated[
        Optional[str],
        Field(description="The lower bound of the confidence interval.", title="Lower Bound"),
    ] = None
    upperBound: Annotated[
        Optional[str],
        Field(description="The upper bound of the confidence interval.", title="Upper Bound"),
    ] = None


class PerformanceMetric(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[str], Field(description="The type of performance metric.", title="Type")
    ] = None
    value: Annotated[
        Optional[str], Field(description="The value of the performance metric.", title="Value")
    ] = None
    slice: Annotated[
        Optional[str],
        Field(
            description="The name of the slice this metric was computed on. By default, assume this metric is not sliced.",
            title="Slice",
        ),
    ] = None
    confidenceInterval: Annotated[
        Optional[ConfidenceInterval],
        Field(description="The confidence interval of the metric.", title="Confidence Interval"),
    ] = None


class Risk(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[Optional[str], Field(description="The name of the risk.", title="Name")] = None
    mitigationStrategy: Annotated[
        Optional[str],
        Field(description="Strategy used to address this risk.", title="Mitigation Strategy"),
    ] = None


class FairnessAssessment(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    groupAtRisk: Annotated[
        Optional[str],
        Field(
            description="The groups or individuals at risk of being systematically disadvantaged by the model.",
            title="Group at Risk",
        ),
    ] = None
    benefits: Annotated[
        Optional[str],
        Field(description="Expected benefits to the identified groups.", title="Benefits"),
    ] = None
    harms: Annotated[
        Optional[str], Field(description="Expected harms to the identified groups.", title="Harms")
    ] = None
    mitigationStrategy: Annotated[
        Optional[str],
        Field(
            description="With respect to the benefits and harms outlined, please describe any mitigation strategy implemented.",
            title="Mitigation Strategy",
        ),
    ] = None


class DataClassification(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="Data classification tags data according to its type, sensitivity, and value if altered, stolen, or destroyed.",
            title="Data Classification",
        ),
    ]


class Activity(Enum):
    design = "design"
    data_collection = "data-collection"
    data_preparation = "data-preparation"
    training = "training"
    fine_tuning = "fine-tuning"
    validation = "validation"
    deployment = "deployment"
    inference = "inference"
    other = "other"


class Unit(Enum):
    kWh = "kWh"


class EnergyMeasure(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    value: Annotated[float, Field(description="Quantity of energy.", title="Value")]
    unit: Annotated[Unit, Field(description="Unit of energy.", title="Unit")]


class Unit1(Enum):
    tCO2eq = "tCO2eq"


class Co2Measure(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    value: Annotated[float, Field(description="Quantity of carbon dioxide (CO2).", title="Value")]
    unit: Annotated[Unit1, Field(description="Unit of carbon dioxide (CO2).", title="Unit")]


class EnergySource(Enum):
    coal = "coal"
    oil = "oil"
    natural_gas = "natural-gas"
    nuclear = "nuclear"
    wind = "wind"
    solar = "solar"
    geothermal = "geothermal"
    hydropower = "hydropower"
    biofuel = "biofuel"
    unknown = "unknown"
    other = "other"


class PostalAddress(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the address elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    country: Annotated[
        Optional[str],
        Field(
            description="The country name or the two-letter ISO 3166-1 country code.",
            title="Country",
        ),
    ] = None
    region: Annotated[
        Optional[str],
        Field(
            description="The region or state in the country.", examples=["Texas"], title="Region"
        ),
    ] = None
    locality: Annotated[
        Optional[str],
        Field(
            description="The locality or city within the country.",
            examples=["Austin"],
            title="Locality",
        ),
    ] = None
    postOfficeBoxNumber: Annotated[
        Optional[str],
        Field(
            description="The post office box number.",
            examples=["901"],
            title="Post Office Box Number",
        ),
    ] = None
    postalCode: Annotated[
        Optional[str],
        Field(description="The postal code.", examples=["78758"], title="Postal Code"),
    ] = None
    streetAddress: Annotated[
        Optional[str],
        Field(
            description="The street address.", examples=["100 Main Street"], title="Street Address"
        ),
    ] = None


class Command(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    executed: Annotated[
        Optional[str],
        Field(description="A text representation of the executed command.", title="Executed"),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class AccessMode(Enum):
    read_only = "read-only"
    read_write = "read-write"
    read_write_once = "read-write-once"
    write_once = "write-once"
    write_only = "write-only"


class Mode(Enum):
    filesystem = "filesystem"
    block = "block"


class Volume(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    uid: Annotated[
        Optional[str],
        Field(
            description="The unique identifier for the volume instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the volume instance", title="Name")
    ] = None
    mode: Annotated[
        Optional[Mode], Field(description="The mode for the volume instance.", title="Mode")
    ] = "filesystem"
    path: Annotated[
        Optional[str],
        Field(description="The underlying path created from the actual volume.", title="Path"),
    ] = None
    sizeAllocated: Annotated[
        Optional[str],
        Field(
            description="The allocated size of the volume accessible to the associated workspace. This should include the scalar size as well as IEC standard unit in either decimal or binary form.",
            examples=["10GB", "2Ti", "1Pi"],
            title="Size allocated",
        ),
    ] = None
    persistent: Annotated[
        Optional[bool],
        Field(
            description="Indicates if the volume persists beyond the life of the resource it is associated with.",
            title="Persistent",
        ),
    ] = None
    remote: Annotated[
        Optional[bool],
        Field(
            description="Indicates if the volume is remotely (i.e., network) attached.",
            title="Remote",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Type6(Enum):
    manual = "manual"
    api = "api"
    webhook = "webhook"
    scheduled = "scheduled"


class Type7(Enum):
    artifact = "artifact"
    attestation = "attestation"
    log = "log"
    evidence = "evidence"
    metrics = "metrics"
    other = "other"


class Condition(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    description: Annotated[
        Optional[str],
        Field(
            description="Describes the set of conditions which cause the trigger to activate.",
            title="Description",
        ),
    ] = None
    expression: Annotated[
        Optional[str],
        Field(
            description="The logical expression that was evaluated that determined the trigger should be fired.",
            title="Expression",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class TaskType(Enum):
    copy = "copy"
    clone = "clone"
    lint = "lint"
    scan = "scan"
    merge = "merge"
    build = "build"
    test = "test"
    deliver = "deliver"
    deploy = "deploy"
    release = "release"
    clean = "clean"
    other = "other"


class Parameter(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[
        Optional[str], Field(description="The name of the parameter.", title="Name")
    ] = None
    value: Annotated[
        Optional[str], Field(description="The value of the parameter.", title="Value")
    ] = None
    dataType: Annotated[
        Optional[str], Field(description="The data type of the parameter.", title="Data type")
    ] = None


class FieldModel(Enum):
    group = "group"
    name = "name"
    version = "version"
    purl = "purl"
    cpe = "cpe"
    omniborId = "omniborId"
    swhid = "swhid"
    swid = "swid"
    hash = "hash"


class Technique(Enum):
    source_code_analysis = "source-code-analysis"
    binary_analysis = "binary-analysis"
    manifest_analysis = "manifest-analysis"
    ast_fingerprint = "ast-fingerprint"
    hash_comparison = "hash-comparison"
    instrumentation = "instrumentation"
    dynamic_analysis = "dynamic-analysis"
    filename = "filename"
    attestation = "attestation"
    other = "other"


class Method(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    technique: Annotated[
        Technique,
        Field(description="The technique used in this method of analysis.", title="Technique"),
    ]
    confidence: Annotated[
        float,
        Field(
            description="The confidence of the evidence from 0 - 1, where 1 is 100% confidence. Confidence is specific to the technique used. Each technique of analysis can have independent confidence.",
            ge=0.0,
            le=1.0,
            title="Confidence",
        ),
    ]
    value: Annotated[
        Optional[str], Field(description="The value or contents of the evidence.", title="Value")
    ] = None


class ComponentIdentityEvidence(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    field: Annotated[
        FieldModel,
        Field(
            description="The identity field of the component which the evidence describes.",
            title="Field",
        ),
    ]
    confidence: Annotated[
        Optional[float],
        Field(
            description="The overall confidence of the evidence from 0 - 1, where 1 is 100% confidence.",
            ge=0.0,
            le=1.0,
            title="Confidence",
        ),
    ] = None
    concludedValue: Annotated[
        Optional[str],
        Field(
            description="The value of the field (cpe, purl, etc) that has been concluded based on the aggregate of all methods (if available).",
            title="Concluded Value",
        ),
    ] = None
    methods: Annotated[
        Optional[List[Method]],
        Field(
            description="The methods used to extract and/or analyze the evidence.", title="Methods"
        ),
    ] = None
    tools: Annotated[
        Optional[List[Union[RefLinkType, BomLinkElementType]]],
        Field(
            description="The object in the BOM identified by its bom-ref. This is often a component or service but may be any object type supporting bom-refs. Tools used for analysis should already be defined in the BOM, either in the metadata/tools, components, or formulation.",
            title="BOM References",
        ),
    ] = None


class OpenCreItem(RootModel[str]):
    root: Annotated[str, Field(examples=["CRE:764-507"], pattern="^CRE:[0-9]+-[0-9]+$")]


class Level(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    identifier: Annotated[
        Optional[str],
        Field(
            description="The identifier used in the standard to identify a specific level.",
            title="Identifier",
        ),
    ] = None
    title: Annotated[
        Optional[str], Field(description="The title of the level.", title="Title")
    ] = None
    description: Annotated[
        Optional[str], Field(description="The description of the level.", title="Description")
    ] = None
    requirements: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of requirement `bom-ref`s that comprise the level.",
            title="Requirements",
        ),
    ] = None


class Algorithm(Enum):
    RS256 = "RS256"
    RS384 = "RS384"
    RS512 = "RS512"
    PS256 = "PS256"
    PS384 = "PS384"
    PS512 = "PS512"
    ES256 = "ES256"
    ES384 = "ES384"
    ES512 = "ES512"
    Ed25519 = "Ed25519"
    Ed448 = "Ed448"
    HS256 = "HS256"
    HS384 = "HS384"
    HS512 = "HS512"


class KeyType(Enum):
    EC = "EC"
    OKP = "OKP"
    RSA = "RSA"


class PublicKey(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    kty: KeyType


class AssetType(Enum):
    algorithm = "algorithm"
    certificate = "certificate"
    protocol = "protocol"
    related_crypto_material = "related-crypto-material"


class Primitive(Enum):
    drbg = "drbg"
    mac = "mac"
    block_cipher = "block-cipher"
    stream_cipher = "stream-cipher"
    signature = "signature"
    hash = "hash"
    pke = "pke"
    xof = "xof"
    kdf = "kdf"
    key_agree = "key-agree"
    kem = "kem"
    ae = "ae"
    combiner = "combiner"
    other = "other"
    unknown = "unknown"


class ExecutionEnvironment(Enum):
    software_plain_ram = "software-plain-ram"
    software_encrypted_ram = "software-encrypted-ram"
    software_tee = "software-tee"
    hardware = "hardware"
    other = "other"
    unknown = "unknown"


class ImplementationPlatform(Enum):
    generic = "generic"
    x86_32 = "x86_32"
    x86_64 = "x86_64"
    armv7_a = "armv7-a"
    armv7_m = "armv7-m"
    armv8_a = "armv8-a"
    armv8_m = "armv8-m"
    armv9_a = "armv9-a"
    armv9_m = "armv9-m"
    s390x = "s390x"
    ppc64 = "ppc64"
    ppc64le = "ppc64le"
    other = "other"
    unknown = "unknown"


class CertificationLevelEnum(Enum):
    none = "none"
    fips140_1_l1 = "fips140-1-l1"
    fips140_1_l2 = "fips140-1-l2"
    fips140_1_l3 = "fips140-1-l3"
    fips140_1_l4 = "fips140-1-l4"
    fips140_2_l1 = "fips140-2-l1"
    fips140_2_l2 = "fips140-2-l2"
    fips140_2_l3 = "fips140-2-l3"
    fips140_2_l4 = "fips140-2-l4"
    fips140_3_l1 = "fips140-3-l1"
    fips140_3_l2 = "fips140-3-l2"
    fips140_3_l3 = "fips140-3-l3"
    fips140_3_l4 = "fips140-3-l4"
    cc_eal1 = "cc-eal1"
    cc_eal1_ = "cc-eal1+"
    cc_eal2 = "cc-eal2"
    cc_eal2_ = "cc-eal2+"
    cc_eal3 = "cc-eal3"
    cc_eal3_ = "cc-eal3+"
    cc_eal4 = "cc-eal4"
    cc_eal4_ = "cc-eal4+"
    cc_eal5 = "cc-eal5"
    cc_eal5_ = "cc-eal5+"
    cc_eal6 = "cc-eal6"
    cc_eal6_ = "cc-eal6+"
    cc_eal7 = "cc-eal7"
    cc_eal7_ = "cc-eal7+"
    other = "other"
    unknown = "unknown"


class Mode1(Enum):
    cbc = "cbc"
    ecb = "ecb"
    ccm = "ccm"
    gcm = "gcm"
    cfb = "cfb"
    ofb = "ofb"
    ctr = "ctr"
    other = "other"
    unknown = "unknown"


class Padding(Enum):
    pkcs5 = "pkcs5"
    pkcs7 = "pkcs7"
    pkcs1v15 = "pkcs1v15"
    oaep = "oaep"
    raw = "raw"
    other = "other"
    unknown = "unknown"


class CryptoFunction(Enum):
    generate = "generate"
    keygen = "keygen"
    encrypt = "encrypt"
    decrypt = "decrypt"
    digest = "digest"
    tag = "tag"
    keyderive = "keyderive"
    sign = "sign"
    verify = "verify"
    encapsulate = "encapsulate"
    decapsulate = "decapsulate"
    other = "other"
    unknown = "unknown"


class AlgorithmProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    primitive: Annotated[
        Optional[Primitive],
        Field(
            description="Cryptographic building blocks used in higher-level cryptographic systems and protocols. Primitives represent different cryptographic routines: deterministic random bit generators (drbg, e.g. CTR_DRBG from NIST SP800-90A-r1), message authentication codes (mac, e.g. HMAC-SHA-256), blockciphers (e.g. AES), streamciphers (e.g. Salsa20), signatures (e.g. ECDSA), hash functions (e.g. SHA-256), public-key encryption schemes (pke, e.g. RSA), extended output functions (xof, e.g. SHAKE256), key derivation functions (e.g. pbkdf2), key agreement algorithms (e.g. ECDH), key encapsulation mechanisms (e.g. ML-KEM), authenticated encryption (ae, e.g. AES-GCM) and the combination of multiple algorithms (combiner, e.g. SP800-56Cr2).",
            title="primitive",
        ),
    ] = None
    parameterSetIdentifier: Annotated[
        Optional[str],
        Field(
            description="An identifier for the parameter set of the cryptographic algorithm. Examples: in AES128, '128' identifies the key length in bits, in SHA256, '256' identifies the digest length, '128' in SHAKE128 identifies its maximum security level in bits, and 'SHA2-128s' identifies a parameter set used in SLH-DSA (FIPS205).",
            title="Parameter Set Identifier",
        ),
    ] = None
    curve: Annotated[
        Optional[str],
        Field(
            description="The specific underlying Elliptic Curve (EC) definition employed which is an indicator of the level of security strength, performance and complexity. Absent an authoritative source of curve names, CycloneDX recommends using curve names as defined at [https://neuromancer.sk/std/](https://neuromancer.sk/std/), the source of which can be found at [https://github.com/J08nY/std-curves](https://github.com/J08nY/std-curves).",
            title="Elliptic Curve",
        ),
    ] = None
    executionEnvironment: Annotated[
        Optional[ExecutionEnvironment],
        Field(
            description="The target and execution environment in which the algorithm is implemented in.",
            title="Execution Environment",
        ),
    ] = None
    implementationPlatform: Annotated[
        Optional[ImplementationPlatform],
        Field(
            description="The target platform for which the algorithm is implemented. The implementation can be 'generic', running on any platform or for a specific platform.",
            title="Implementation platform",
        ),
    ] = None
    certificationLevel: Annotated[
        Optional[List[CertificationLevelEnum]],
        Field(
            description="The certification that the implementation of the cryptographic algorithm has received, if any. Certifications include revisions and levels of FIPS 140 or Common Criteria of different Extended Assurance Levels (CC-EAL).",
            title="Certification Level",
        ),
    ] = None
    mode: Annotated[
        Optional[Mode1],
        Field(
            description="The mode of operation in which the cryptographic algorithm (block cipher) is used.",
            title="Mode",
        ),
    ] = None
    padding: Annotated[
        Optional[Padding],
        Field(
            description="The padding scheme that is used for the cryptographic algorithm.",
            title="Padding",
        ),
    ] = None
    cryptoFunctions: Annotated[
        Optional[List[CryptoFunction]],
        Field(
            description="The cryptographic functions implemented by the cryptographic algorithm.",
            title="Cryptographic functions",
        ),
    ] = None
    classicalSecurityLevel: Annotated[
        Optional[int],
        Field(
            description="The classical security level that a cryptographic algorithm provides (in bits).",
            ge=0,
            title="classical security level",
        ),
    ] = None
    nistQuantumSecurityLevel: Annotated[
        Optional[int],
        Field(
            description="The NIST security strength category as defined in https://csrc.nist.gov/projects/post-quantum-cryptography/post-quantum-cryptography-standardization/evaluation-criteria/security-(evaluation-criteria). A value of 0 indicates that none of the categories are met.",
            ge=0,
            le=6,
            title="NIST security strength category",
        ),
    ] = None


class CertificateProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    subjectName: Annotated[
        Optional[str],
        Field(description="The subject name for the certificate", title="Subject Name"),
    ] = None
    issuerName: Annotated[
        Optional[str],
        Field(description="The issuer name for the certificate", title="Issuer Name"),
    ] = None
    notValidBefore: Annotated[
        Optional[datetime],
        Field(
            description="The date and time according to ISO-8601 standard from which the certificate is valid",
            title="Not Valid Before",
        ),
    ] = None
    notValidAfter: Annotated[
        Optional[datetime],
        Field(
            description="The date and time according to ISO-8601 standard from which the certificate is not valid anymore",
            title="Not Valid After",
        ),
    ] = None
    signatureAlgorithmRef: Annotated[
        Optional[RefType],
        Field(
            description="The bom-ref to signature algorithm used by the certificate",
            title="Algorithm Reference",
        ),
    ] = None
    subjectPublicKeyRef: Annotated[
        Optional[RefType],
        Field(description="The bom-ref to the public key of the subject", title="Key reference"),
    ] = None
    certificateFormat: Annotated[
        Optional[str],
        Field(
            description="The format of the certificate",
            examples=["X.509", "PEM", "DER", "CVC"],
            title="Certificate Format",
        ),
    ] = None
    certificateExtension: Annotated[
        Optional[str],
        Field(
            description="The file extension of the certificate",
            examples=["crt", "pem", "cer", "der", "p12"],
            title="Certificate File Extension",
        ),
    ] = None


class Type10(Enum):
    private_key = "private-key"
    public_key = "public-key"
    secret_key = "secret-key"
    key = "key"
    ciphertext = "ciphertext"
    signature = "signature"
    digest = "digest"
    initialization_vector = "initialization-vector"
    nonce = "nonce"
    seed = "seed"
    salt = "salt"
    shared_secret = "shared-secret"
    tag = "tag"
    additional_data = "additional-data"
    password = "password"
    credential = "credential"
    token = "token"
    other = "other"
    unknown = "unknown"


class State(Enum):
    pre_activation = "pre-activation"
    active = "active"
    suspended = "suspended"
    deactivated = "deactivated"
    compromised = "compromised"
    destroyed = "destroyed"


class Type11(Enum):
    tls = "tls"
    ssh = "ssh"
    ipsec = "ipsec"
    ike = "ike"
    sstp = "sstp"
    wpa = "wpa"
    other = "other"
    unknown = "unknown"


class CipherSuite(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[
        Optional[str],
        Field(
            description="A common name for the cipher suite.",
            examples=["TLS_DHE_RSA_WITH_AES_128_CCM"],
            title="Common Name",
        ),
    ] = None
    algorithms: Annotated[
        Optional[List[RefType]],
        Field(
            description="A list of algorithms related to the cipher suite.",
            title="Related Algorithms",
        ),
    ] = None
    identifiers: Annotated[
        Optional[List[str]],
        Field(
            description="A list of common identifiers for the cipher suite.",
            title="Cipher Suite Identifiers",
        ),
    ] = None


class CryptoRefArray(RootModel[List[RefType]]):
    root: List[RefType]


class SecuredBy(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    mechanism: Annotated[
        Optional[str],
        Field(
            description="Specifies the mechanism by which the cryptographic asset is secured by.",
            examples=["HSM", "TPM", "SGX", "Software", "None"],
            title="Mechanism",
        ),
    ] = None
    algorithmRef: Annotated[
        Optional[RefType],
        Field(description="The bom-ref to the algorithm.", title="Algorithm Reference"),
    ] = None


class Tags(RootModel[List[str]]):
    root: Annotated[
        List[str],
        Field(
            description="Textual strings that aid in discovery, search, and retrieval of the associated object. Tags often serve as a way to group or categorize similar or related objects by various attributes.",
            examples=[
                "json-parser",
                "object-persistence",
                "text-to-image",
                "translation",
                "object-detection",
            ],
            title="Tags",
        ),
    ]


class Conformance(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    score: Annotated[
        Optional[float],
        Field(
            description="The conformance of the claim between and inclusive of 0 and 1, where 1 is 100% conformance.",
            ge=0.0,
            le=1.0,
            title="Score",
        ),
    ] = None
    rationale: Annotated[
        Optional[str],
        Field(description="The rationale for the conformance score.", title="Rationale"),
    ] = None
    mitigationStrategies: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of  `bom-ref` to the evidence provided describing the mitigation strategies.",
            title="Mitigation Strategies",
        ),
    ] = None


class MapItem(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    requirement: Annotated[
        Optional[RefLinkType],
        Field(
            description="The `bom-ref` to the requirement being attested to.", title="Requirement"
        ),
    ] = None
    claims: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of `bom-ref` to the claims being attested to.", title="Claims"
        ),
    ] = None
    counterClaims: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of  `bom-ref` to the counter claims being attested to.",
            title="Counter Claims",
        ),
    ] = None
    conformance: Annotated[
        Optional[Conformance],
        Field(
            description="The conformance of the claim meeting a requirement.", title="Conformance"
        ),
    ] = None
    confidence: Annotated[
        Optional[Confidence],
        Field(
            description="The confidence of the claim meeting the requirement.", title="Confidence"
        ),
    ] = None


class Contents(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    attachment: Annotated[
        Optional[Attachment],
        Field(
            description="An optional way to include textual or encoded data.",
            title="Data Attachment",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(description="The URL to where the data can be retrieved.", title="Data URL"),
    ] = None


class OrganizationalEntity(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the organization",
            examples=["Example Inc."],
            title="Organization Name",
        ),
    ] = None
    address: Annotated[
        Optional[PostalAddress],
        Field(
            description="The physical address (location) of the organization",
            title="Organization Address",
        ),
    ] = None
    url: Annotated[
        Optional[List[str]],
        Field(
            description="The URL of the organization. Multiple URLs are allowed.",
            examples=["https://example.com"],
            title="Organization URL(s)",
        ),
    ] = None
    contact: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description="A contact at the organization. Multiple contacts are allowed.",
            title="Organizational Contact",
        ),
    ] = None


class Swid(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    tagId: Annotated[
        str, Field(description="Maps to the tagId of a SoftwareIdentity.", title="Tag ID")
    ]
    name: Annotated[
        str, Field(description="Maps to the name of a SoftwareIdentity.", title="Name")
    ]
    version: Annotated[
        Optional[str],
        Field(description="Maps to the version of a SoftwareIdentity.", title="Version"),
    ] = "0.0"
    tagVersion: Annotated[
        Optional[int],
        Field(description="Maps to the tagVersion of a SoftwareIdentity.", title="Tag Version"),
    ] = 0
    patch: Annotated[
        Optional[bool],
        Field(description="Maps to the patch of a SoftwareIdentity.", title="Patch"),
    ] = False
    text: Annotated[
        Optional[Attachment],
        Field(
            description="Specifies the metadata and content of the SWID tag.",
            title="Attachment text",
        ),
    ] = None
    url: Annotated[Optional[str], Field(description="The URL to the SWID file.", title="URL")] = (
        None
    )


class Hash(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    alg: HashAlg
    content: HashContent


class Licensor(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that granted the license",
            title="Licensor (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ] = None


class Licensor1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that granted the license",
            title="Licensor (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ]


class Licensee(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that was granted the license",
            title="Licensee (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ] = None


class Licensee1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that was granted the license",
            title="Licensee (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ]


class Purchaser(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that purchased the license",
            title="Purchaser (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ] = None


class Purchaser1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that purchased the license",
            title="Purchaser (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ]


class Licensing(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    altIds: Annotated[
        Optional[List[str]],
        Field(
            description="License identifiers that may be used to manage licenses and their lifecycle",
            title="Alternate License Identifiers",
        ),
    ] = None
    licensor: Annotated[
        Optional[Union[Licensor, Licensor1]],
        Field(
            description="The individual or organization that grants a license to another individual or organization",
            title="Licensor",
        ),
    ] = None
    licensee: Annotated[
        Optional[Union[Licensee, Licensee1]],
        Field(
            description="The individual or organization for which a license was granted to",
            title="Licensee",
        ),
    ] = None
    purchaser: Annotated[
        Optional[Union[Purchaser, Purchaser1]],
        Field(
            description="The individual or organization that purchased the license",
            title="Purchaser",
        ),
    ] = None
    purchaseOrder: Annotated[
        Optional[str],
        Field(
            description="The purchase order identifier the purchaser sent to a supplier or vendor to authorize a purchase",
            title="Purchase Order",
        ),
    ] = None
    licenseTypes: Annotated[
        Optional[List[LicenseType]],
        Field(
            description="The type of license(s) that was granted to the licensee.",
            title="License Type",
        ),
    ] = None
    lastRenewal: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the license was last renewed. For new purchases, this is often the purchase or acquisition date. For non-perpetual licenses or subscriptions, this is the timestamp of when the license was last renewed.",
            title="Last Renewal",
        ),
    ] = None
    expiration: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the current license expires (if applicable).",
            title="Expiration",
        ),
    ] = None


class License1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the license elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        spdx.Schema,
        Field(
            description="A valid SPDX license identifier. If specified, this value must be one of the enumeration of valid SPDX license identifiers defined in the spdx.schema.json (or spdx.xml) subschema which is synchronized with the official SPDX license list.",
            examples=["Apache-2.0"],
            title="License ID (SPDX)",
        ),
    ]
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the license. This may include the name of a commercial or proprietary license or an open source license that may not be defined by SPDX.",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ] = None
    acknowledgement: Optional[LicenseAcknowledgementEnumeration] = None
    text: Annotated[
        Optional[Attachment],
        Field(
            description="An optional way to include the textual content of a license.",
            title="License text",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the license file. If specified, a 'license' externalReference should also be specified for completeness",
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None
    licensing: Annotated[
        Optional[Licensing],
        Field(
            description="Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and other important metadata",
            title="Licensing information",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Licensor2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that granted the license",
            title="Licensor (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ] = None


class Licensor3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that granted the license",
            title="Licensor (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that granted the license",
            title="Licensor (Individual)",
        ),
    ]


class Licensee2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that was granted the license",
            title="Licensee (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ] = None


class Licensee3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that was granted the license",
            title="Licensee (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that was granted the license",
            title="Licensee (Individual)",
        ),
    ]


class Purchaser2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that purchased the license",
            title="Purchaser (Organization)",
        ),
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ] = None


class Purchaser3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that purchased the license",
            title="Purchaser (Organization)",
        ),
    ] = None
    individual: Annotated[
        OrganizationalContact,
        Field(
            description="The individual, not associated with an organization, that purchased the license",
            title="Purchaser (Individual)",
        ),
    ]


class Licensing1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    altIds: Annotated[
        Optional[List[str]],
        Field(
            description="License identifiers that may be used to manage licenses and their lifecycle",
            title="Alternate License Identifiers",
        ),
    ] = None
    licensor: Annotated[
        Optional[Union[Licensor2, Licensor3]],
        Field(
            description="The individual or organization that grants a license to another individual or organization",
            title="Licensor",
        ),
    ] = None
    licensee: Annotated[
        Optional[Union[Licensee2, Licensee3]],
        Field(
            description="The individual or organization for which a license was granted to",
            title="Licensee",
        ),
    ] = None
    purchaser: Annotated[
        Optional[Union[Purchaser2, Purchaser3]],
        Field(
            description="The individual or organization that purchased the license",
            title="Purchaser",
        ),
    ] = None
    purchaseOrder: Annotated[
        Optional[str],
        Field(
            description="The purchase order identifier the purchaser sent to a supplier or vendor to authorize a purchase",
            title="Purchase Order",
        ),
    ] = None
    licenseTypes: Annotated[
        Optional[List[LicenseType]],
        Field(
            description="The type of license(s) that was granted to the licensee.",
            title="License Type",
        ),
    ] = None
    lastRenewal: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the license was last renewed. For new purchases, this is often the purchase or acquisition date. For non-perpetual licenses or subscriptions, this is the timestamp of when the license was last renewed.",
            title="Last Renewal",
        ),
    ] = None
    expiration: Annotated[
        Optional[datetime],
        Field(
            description="The timestamp indicating when the current license expires (if applicable).",
            title="Expiration",
        ),
    ] = None


class License2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the license elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        Optional[spdx.Schema],
        Field(
            description="A valid SPDX license identifier. If specified, this value must be one of the enumeration of valid SPDX license identifiers defined in the spdx.schema.json (or spdx.xml) subschema which is synchronized with the official SPDX license list.",
            examples=["Apache-2.0"],
            title="License ID (SPDX)",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the license. This may include the name of a commercial or proprietary license or an open source license that may not be defined by SPDX.",
            examples=["Acme Software License"],
            title="License Name",
        ),
    ]
    acknowledgement: Optional[LicenseAcknowledgementEnumeration] = None
    text: Annotated[
        Optional[Attachment],
        Field(
            description="An optional way to include the textual content of a license.",
            title="License text",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the license file. If specified, a 'license' externalReference should also be specified for completeness",
            examples=["https://www.apache.org/licenses/LICENSE-2.0.txt"],
            title="License URL",
        ),
    ] = None
    licensing: Annotated[
        Optional[Licensing1],
        Field(
            description="Licensing details describing the licensor/licensee, license type, renewal and expiration dates, and other important metadata",
            title="Licensing information",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class License(RootModel[Union[License1, License2]]):
    root: Annotated[
        Union[License1, License2],
        Field(
            description="Specifies the details and attributes related to a software license. It can either include a valid SPDX license identifier or a named license, along with additional properties such as license acknowledgment, comprehensive commercial licensing information, and the full text of the license.",
            title="License",
        ),
    ]


class Commit(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    uid: Annotated[
        Optional[str],
        Field(
            description="A unique identifier of the commit. This may be version control specific. For example, Subversion uses revision numbers whereas git uses commit hashes.",
            title="UID",
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(
            description="The URL to the commit. This URL will typically point to a commit in a version control system.",
            title="URL",
        ),
    ] = None
    author: Annotated[
        Optional[IdentifiableAction],
        Field(description="The author who created the changes in the commit", title="Author"),
    ] = None
    committer: Annotated[
        Optional[IdentifiableAction],
        Field(description="The person who committed or pushed the commit", title="Committer"),
    ] = None
    message: Annotated[
        Optional[str],
        Field(description="The text description of the contents of the commit", title="Message"),
    ] = None


class Patch(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Type1,
        Field(
            description="Specifies the purpose for the patch including the resolution of defects, security issues, or new behavior or functionality.",
            title="Patch Type",
        ),
    ]
    diff: Annotated[
        Optional[Diff],
        Field(
            description="The patch file (or diff) that shows changes. Refer to [https://en.wikipedia.org/wiki/Diff](https://en.wikipedia.org/wiki/Diff)",
            title="Diff",
        ),
    ] = None
    resolves: Annotated[
        Optional[List[Issue]],
        Field(description="A collection of issues the patch resolves", title="Resolves"),
    ] = None


class ExternalReference(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    url: Annotated[
        Union[str, BomLink],
        Field(
            description="The URI (URL or URN) to the external reference. External references are URIs and therefore can accept any URL scheme including https ([RFC-7230](https://www.ietf.org/rfc/rfc7230.txt)), mailto ([RFC-2368](https://www.ietf.org/rfc/rfc2368.txt)), tel ([RFC-3966](https://www.ietf.org/rfc/rfc3966.txt)), and dns ([RFC-4501](https://www.ietf.org/rfc/rfc4501.txt)). External references may also include formally registered URNs such as [CycloneDX BOM-Link](https://cyclonedx.org/capabilities/bomlink/) to reference CycloneDX BOMs or any object within a BOM. BOM-Link transforms applicable external references into relationships that can be expressed in a BOM or across BOMs.",
            title="URL",
        ),
    ]
    comment: Annotated[
        Optional[str],
        Field(
            description="An optional comment describing the external reference", title="Comment"
        ),
    ] = None
    type: Annotated[
        Type3, Field(description="Specifies the type of external reference.", title="Type")
    ]
    hashes: Annotated[
        Optional[List[Hash]],
        Field(description="The hashes of the external reference (if applicable).", title="Hashes"),
    ] = None


class ComponentEvidence(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    identity: Annotated[
        Optional[Union[List[ComponentIdentityEvidence], ComponentIdentityEvidence]],
        Field(
            description="Evidence that substantiates the identity of a component. The identity may be an object or an array of identity objects. Support for specifying identity as a single object was introduced in CycloneDX v1.5. Arrays were introduced in v1.6. It is recommended that all implementations use arrays, even if only one identity object is specified.",
            title="Identity Evidence",
        ),
    ] = None
    occurrences: Annotated[
        Optional[List[Occurrence]],
        Field(
            description="Evidence of individual instances of a component spread across multiple locations.",
            title="Occurrences",
        ),
    ] = None
    callstack: Annotated[
        Optional[Callstack],
        Field(
            description="Evidence of the components use through the callstack.", title="Call Stack"
        ),
    ] = None
    licenses: Annotated[Optional[LicenseChoice], Field(title="License Evidence")] = None
    copyright: Annotated[
        Optional[List[Copyright]],
        Field(
            description="Copyright evidence captures intellectual property assertions, providing evidence of possible ownership and legal protection.",
            title="Copyright Evidence",
        ),
    ] = None


class ReleaseNotes(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        ReleaseType,
        Field(
            description="The software versioning type the release note describes.", title="Type"
        ),
    ]
    title: Annotated[
        Optional[str], Field(description="The title of the release.", title="Title")
    ] = None
    featuredImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be prominently displayed with the release note.",
            title="Featured image",
        ),
    ] = None
    socialImage: Annotated[
        Optional[str],
        Field(
            description="The URL to an image that may be used in messaging on social media platforms.",
            title="Social image",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A short description of the release.", title="Description"),
    ] = None
    timestamp: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the release note was created.",
            title="Timestamp",
        ),
    ] = None
    aliases: Annotated[
        Optional[List[str]],
        Field(
            description="One or more alternate names the release may be referred to. This may include unofficial terms used by development and marketing teams (e.g. code names).",
            title="Aliases",
        ),
    ] = None
    tags: Annotated[Optional[Tags], Field(title="Tags")] = None
    resolves: Annotated[
        Optional[List[Issue]],
        Field(description="A collection of issues that have been resolved.", title="Resolves"),
    ] = None
    notes: Annotated[
        Optional[List[Note]],
        Field(
            description="Zero or more release notes containing the locale and content. Multiple note objects may be specified to support release notes in a wide variety of languages.",
            title="Notes",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Rating(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    source: Annotated[
        Optional[VulnerabilitySource],
        Field(
            description="The source that calculated the severity or risk rating of the vulnerability."
        ),
    ] = None
    score: Annotated[
        Optional[float], Field(description="The numerical score of the rating.", title="Score")
    ] = None
    severity: Annotated[
        Optional[Severity],
        Field(
            description="Textual representation of the severity that corresponds to the numerical score of the rating."
        ),
    ] = None
    method: Optional[ScoreMethod] = None
    vector: Annotated[
        Optional[str],
        Field(
            description="Textual representation of the metric values used to score the vulnerability",
            title="Vector",
        ),
    ] = None
    justification: Annotated[
        Optional[str],
        Field(
            description="An optional reason for rating the vulnerability as it was",
            title="Justification",
        ),
    ] = None


class Credits(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organizations: Annotated[
        Optional[List[OrganizationalEntity]],
        Field(
            description="The organizations credited with vulnerability discovery.",
            title="Organizations",
        ),
    ] = None
    individuals: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description="The individuals, not associated with organizations, that are credited with vulnerability discovery.",
            title="Individuals",
        ),
    ] = None


class Versions(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    version: Annotated[
        Version, Field(description="A single version of a component or service.", title="Version")
    ]
    range: Annotated[
        Optional[VersionRange],
        Field(
            description="A version range specified in Package URL Version Range syntax (vers) which is defined at https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst",
            title="Version Range",
        ),
    ] = None
    status: Annotated[
        Optional[AffectedStatus],
        Field(
            description="The vulnerability status for the version or range of versions.",
            title="Status",
        ),
    ] = "affected"


class Versions1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    version: Annotated[
        Optional[Version],
        Field(description="A single version of a component or service.", title="Version"),
    ] = None
    range: Annotated[
        VersionRange,
        Field(
            description="A version range specified in Package URL Version Range syntax (vers) which is defined at https://github.com/package-url/purl-spec/VERSION-RANGE-SPEC.rst",
            title="Version Range",
        ),
    ]
    status: Annotated[
        Optional[AffectedStatus],
        Field(
            description="The vulnerability status for the version or range of versions.",
            title="Status",
        ),
    ] = "affected"


class Affect(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ref: Annotated[
        Union[RefLinkType, BomLinkElementType],
        Field(
            description="References a component or service by the objects bom-ref",
            title="Reference",
        ),
    ]
    versions: Annotated[
        Optional[List[Union[Versions, Versions1]]],
        Field(
            description="Zero or more individual versions or range of versions.", title="Versions"
        ),
    ] = None


class DataGovernanceResponsibleParty1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity,
        Field(
            description="The organization that is responsible for specific data governance role(s).",
            title="Organization",
        ),
    ]
    contact: Annotated[
        Optional[OrganizationalContact],
        Field(
            description="The individual that is responsible for specific data governance role(s).",
            title="Individual",
        ),
    ] = None


class DataGovernanceResponsibleParty2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that is responsible for specific data governance role(s).",
            title="Organization",
        ),
    ] = None
    contact: Annotated[
        OrganizationalContact,
        Field(
            description="The individual that is responsible for specific data governance role(s).",
            title="Individual",
        ),
    ]


class DataGovernanceResponsibleParty(
    RootModel[Union[DataGovernanceResponsibleParty1, DataGovernanceResponsibleParty2]]
):
    root: Union[DataGovernanceResponsibleParty1, DataGovernanceResponsibleParty2]


class GraphicsCollection(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    description: Annotated[
        Optional[str],
        Field(description="A description of this collection of graphics.", title="Description"),
    ] = None
    collection: Annotated[
        Optional[List[Graphic]], Field(description="A collection of graphics.", title="Collection")
    ] = None


class EnergyProvider(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the energy provider elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the energy provider.", title="Description"),
    ] = None
    organization: Annotated[
        OrganizationalEntity,
        Field(description="The organization that provides energy.", title="Organization"),
    ]
    energySource: Annotated[
        EnergySource,
        Field(description="The energy source for the energy provider.", title="Energy Source"),
    ]
    energyProvided: Annotated[
        EnergyMeasure,
        Field(
            description="The energy provided by the energy source for an associated activity.",
            title="Energy Provided",
        ),
    ]
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None


class Step(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[Optional[str], Field(description="A name for the step.", title="Name")] = None
    description: Annotated[
        Optional[str], Field(description="A description of the step.", title="Description")
    ] = None
    commands: Annotated[
        Optional[List[Command]],
        Field(description="Ordered list of commands or directives for the step", title="Commands"),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class ResourceReferenceChoice1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ref: Annotated[
        Union[RefLinkType, BomLinkElementType],
        Field(description="References an object by its bom-ref attribute", title="BOM Reference"),
    ]
    externalReference: Annotated[
        Optional[ExternalReference],
        Field(
            description="Reference to an externally accessible resource.",
            title="External reference",
        ),
    ] = None


class ResourceReferenceChoice2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ref: Annotated[
        Optional[Union[RefLinkType, BomLinkElementType]],
        Field(description="References an object by its bom-ref attribute", title="BOM Reference"),
    ] = None
    externalReference: Annotated[
        ExternalReference,
        Field(
            description="Reference to an externally accessible resource.",
            title="External reference",
        ),
    ]


class ResourceReferenceChoice(
    RootModel[Union[ResourceReferenceChoice1, ResourceReferenceChoice2]]
):
    root: Annotated[
        Union[ResourceReferenceChoice1, ResourceReferenceChoice2],
        Field(
            description="A reference to a locally defined resource (e.g., a bom-ref) or an externally accessible resource.",
            title="Resource reference choice",
        ),
    ]


class Requirement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    identifier: Annotated[
        Optional[str],
        Field(
            description="The unique identifier used in the standard to identify a specific requirement. This should match what is in the standard and should not be the requirements bom-ref.",
            title="Identifier",
        ),
    ] = None
    title: Annotated[
        Optional[str], Field(description="The title of the requirement.", title="Title")
    ] = None
    text: Annotated[
        Optional[str], Field(description="The textual content of the requirement.", title="Text")
    ] = None
    descriptions: Annotated[
        Optional[List[str]],
        Field(
            description="The supplemental text that provides additional guidance or context to the requirement, but is not directly part of the requirement.",
            title="Descriptions",
        ),
    ] = None
    openCre: Annotated[
        Optional[List[OpenCreItem]],
        Field(
            description="The Common Requirements Enumeration (CRE) identifier(s). CRE is a structured and standardized framework for uniting security standards and guidelines. CRE links each section of a resource to a shared topic identifier (a Common Requirement). Through this shared topic link, all resources map to each other. Use of CRE promotes clear and unambiguous communication among stakeholders.",
            title="OWASP OpenCRE Identifier(s)",
        ),
    ] = None
    parent: Annotated[
        Optional[RefLinkType],
        Field(
            description="The optional `bom-ref` to a parent requirement. This establishes a hierarchy of requirements. Top-level requirements must not define a parent. Only child requirements should define parents.",
            title="Parent BOM Reference",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant, but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None


class Signer(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    algorithm: Union[Algorithm, AnyUrl]
    keyId: Annotated[
        Optional[str],
        Field(
            description="Optional. Application specific string identifying the signature key.",
            title="Key ID",
        ),
    ] = None
    publicKey: Annotated[
        Optional[PublicKey], Field(description="Optional. Public key object.", title="Public key")
    ] = None
    certificatePath: Annotated[
        Optional[List[str]],
        Field(
            description="Optional. Sorted array of X.509 [RFC5280] certificates, where the first element must contain the signature certificate. The certificate path must be contiguous but is not required to be complete.",
            title="Certificate path",
        ),
    ] = None
    excludes: Annotated[
        Optional[List[str]],
        Field(
            description='Optional. Array holding the names of one or more application level properties that must be excluded from the signature process. Note that the "excludes" property itself, must also be excluded from the signature process. Since both the "excludes" property and the associated data it points to are unsigned, a conforming JSF implementation must provide options for specifying which properties to accept.',
            title="Excludes",
        ),
    ] = None
    value: Annotated[
        str,
        Field(
            description="The signature data. Note that the binary representation must follow the JWA [RFC7518] specifications.",
            title="Signature",
        ),
    ]


class RelatedCryptoMaterialProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type10],
        Field(
            description="The type for the related cryptographic material",
            title="relatedCryptoMaterialType",
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            description="The optional unique identifier for the related cryptographic material.",
            title="ID",
        ),
    ] = None
    state: Annotated[
        Optional[State],
        Field(description="The key state as defined by NIST SP 800-57.", title="State"),
    ] = None
    algorithmRef: Annotated[
        Optional[RefType],
        Field(
            description="The bom-ref to the algorithm used to generate the related cryptographic material.",
            title="Algorithm Reference",
        ),
    ] = None
    creationDate: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the related cryptographic material was created.",
            title="Creation Date",
        ),
    ] = None
    activationDate: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the related cryptographic material was activated.",
            title="Activation Date",
        ),
    ] = None
    updateDate: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the related cryptographic material was updated.",
            title="Update Date",
        ),
    ] = None
    expirationDate: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the related cryptographic material expires.",
            title="Expiration Date",
        ),
    ] = None
    value: Annotated[
        Optional[str],
        Field(description="The associated value of the cryptographic material.", title="Value"),
    ] = None
    size: Annotated[
        Optional[int],
        Field(description="The size of the cryptographic asset (in bits).", title="Size"),
    ] = None
    format: Annotated[
        Optional[str],
        Field(
            description="The format of the related cryptographic material (e.g. P8, PEM, DER).",
            title="Format",
        ),
    ] = None
    securedBy: Annotated[
        Optional[SecuredBy],
        Field(
            description="The mechanism by which the cryptographic asset is secured by.",
            title="Secured By",
        ),
    ] = None


class Ikev2TransformTypes(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    encr: Annotated[
        Optional[CryptoRefArray],
        Field(
            description="Transform Type 1: encryption algorithms",
            title="Encryption Algorithm (ENCR)",
        ),
    ] = None
    prf: Annotated[
        Optional[CryptoRefArray],
        Field(
            description="Transform Type 2: pseudorandom functions",
            title="Pseudorandom Function (PRF)",
        ),
    ] = None
    integ: Annotated[
        Optional[CryptoRefArray],
        Field(
            description="Transform Type 3: integrity algorithms",
            title="Integrity Algorithm (INTEG)",
        ),
    ] = None
    ke: Annotated[
        Optional[CryptoRefArray],
        Field(
            description="Transform Type 4: Key Exchange Method (KE) per [RFC 9370](https://www.ietf.org/rfc/rfc9370.html), formerly called Diffie-Hellman Group (D-H).",
            title="Key Exchange Method (KE)",
        ),
    ] = None
    esn: Annotated[
        Optional[bool],
        Field(
            description="Specifies if an Extended Sequence Number (ESN) is used.",
            title="Extended Sequence Numbers (ESN)",
        ),
    ] = None
    auth: Annotated[
        Optional[CryptoRefArray],
        Field(description="IKEv2 Authentication method", title="IKEv2 Authentication method"),
    ] = None


class ProtocolProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type11], Field(description="The concrete protocol type.", title="Type")
    ] = None
    version: Annotated[
        Optional[str],
        Field(
            description="The version of the protocol.",
            examples=["1.0", "1.2", "1.99"],
            title="Protocol Version",
        ),
    ] = None
    cipherSuites: Annotated[
        Optional[List[CipherSuite]],
        Field(
            description="A list of cipher suites related to the protocol.", title="Cipher Suites"
        ),
    ] = None
    ikev2TransformTypes: Annotated[
        Optional[Ikev2TransformTypes],
        Field(
            description="The IKEv2 transform types supported (types 1-4), defined in [RFC 7296 section 3.3.2](https://www.ietf.org/rfc/rfc7296.html#section-3.3.2), and additional properties.",
            title="IKEv2 Transform Types",
        ),
    ] = None
    cryptoRefArray: Annotated[
        Optional[CryptoRefArray],
        Field(
            description="A list of protocol-related cryptographic assets",
            title="Cryptographic References",
        ),
    ] = None


class CryptoProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    assetType: Annotated[
        AssetType,
        Field(
            description="Cryptographic assets occur in several forms. Algorithms and protocols are most commonly implemented in specialized cryptographic libraries. They may, however, also be 'hardcoded' in software components. Certificates and related cryptographic material like keys, tokens, secrets or passwords are other cryptographic assets to be modelled.",
            title="Asset Type",
        ),
    ]
    algorithmProperties: Annotated[
        Optional[AlgorithmProperties],
        Field(
            description="Additional properties specific to a cryptographic algorithm.",
            title="Algorithm Properties",
        ),
    ] = None
    certificateProperties: Annotated[
        Optional[CertificateProperties],
        Field(
            description="Properties for cryptographic assets of asset type 'certificate'",
            title="Certificate Properties",
        ),
    ] = None
    relatedCryptoMaterialProperties: Annotated[
        Optional[RelatedCryptoMaterialProperties],
        Field(
            description="Properties for cryptographic assets of asset type: `related-crypto-material`",
            title="Related Cryptographic Material Properties",
        ),
    ] = None
    protocolProperties: Annotated[
        Optional[ProtocolProperties],
        Field(
            description="Properties specific to cryptographic assets of type: `protocol`.",
            title="Protocol Properties",
        ),
    ] = None
    oid: Annotated[
        Optional[str],
        Field(description="The object identifier (OID) of the cryptographic asset.", title="OID"),
    ] = None


class Assessor(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    thirdParty: Annotated[
        Optional[bool],
        Field(
            description="The boolean indicating if the assessor is outside the organization generating claims. A value of false indicates a self assessor.",
            title="Third Party",
        ),
    ] = None
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The entity issuing the assessment.", title="Organization"),
    ] = None


class Tool(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    vendor: Annotated[
        Optional[str],
        Field(description="The name of the vendor who created the tool", title="Tool Vendor"),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the tool", title="Tool Name")
    ] = None
    version: Annotated[
        Optional[Version], Field(description="The version of the tool", title="Tool Version")
    ] = None
    hashes: Annotated[
        Optional[List[Hash]],
        Field(description="The hashes of the tool (if applicable).", title="Hashes"),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant, but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None


class QuantitativeAnalysis(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    performanceMetrics: Annotated[
        Optional[List[PerformanceMetric]],
        Field(
            description="The model performance metrics being reported. Examples may include accuracy, F1 score, precision, top-3 error rates, MSC, etc.",
            title="Performance Metrics",
        ),
    ] = None
    graphics: Optional[GraphicsCollection] = None


class DataGovernance(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    custodians: Annotated[
        Optional[List[DataGovernanceResponsibleParty]],
        Field(
            description="Data custodians are responsible for the safe custody, transport, and storage of data.",
            title="Data Custodians",
        ),
    ] = None
    stewards: Annotated[
        Optional[List[DataGovernanceResponsibleParty]],
        Field(
            description="Data stewards are responsible for data content, context, and associated business rules.",
            title="Data Stewards",
        ),
    ] = None
    owners: Annotated[
        Optional[List[DataGovernanceResponsibleParty]],
        Field(
            description="Data owners are concerned with risk and appropriate access to data.",
            title="Data Owners",
        ),
    ] = None


class EnergyConsumption(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    activity: Annotated[
        Activity,
        Field(
            description="The type of activity that is part of a machine learning model development or operational lifecycle.",
            title="Activity",
        ),
    ]
    energyProviders: Annotated[
        List[EnergyProvider],
        Field(
            description="The provider(s) of the energy consumed by the associated model development lifecycle activity.",
            title="Energy Providers",
        ),
    ]
    activityEnergyCost: Annotated[
        EnergyMeasure,
        Field(
            description="The total energy cost associated with the model lifecycle activity.",
            title="Activity Energy Cost",
        ),
    ]
    co2CostEquivalent: Annotated[
        Optional[Co2Measure],
        Field(
            description="The CO2 cost (debit) equivalent to the total energy cost.",
            title="CO2 Equivalent Cost",
        ),
    ] = None
    co2CostOffset: Annotated[
        Optional[Co2Measure],
        Field(
            description="The CO2 offset (credit) for the CO2 equivalent cost.",
            title="CO2 Cost Offset",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Workspace(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        RefType,
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the workspace elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="The name of the resource instance.", title="Name")
    ] = None
    aliases: Annotated[
        Optional[List[str]],
        Field(
            description="The names for the workspace as referenced by other workflow tasks. Effectively, a name mapping so other tasks can use their own local name in their steps.",
            title="Aliases",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the resource instance.", title="Description"),
    ] = None
    resourceReferences: Annotated[
        Optional[List[ResourceReferenceChoice]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    accessMode: Annotated[
        Optional[AccessMode],
        Field(
            description="Describes the read-write access control for the workspace relative to the owning resource instance.",
            title="Access mode",
        ),
    ] = None
    mountPath: Annotated[
        Optional[str],
        Field(
            description="A path to a location on disk where the workspace will be available to the associated task's steps.",
            title="Mount path",
        ),
    ] = None
    managedDataType: Annotated[
        Optional[str],
        Field(
            description="The name of a domain-specific data type the workspace represents.",
            examples=["ConfigMap", "Secret"],
            title="Managed data type",
        ),
    ] = None
    volumeRequest: Annotated[
        Optional[str],
        Field(
            description="Identifies the reference to the request for a specific volume type and parameters.",
            examples=["a kubernetes Persistent Volume Claim (PVC) name"],
            title="Volume request",
        ),
    ] = None
    volume: Annotated[
        Optional[Volume],
        Field(
            description="Information about the actual volume instance allocated to the workspace.",
            examples=["see https://kubernetes.io/docs/concepts/storage/persistent-volumes/"],
            title="Volume",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Event(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    uid: Annotated[
        Optional[str],
        Field(description="The unique identifier of the event.", title="Unique Identifier (UID)"),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the event.", title="Description")
    ] = None
    timeReceived: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the event was received.",
            title="Time Received",
        ),
    ] = None
    data: Annotated[
        Optional[Attachment], Field(description="Encoding of the raw event data.", title="Data")
    ] = None
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="References the component or service that was the source of the event",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="References the component or service that was the target of the event",
            title="Target",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class InputType1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that provided the input to the task (e.g., reference to a service with data flow value of `inbound`)",
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that received or stored the input if not the task itself (e.g., a local, named storage workspace)",
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        ResourceReferenceChoice,
        Field(
            description="A reference to an independent resource provided as an input to a task by the workflow runtime.",
            examples=[
                "a reference to a configuration file in a repository (i.e., a bom-ref)",
                "a reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ]
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[
        Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class InputType2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that provided the input to the task (e.g., reference to a service with data flow value of `inbound`)",
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that received or stored the input if not the task itself (e.g., a local, named storage workspace)",
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to an independent resource provided as an input to a task by the workflow runtime.",
            examples=[
                "a reference to a configuration file in a repository (i.e., a bom-ref)",
                "a reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        List[Parameter],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ]
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[
        Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class InputType3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that provided the input to the task (e.g., reference to a service with data flow value of `inbound`)",
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that received or stored the input if not the task itself (e.g., a local, named storage workspace)",
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to an independent resource provided as an input to a task by the workflow runtime.",
            examples=[
                "a reference to a configuration file in a repository (i.e., a bom-ref)",
                "a reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        List[Union[Property, str]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ]
    data: Annotated[
        Optional[Attachment], Field(description="Inputs that have the form of data.", title="Data")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class InputType4(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that provided the input to the task (e.g., reference to a service with data flow value of `inbound`)",
            examples=["source code repository", "database"],
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to the component or service that received or stored the input if not the task itself (e.g., a local, named storage workspace)",
            examples=["workspace", "directory"],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to an independent resource provided as an input to a task by the workflow runtime.",
            examples=[
                "a reference to a configuration file in a repository (i.e., a bom-ref)",
                "a reference to a scanning service used in a task (i.e., a bom-ref)",
            ],
            title="Resource",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[Parameter]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Parameters",
        ),
    ] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Inputs that have the form of parameters with names and values.",
            title="Environment variables",
        ),
    ] = None
    data: Annotated[
        Attachment, Field(description="Inputs that have the form of data.", title="Data")
    ]
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class InputType(RootModel[Union[InputType1, InputType2, InputType3, InputType4]]):
    root: Annotated[
        Union[InputType1, InputType2, InputType3, InputType4],
        Field(
            description="Type that represents various input data types and formats.",
            title="Input type",
        ),
    ]


class OutputType1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type7], Field(description="Describes the type of data output.", title="Type")
    ] = None
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that received the output from the task (e.g., reference to an artifactory service with data flow value of `outbound`)",
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        ResourceReferenceChoice,
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ]
    data: Annotated[
        Optional[Attachment],
        Field(description="Outputs that have the form of data.", title="Data"),
    ] = None
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class OutputType2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type7], Field(description="Describes the type of data output.", title="Type")
    ] = None
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that received the output from the task (e.g., reference to an artifactory service with data flow value of `outbound`)",
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ] = None
    data: Annotated[
        Optional[Attachment],
        Field(description="Outputs that have the form of data.", title="Data"),
    ] = None
    environmentVars: Annotated[
        List[Union[Property, str]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ]
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class OutputType3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Optional[Type7], Field(description="Describes the type of data output.", title="Type")
    ] = None
    source: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that generated or provided the output from the task (e.g., a build tool)",
            title="Source",
        ),
    ] = None
    target: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="Component or service that received the output from the task (e.g., reference to an artifactory service with data flow value of `outbound`)",
            examples=["a log file described as an `externalReference` within its target domain."],
            title="Target",
        ),
    ] = None
    resource: Annotated[
        Optional[ResourceReferenceChoice],
        Field(
            description="A reference to an independent resource generated as output by the task.",
            examples=["configuration file", "source code", "scanning service"],
            title="Resource",
        ),
    ] = None
    data: Annotated[
        Attachment, Field(description="Outputs that have the form of data.", title="Data")
    ]
    environmentVars: Annotated[
        Optional[List[Union[Property, str]]],
        Field(
            description="Outputs that have the form of environment variables.",
            title="Environment variables",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class OutputType(RootModel[Union[OutputType1, OutputType2, OutputType3]]):
    root: Union[OutputType1, OutputType2, OutputType3]


class Signature1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    signers: Annotated[
        Optional[List[Signer]],
        Field(
            description="Unique top level property for Multiple Signatures. (multisignature)",
            title="Signature",
        ),
    ] = None


class Signature2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    chain: Annotated[
        Optional[List[Signer]],
        Field(
            description="Unique top level property for Signature Chains. (signaturechain)",
            title="Signature",
        ),
    ] = None


class Signature(RootModel[Union[Signature1, Signature2, Signer]]):
    root: Annotated[Union[Signature1, Signature2, Signer], Field(title="Signature")]


class Datum(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[
        Optional[str], Field(description="The name of the data.", title="Data Name")
    ] = None
    contents: Annotated[
        Optional[Contents],
        Field(
            description="The contents or references to the contents of the data being described.",
            title="Data Contents",
        ),
    ] = None
    classification: Optional[DataClassification] = None
    sensitiveData: Annotated[
        Optional[List[str]],
        Field(description="A description of any sensitive data included.", title="Sensitive Data"),
    ] = None
    governance: Annotated[Optional[DataGovernance], Field(title="Data Governance")] = None


class ServiceData(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    flow: Annotated[
        DataFlowDirection,
        Field(
            description="Specifies the flow direction of the data. Direction is relative to the service. Inbound flow states that data enters the service. Outbound flow states that data leaves the service. Bi-directional states that data flows both ways and unknown states that the direction is not known.",
            title="Directional Flow",
        ),
    ]
    classification: DataClassification
    name: Annotated[
        Optional[str],
        Field(
            description="Name for the defined data",
            examples=["Credit card reporting"],
            title="Name",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="Short description of the data content and usage",
            examples=[
                "Credit card information being exchanged in between the web app and the database"
            ],
            title="Description",
        ),
    ] = None
    governance: Annotated[Optional[DataGovernance], Field(title="Data Governance")] = None
    source: Annotated[
        Optional[List[Union[str, BomLinkElementType]]],
        Field(
            description="The URI, URL, or BOM-Link of the components or services the data came in from",
            title="Source",
        ),
    ] = None
    destination: Annotated[
        Optional[List[Union[str, BomLinkElementType]]],
        Field(
            description="The URI, URL, or BOM-Link of the components or services the data is sent to",
            title="Destination",
        ),
    ] = None


class ComponentData(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the dataset elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    type: Annotated[
        Type5,
        Field(
            description="The general theme or subject matter of the data being specified.",
            title="Type of Data",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="The name of the dataset.", title="Dataset Name")
    ] = None
    contents: Annotated[
        Optional[Contents1],
        Field(
            description="The contents or references to the contents of the data being described.",
            title="Data Contents",
        ),
    ] = None
    classification: Optional[DataClassification] = None
    sensitiveData: Annotated[
        Optional[List[str]],
        Field(
            description="A description of any sensitive data in a dataset.", title="Sensitive Data"
        ),
    ] = None
    graphics: Optional[GraphicsCollection] = None
    description: Annotated[
        Optional[str],
        Field(
            description="A description of the dataset. Can describe size of dataset, whether it's used for source code, training, testing, or validation, etc.",
            title="Dataset Description",
        ),
    ] = None
    governance: Annotated[Optional[DataGovernance], Field(title="Data Governance")] = None


class EnvironmentalConsiderations(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    energyConsumptions: Annotated[
        Optional[List[EnergyConsumption]],
        Field(
            description="Describes energy consumption information incurred for one or more component lifecycle activities.",
            title="Energy Consumptions",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Trigger(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        RefType,
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the trigger elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="The name of the resource instance.", title="Name")
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the resource instance.", title="Description"),
    ] = None
    resourceReferences: Annotated[
        Optional[List[ResourceReferenceChoice]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    type: Annotated[
        Type6,
        Field(
            description="The source type of event which caused the trigger to fire.", title="Type"
        ),
    ]
    event: Annotated[
        Optional[Event],
        Field(
            description="The event data that caused the associated trigger to activate.",
            title="Event",
        ),
    ] = None
    conditions: Annotated[
        Optional[List[Condition]],
        Field(
            description="A list of conditions used to determine if a trigger should be activated.",
            title="Conditions",
        ),
    ] = None
    timeActivated: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the trigger was activated.",
            title="Time activated",
        ),
    ] = None
    inputs: Annotated[
        Optional[List[InputType]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=[
                "a `configuration` file which was declared as a local `component` or `externalReference`"
            ],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[OutputType]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Attestation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    summary: Annotated[
        Optional[str],
        Field(
            description="The short description explaining the main points of the attestation.",
            title="Summary",
        ),
    ] = None
    assessor: Annotated[
        Optional[RefLinkType],
        Field(
            description="The `bom-ref` to the assessor asserting the attestation.",
            title="Assessor",
        ),
    ] = None
    map: Annotated[
        Optional[List[MapItem]],
        Field(
            description="The grouping of requirements to claims and the attestors declared conformance and confidence thereof.",
            title="Map",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Claim(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    target: Annotated[
        Optional[RefLinkType],
        Field(
            description="The `bom-ref` to a target representing a specific system, application, API, module, team, person, process, business unit, company, etc...  that this claim is being applied to.",
            title="Target",
        ),
    ] = None
    predicate: Annotated[
        Optional[str],
        Field(
            description="The specific statement or assertion about the target.", title="Predicate"
        ),
    ] = None
    mitigationStrategies: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of  `bom-ref` to the evidence provided describing the mitigation strategies. Each mitigation strategy should include an explanation of how any weaknesses in the evidence will be mitigated.",
            title="Mitigation Strategies",
        ),
    ] = None
    reasoning: Annotated[
        Optional[str],
        Field(
            description="The written explanation of why the evidence provided substantiates the claim.",
            title="Reasoning",
        ),
    ] = None
    evidence: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of `bom-ref` to evidence that supports this claim.",
            title="Evidence",
        ),
    ] = None
    counterEvidence: Annotated[
        Optional[List[RefLinkType]],
        Field(
            description="The list of `bom-ref` to counterEvidence that supports this claim.",
            title="Counter Evidence",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class EvidenceItem(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    propertyName: Annotated[
        Optional[str],
        Field(
            description="The reference to the property name as defined in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy/).",
            title="Property Name",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="The written description of what this evidence is and how it was created.",
            title="Description",
        ),
    ] = None
    data: Annotated[
        Optional[List[Datum]],
        Field(description="The output or analysis that supports claims.", title="Data"),
    ] = None
    created: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the evidence was created.",
            title="Created",
        ),
    ] = None
    expires: Annotated[
        Optional[datetime],
        Field(
            description="The optional date and time (timestamp) when the evidence is no longer valid.",
            title="Expires",
        ),
    ] = None
    author: Annotated[
        Optional[OrganizationalContact],
        Field(description="The author of the evidence.", title="Author"),
    ] = None
    reviewer: Annotated[
        Optional[OrganizationalContact],
        Field(description="The reviewer of the evidence.", title="Reviewer"),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Signatories(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[Optional[str], Field(description="The signatory's name.", title="Name")] = None
    role: Annotated[
        Optional[str],
        Field(description="The signatory's role within an organization.", title="Role"),
    ] = None
    signature: Annotated[
        Signature,
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ]
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The signatory's organization.", title="Organization"),
    ] = None
    externalReference: Annotated[
        Optional[ExternalReference],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External Reference",
        ),
    ] = None


class Signatories1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    name: Annotated[Optional[str], Field(description="The signatory's name.", title="Name")] = None
    role: Annotated[
        Optional[str],
        Field(description="The signatory's role within an organization.", title="Role"),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None
    organization: Annotated[
        OrganizationalEntity,
        Field(description="The signatory's organization.", title="Organization"),
    ]
    externalReference: Annotated[
        ExternalReference,
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External Reference",
        ),
    ]


class Affirmation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    statement: Annotated[
        Optional[str],
        Field(
            description="The brief statement affirmed by an individual regarding all declarations.\n*- Notes This could be an affirmation of acceptance by a third-party auditor or receiving individual of a file.",
            examples=["I certify, to the best of my knowledge, that all information is correct."],
            title="Statement",
        ),
    ] = None
    signatories: Annotated[
        Optional[List[Union[Signatories, Signatories1]]],
        Field(
            description="The list of signatories authorized on behalf of an organization to assert validity of this document.",
            title="Signatories",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Service(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the service elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    provider: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that provides the service.", title="Provider"),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description="The grouping name, namespace, or identifier. This will often be a shortened, single name of the company or project that produced the service or domain name. Whitespace and special characters should be avoided.",
            examples=["com.acme"],
            title="Service Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the service. This will often be a shortened, single name of the service.",
            examples=["ticker-service"],
            title="Service Name",
        ),
    ]
    version: Annotated[
        Optional[Version], Field(description="The service version.", title="Service Version")
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="Specifies a description for the service", title="Service Description"),
    ] = None
    endpoints: Annotated[
        Optional[List[str]],
        Field(
            description="The endpoint URIs of the service. Multiple endpoints are allowed.",
            examples=["https://example.com/api/v1/ticker"],
            title="Endpoints",
        ),
    ] = None
    authenticated: Annotated[
        Optional[bool],
        Field(
            description="A boolean value indicating if the service requires authentication. A value of true indicates the service requires authentication prior to use. A value of false indicates the service does not require authentication.",
            title="Authentication Required",
        ),
    ] = None
    x_trust_boundary: Annotated[
        Optional[bool],
        Field(
            alias="x-trust-boundary",
            description="A boolean value indicating if use of the service crosses a trust zone or boundary. A value of true indicates that by using the service, a trust boundary is crossed. A value of false indicates that by using the service, a trust boundary is not crossed.",
            title="Crosses Trust Boundary",
        ),
    ] = None
    trustZone: Annotated[
        Optional[str],
        Field(
            description="The name of the trust zone the service resides in.", title="Trust Zone"
        ),
    ] = None
    data: Annotated[
        Optional[List[ServiceData]],
        Field(
            description="Specifies information about the data including the directional flow of data and the data classification.",
            title="Data",
        ),
    ] = None
    licenses: Annotated[Optional[LicenseChoice], Field(title="Service License(s)")] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description="A list of services included or deployed behind the parent service. This is not a dependency tree. It provides a way to specify a hierarchical representation of service assemblies.",
            title="Services",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes],
        Field(description="Specifies optional release notes.", title="Release notes"),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None
    tags: Annotated[Optional[Tags], Field(title="Tags")] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Compositions(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the composition elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    aggregate: Annotated[
        AggregateType,
        Field(
            description="Specifies an aggregate type that describe how complete a relationship is.",
            title="Aggregate",
        ),
    ]
    assemblies: Annotated[
        Optional[List[Union[RefLinkType, BomLinkElementType]]],
        Field(
            description="The bom-ref identifiers of the components or services being described. Assemblies refer to nested relationships whereby a constituent part may include other constituent parts. References do not cascade to child parts. References are explicit for the specified constituent part only.",
            title="BOM references",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[str]],
        Field(
            description="The bom-ref identifiers of the components or services being described. Dependencies refer to a relationship whereby an independent constituent part requires another independent constituent part. References do not cascade to transitive dependencies. References are explicit for the specified dependency only.",
            title="BOM references",
        ),
    ] = None
    vulnerabilities: Annotated[
        Optional[List[str]],
        Field(
            description="The bom-ref identifiers of the vulnerabilities being described.",
            title="BOM references",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class ModelParameters(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    approach: Annotated[
        Optional[Approach],
        Field(
            description="The overall approach to learning used by the model for problem solving.",
            title="Approach",
        ),
    ] = None
    task: Annotated[
        Optional[str],
        Field(
            description="Directly influences the input and/or output. Examples include classification, regression, clustering, etc.",
            title="Task",
        ),
    ] = None
    architectureFamily: Annotated[
        Optional[str],
        Field(
            description="The model architecture family such as transformer network, convolutional neural network, residual neural network, LSTM neural network, etc.",
            title="Architecture Family",
        ),
    ] = None
    modelArchitecture: Annotated[
        Optional[str],
        Field(
            description="The specific architecture of the model such as GPT-1, ResNet-50, YOLOv3, etc.",
            title="Model Architecture",
        ),
    ] = None
    datasets: Annotated[
        Optional[List[Union[ComponentData, Datasets]]],
        Field(description="The datasets used to train and evaluate the model.", title="Datasets"),
    ] = None
    inputs: Annotated[
        Optional[List[InputOutputMLParameters]],
        Field(description="The input format(s) of the model", title="Inputs"),
    ] = None
    outputs: Annotated[
        Optional[List[InputOutputMLParameters]],
        Field(description="The output format(s) from the model", title="Outputs"),
    ] = None


class Considerations(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    users: Annotated[
        Optional[List[str]],
        Field(description="Who are the intended users of the model?", title="Users"),
    ] = None
    useCases: Annotated[
        Optional[List[str]],
        Field(description="What are the intended use cases of the model?", title="Use Cases"),
    ] = None
    technicalLimitations: Annotated[
        Optional[List[str]],
        Field(
            description="What are the known technical limitations of the model? E.g. What kind(s) of data should the model be expected not to perform well on? What are the factors that might degrade model performance?",
            title="Technical Limitations",
        ),
    ] = None
    performanceTradeoffs: Annotated[
        Optional[List[str]],
        Field(
            description="What are the known tradeoffs in accuracy/performance of the model?",
            title="Performance Tradeoffs",
        ),
    ] = None
    ethicalConsiderations: Annotated[
        Optional[List[Risk]],
        Field(
            description="What are the ethical risks involved in the application of this model?",
            title="Ethical Considerations",
        ),
    ] = None
    environmentalConsiderations: Annotated[
        Optional[EnvironmentalConsiderations],
        Field(
            description="What are the various environmental impacts the corresponding machine learning model has exhibited across its lifecycle?",
            title="Environmental Considerations",
        ),
    ] = None
    fairnessAssessments: Annotated[
        Optional[List[FairnessAssessment]],
        Field(
            description="How does the model affect groups at risk of being systematically disadvantaged? What are the harms and benefits to the various affected groups?",
            title="Fairness Assessments",
        ),
    ] = None


class ModelCard(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the model card elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    modelParameters: Annotated[
        Optional[ModelParameters],
        Field(
            description="Hyper-parameters for construction of the model.", title="Model Parameters"
        ),
    ] = None
    quantitativeAnalysis: Annotated[
        Optional[QuantitativeAnalysis],
        Field(description="A quantitative analysis of the model", title="Quantitative Analysis"),
    ] = None
    considerations: Annotated[
        Optional[Considerations],
        Field(
            description="What considerations should be taken into account regarding the model's construction, training, and application?",
            title="Considerations",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Task(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        RefType,
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the task elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="The name of the resource instance.", title="Name")
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the resource instance.", title="Description"),
    ] = None
    resourceReferences: Annotated[
        Optional[List[ResourceReferenceChoice]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    taskTypes: Annotated[
        List[TaskType],
        Field(
            description="Indicates the types of activities performed by the set of workflow tasks.",
            title="Task types",
        ),
    ]
    trigger: Annotated[
        Optional[Trigger],
        Field(description="The trigger that initiated the task.", title="Trigger"),
    ] = None
    steps: Annotated[
        Optional[List[Step]],
        Field(description="The sequence of steps for the task.", title="Steps"),
    ] = None
    inputs: Annotated[
        Optional[List[InputType]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=[
                "a `configuration` file which was declared as a local `component` or `externalReference`"
            ],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[OutputType]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    timeStart: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the task started.", title="Time start"
        ),
    ] = None
    timeEnd: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the task ended.", title="Time end"),
    ] = None
    workspaces: Annotated[
        Optional[List[Workspace]],
        Field(
            description="A set of named filesystem or data resource shareable by workflow tasks.",
            title="Workspaces",
        ),
    ] = None
    runtimeTopology: Annotated[
        Optional[List[Dependency]],
        Field(
            description="A graph of the component runtime topology for task's instance.",
            title="Runtime topology",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Standard(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the object elsewhere in the BOM. Every bom-ref must be unique within the BOM.",
            title="BOM Reference",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The name of the standard. This will often be a shortened, single name of the standard.",
            title="Name",
        ),
    ] = None
    version: Annotated[
        Optional[str], Field(description="The version of the standard.", title="Version")
    ] = None
    description: Annotated[
        Optional[str], Field(description="The description of the standard.", title="Description")
    ] = None
    owner: Annotated[
        Optional[str],
        Field(
            description="The owner of the standard, often the entity responsible for its release.",
            title="Owner",
        ),
    ] = None
    requirements: Annotated[
        Optional[List[Requirement]],
        Field(
            description="The list of requirements comprising the standard.", title="Requirements"
        ),
    ] = None
    levels: Annotated[
        Optional[List[Level]],
        Field(
            description="The list of levels associated with the standard. Some standards have different levels of compliance.",
            title="Levels",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Definitions(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    standards: Annotated[
        Optional[List[Standard]],
        Field(
            description="The list of standards which may consist of regulations, industry or organizational-specific standards, maturity models, best practices, or any other requirements which can be evaluated against or attested to.",
            title="Standards",
        ),
    ] = None


class Workflow(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        RefType,
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the workflow elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ]
    uid: Annotated[
        str,
        Field(
            description="The unique identifier for the resource instance within its deployment context.",
            title="Unique Identifier (UID)",
        ),
    ]
    name: Annotated[
        Optional[str], Field(description="The name of the resource instance.", title="Name")
    ] = None
    description: Annotated[
        Optional[str],
        Field(description="A description of the resource instance.", title="Description"),
    ] = None
    resourceReferences: Annotated[
        Optional[List[ResourceReferenceChoice]],
        Field(
            description="References to component or service resources that are used to realize the resource instance.",
            title="Resource references",
        ),
    ] = None
    tasks: Annotated[
        Optional[List[Task]],
        Field(description="The tasks that comprise the workflow.", title="Tasks"),
    ] = None
    taskDependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="The graph of dependencies between tasks within the workflow.",
            title="Task dependency graph",
        ),
    ] = None
    taskTypes: Annotated[
        List[TaskType],
        Field(
            description="Indicates the types of activities performed by the set of workflow tasks.",
            title="Task types",
        ),
    ]
    trigger: Annotated[
        Optional[Trigger],
        Field(description="The trigger that initiated the task.", title="Trigger"),
    ] = None
    steps: Annotated[
        Optional[List[Step]],
        Field(description="The sequence of steps for the task.", title="Steps"),
    ] = None
    inputs: Annotated[
        Optional[List[InputType]],
        Field(
            description="Represents resources and data brought into a task at runtime by executor or task commands",
            examples=[
                "a `configuration` file which was declared as a local `component` or `externalReference`"
            ],
            title="Inputs",
        ),
    ] = None
    outputs: Annotated[
        Optional[List[OutputType]],
        Field(
            description="Represents resources and data output from a task at runtime by executor or task commands",
            examples=["a log file or metrics data produced by the task"],
            title="Outputs",
        ),
    ] = None
    timeStart: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the task started.", title="Time start"
        ),
    ] = None
    timeEnd: Annotated[
        Optional[datetime],
        Field(description="The date and time (timestamp) when the task ended.", title="Time end"),
    ] = None
    workspaces: Annotated[
        Optional[List[Workspace]],
        Field(
            description="A set of named filesystem or data resource shareable by workflow tasks.",
            title="Workspaces",
        ),
    ] = None
    runtimeTopology: Annotated[
        Optional[List[Dependency]],
        Field(
            description="A graph of the component runtime topology for workflow's instance.",
            title="Runtime topology",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Targets(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organizations: Annotated[
        Optional[List[OrganizationalEntity]],
        Field(
            description="The list of organizations which claims are made against.",
            title="Organizations",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="The list of components which claims are made against.", title="Components"
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(description="The list of services which claims are made against.", title="Services"),
    ] = None


class Declarations(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    assessors: Annotated[
        Optional[List[Assessor]],
        Field(
            description="The list of assessors evaluating claims and determining conformance to requirements and confidence in that assessment.",
            title="Assessors",
        ),
    ] = None
    attestations: Annotated[
        Optional[List[Attestation]],
        Field(
            description="The list of attestations asserted by an assessor that maps requirements to claims.",
            title="Attestations",
        ),
    ] = None
    claims: Annotated[
        Optional[List[Claim]], Field(description="The list of claims.", title="Claims")
    ] = None
    evidence: Annotated[
        Optional[List[EvidenceItem]], Field(description="The list of evidence", title="Evidence")
    ] = None
    targets: Annotated[
        Optional[Targets],
        Field(description="The list of targets which claims are made against.", title="Targets"),
    ] = None
    affirmation: Annotated[
        Optional[Affirmation],
        Field(
            description="A concise statement affirmed by an individual regarding all declarations, often used for third-party auditor acceptance or recipient acknowledgment. It includes a list of authorized signatories who assert the validity of the document on behalf of the organization.",
            title="Affirmation",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class CycloneDX(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    field_schema: Annotated[Optional[str], Field(alias="$schema")] = None
    bomFormat: Annotated[
        BomFormat,
        Field(
            description='Specifies the format of the BOM. This helps to identify the file as CycloneDX since BOMs do not have a filename convention, nor does JSON schema support namespaces. This value must be "CycloneDX".',
            title="BOM Format",
        ),
    ]
    specVersion: Annotated[
        str,
        Field(
            description="The version of the CycloneDX specification the BOM conforms to.",
            examples=["1.6.1"],
            title="CycloneDX Specification Version",
        ),
    ]
    serialNumber: Annotated[
        Optional[str],
        Field(
            description="Every BOM generated SHOULD have a unique serial number, even if the contents of the BOM have not changed over time. If specified, the serial number must conform to [RFC 4122](https://www.ietf.org/rfc/rfc4122.html). Use of serial numbers is recommended.",
            examples=["urn:uuid:3e671687-395b-41f5-a30f-a58921a69b79"],
            pattern="^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            title="BOM Serial Number",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Whenever an existing BOM is modified, either manually or through automated processes, the version of the BOM SHOULD be incremented by 1. When a system is presented with multiple BOMs with identical serial numbers, the system SHOULD use the most recent version of the BOM. The default version is '1'.",
            examples=[1],
            ge=1,
            title="BOM Version",
        ),
    ] = 1
    metadata: Annotated[
        Optional[Metadata],
        Field(description="Provides additional information about a BOM.", title="BOM Metadata"),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(description="A list of software and hardware components.", title="Components"),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description="A list of services. This may include microservices, function-as-a-service, and other types of network or intra-process services.",
            title="Services",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None
    dependencies: Annotated[
        Optional[List[Dependency]],
        Field(
            description="Provides the ability to document dependency relationships including provided & implemented components.",
            title="Dependencies",
        ),
    ] = None
    compositions: Annotated[
        Optional[List[Compositions]],
        Field(
            description="Compositions describe constituent parts (including components, services, and dependency relationships) and their completeness. The completeness of vulnerabilities expressed in a BOM may also be described.",
            title="Compositions",
        ),
    ] = None
    vulnerabilities: Annotated[
        Optional[List[Vulnerability]],
        Field(
            description="Vulnerabilities identified in components or services.",
            title="Vulnerabilities",
        ),
    ] = None
    annotations: Annotated[
        Optional[List[Annotations]],
        Field(
            description="Comments made by people, organizations, or tools about any object with a bom-ref, such as components, services, vulnerabilities, or the BOM itself. Unlike inventory information, annotations may contain opinions or commentary from various stakeholders. Annotations may be inline (with inventory) or externalized via BOM-Link and may optionally be signed.",
            title="Annotations",
        ),
    ] = None
    formulation: Annotated[
        Optional[List[Formula]],
        Field(
            description="Describes how a component or service was manufactured or deployed. This is achieved through the use of formulas, workflows, tasks, and steps, which declare the precise steps to reproduce along with the observed formulas describing the steps which transpired in the manufacturing process.",
            title="Formulation",
        ),
    ] = None
    declarations: Annotated[
        Optional[Declarations],
        Field(
            description="The list of declarations which describe the conformance to standards. Each declaration may include attestations, claims, and evidence.",
            title="Declarations",
        ),
    ] = None
    definitions: Annotated[
        Optional[Definitions],
        Field(
            description="A collection of reusable objects that are defined and may be used elsewhere in the BOM.",
            title="Definitions",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Tools(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components used as tools.",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description="A list of services used as tools. This may include microservices, function-as-a-service, and other types of network or intra-process services.",
            title="Services",
        ),
    ] = None


class Metadata(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    timestamp: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the BOM was created.",
            title="Timestamp",
        ),
    ] = None
    lifecycles: Annotated[
        Optional[List[Union[Lifecycles, Lifecycles1]]],
        Field(
            description="Lifecycles communicate the stage(s) in which data in the BOM was captured. Different types of data may be available at various phases of a lifecycle, such as the Software Development Lifecycle (SDLC), IT Asset Management (ITAM), and Software Asset Management (SAM). Thus, a BOM may include data specific to or only obtainable in a given lifecycle.",
            title="Lifecycles",
        ),
    ] = None
    tools: Annotated[
        Optional[Union[Tools, List[Tool]]],
        Field(
            description="The tool(s) used in the creation, enrichment, and validation of the BOM.",
            title="Tools",
        ),
    ] = None
    manufacturer: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that created the BOM.\nManufacturer is common in BOMs created through automated processes. BOMs created through manual means may have `@.authors` instead.",
            title="BOM Manufacturer",
        ),
    ] = None
    authors: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description="The person(s) who created the BOM.\nAuthors are common in BOMs created through manual processes. BOMs created through automated means may have `@.manufacturer` instead.",
            title="BOM Authors",
        ),
    ] = None
    component: Annotated[
        Optional[Component],
        Field(description="The component that the BOM describes.", title="Component"),
    ] = None
    manufacture: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="[Deprecated] This will be removed in a future version. Use the `@.component.manufacturer` instead.\nThe organization that manufactured the component that the BOM describes.",
            title="Component Manufacture (legacy)",
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=" The organization that supplied the component that the BOM describes. The supplier may often be the manufacturer, but may also be a distributor or repackager.",
            title="Supplier",
        ),
    ] = None
    licenses: Annotated[
        Optional[LicenseChoice],
        Field(
            description="The license information for the BOM document.\nThis may be different from the license(s) of the component(s) that the BOM describes.",
            title="BOM License(s)",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Pedigree(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ancestors: Annotated[
        Optional[List[Component]],
        Field(
            description="Describes zero or more components in which a component is derived from. This is commonly used to describe forks from existing projects where the forked version contains a ancestor node containing the original component it was forked from. For example, Component A is the original component. Component B is the component being used and documented in the BOM. However, Component B contains a pedigree node with a single ancestor documenting Component A - the original component from which Component B is derived from.",
            title="Ancestors",
        ),
    ] = None
    descendants: Annotated[
        Optional[List[Component]],
        Field(
            description="Descendants are the exact opposite of ancestors. This provides a way to document all forks (and their forks) of an original or root component.",
            title="Descendants",
        ),
    ] = None
    variants: Annotated[
        Optional[List[Component]],
        Field(
            description="Variants describe relations where the relationship between the components is not known. For example, if Component A contains nearly identical code to Component B. They are both related, but it is unclear if one is derived from the other, or if they share a common ancestor.",
            title="Variants",
        ),
    ] = None
    commits: Annotated[
        Optional[List[Commit]],
        Field(
            description="A list of zero or more commits which provide a trail describing how the component deviates from an ancestor, descendant, or variant.",
            title="Commits",
        ),
    ] = None
    patches: Annotated[
        Optional[List[Patch]],
        Field(
            description=">A list of zero or more patches describing how the component deviates from an ancestor, descendant, or variant. Patches may be complementary to commits or may be used in place of commits.",
            title="Patches",
        ),
    ] = None
    notes: Annotated[
        Optional[str],
        Field(
            description="Notes, observations, and other non-structured commentary describing the components pedigree.",
            title="Notes",
        ),
    ] = None


class Component(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    type: Annotated[
        Type,
        Field(
            description="Specifies the type of component. For software components, classify as application if no more specific appropriate classification is available or cannot be determined for the component.",
            examples=["library"],
            title="Component Type",
        ),
    ]
    mime_type: Annotated[
        Optional[str],
        Field(
            alias="mime-type",
            description="The optional mime-type of the component. When used on file components, the mime-type can provide additional context about the kind of file being represented, such as an image, font, or executable. Some library or framework components may also have an associated mime-type.",
            examples=["image/jpeg"],
            pattern="^[-+a-z0-9.]+/[-+a-z0-9.]+$",
            title="Mime-Type",
        ),
    ] = None
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the component elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    supplier: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description=" The organization that supplied the component. The supplier may often be the manufacturer, but may also be a distributor or repackager.",
            title="Component Supplier",
        ),
    ] = None
    manufacturer: Annotated[
        Optional[OrganizationalEntity],
        Field(
            description="The organization that created the component.\nManufacturer is common in components created through automated processes. Components created through manual means may have `@.authors` instead.",
            title="Component Manufacturer",
        ),
    ] = None
    authors: Annotated[
        Optional[List[OrganizationalContact]],
        Field(
            description="The person(s) who created the component.\nAuthors are common in components created through manual processes. Components created through automated means may have `@.manufacturer` instead.",
            title="Component Authors",
        ),
    ] = None
    author: Annotated[
        Optional[str],
        Field(
            description="[Deprecated] This will be removed in a future version. Use `@.authors` or `@.manufacturer` instead.\nThe person(s) or organization(s) that authored the component",
            examples=["Acme Inc"],
            title="Component Author (legacy)",
        ),
    ] = None
    publisher: Annotated[
        Optional[str],
        Field(
            description="The person(s) or organization(s) that published the component",
            examples=["Acme Inc"],
            title="Component Publisher",
        ),
    ] = None
    group: Annotated[
        Optional[str],
        Field(
            description="The grouping name or identifier. This will often be a shortened, single name of the company or project that produced the component, or the source package or domain name. Whitespace and special characters should be avoided. Examples include: apache, org.apache.commons, and apache.org.",
            examples=["com.acme"],
            title="Component Group",
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description="The name of the component. This will often be a shortened, single name of the component. Examples: commons-lang3 and jquery",
            examples=["tomcat-catalina"],
            title="Component Name",
        ),
    ]
    version: Annotated[
        Optional[Version],
        Field(
            description="The component version. The version should ideally comply with semantic versioning but is not enforced.",
            title="Component Version",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="Specifies a description for the component", title="Component Description"
        ),
    ] = None
    scope: Annotated[
        Optional[Scope],
        Field(
            description="Specifies the scope of the component. If scope is not specified, 'required' scope SHOULD be assumed by the consumer of the BOM.",
            title="Component Scope",
        ),
    ] = "required"
    hashes: Annotated[
        Optional[List[Hash]],
        Field(description="The hashes of the component.", title="Component Hashes"),
    ] = None
    licenses: Annotated[Optional[LicenseChoice], Field(title="Component License(s)")] = None
    copyright: Annotated[
        Optional[str],
        Field(
            description="A copyright notice informing users of the underlying claims to copyright ownership in a published work.",
            examples=["Acme Inc"],
            title="Component Copyright",
        ),
    ] = None
    cpe: Annotated[
        Optional[str],
        Field(
            description="Asserts the identity of the component using CPE. The CPE must conform to the CPE 2.2 or 2.3 specification. See [https://nvd.nist.gov/products/cpe](https://nvd.nist.gov/products/cpe). Refer to `@.evidence.identity` to optionally provide evidence that substantiates the assertion of the component's identity.",
            examples=["cpe:2.3:a:acme:component_framework:-:*:*:*:*:*:*:*"],
            title="Common Platform Enumeration (CPE)",
        ),
    ] = None
    purl: Annotated[
        Optional[str],
        Field(
            description="Asserts the identity of the component using package-url (purl). The purl, if specified, must be valid and conform to the specification defined at: [https://github.com/package-url/purl-spec](https://github.com/package-url/purl-spec). Refer to `@.evidence.identity` to optionally provide evidence that substantiates the assertion of the component's identity.",
            examples=["pkg:maven/com.acme/tomcat-catalina@9.0.14?packaging=jar"],
            title="Package URL (purl)",
        ),
    ] = None
    omniborId: Annotated[
        Optional[List[str]],
        Field(
            description="Asserts the identity of the component using the OmniBOR Artifact ID. The OmniBOR, if specified, must be valid and conform to the specification defined at: [https://www.iana.org/assignments/uri-schemes/prov/gitoid](https://www.iana.org/assignments/uri-schemes/prov/gitoid). Refer to `@.evidence.identity` to optionally provide evidence that substantiates the assertion of the component's identity.",
            examples=[
                "gitoid:blob:sha1:a94a8fe5ccb19ba61c4c0873d391e987982fbbd3",
                "gitoid:blob:sha256:9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08",
            ],
            title="OmniBOR Artifact Identifier (gitoid)",
        ),
    ] = None
    swhid: Annotated[
        Optional[List[str]],
        Field(
            description="Asserts the identity of the component using the Software Heritage persistent identifier (SWHID). The SWHID, if specified, must be valid and conform to the specification defined at: [https://docs.softwareheritage.org/devel/swh-model/persistent-identifiers.html](https://docs.softwareheritage.org/devel/swh-model/persistent-identifiers.html). Refer to `@.evidence.identity` to optionally provide evidence that substantiates the assertion of the component's identity.",
            examples=["swh:1:cnt:94a9ed024d3859793618152ea559a168bbcbb5e2"],
            title="Software Heritage Identifier",
        ),
    ] = None
    swid: Annotated[
        Optional[Swid],
        Field(
            description="Asserts the identity of the component using [ISO-IEC 19770-2 Software Identification (SWID) Tags](https://www.iso.org/standard/65666.html). Refer to `@.evidence.identity` to optionally provide evidence that substantiates the assertion of the component's identity.",
            title="SWID Tag",
        ),
    ] = None
    modified: Annotated[
        Optional[bool],
        Field(
            description="[Deprecated] This will be removed in a future version. Use the pedigree element instead to supply information on exactly how the component was modified. A boolean value indicating if the component has been modified from the original. A value of true indicates the component is a derivative of the original. A value of false indicates the component has not been modified from the original.",
            title="Component Modified From Original",
        ),
    ] = None
    pedigree: Annotated[
        Optional[Pedigree],
        Field(
            description="Component pedigree is a way to document complex supply chain scenarios where components are created, distributed, modified, redistributed, combined with other components, etc. Pedigree supports viewing this complex chain from the beginning, the end, or anywhere in the middle. It also provides a way to document variants where the exact relation may not be known.",
            title="Component Pedigree",
        ),
    ] = None
    externalReferences: Annotated[
        Optional[List[ExternalReference]],
        Field(
            description="External references provide a way to document systems, sites, and information that may be relevant but are not included with the BOM. They may also establish specific relationships within or external to the BOM.",
            title="External References",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="A list of software and hardware components included in the parent component. This is not a dependency tree. It provides a way to specify a hierarchical representation of component assemblies, similar to system &#8594; subsystem &#8594; parts assembly in physical supply chains.",
            title="Components",
        ),
    ] = None
    evidence: Annotated[
        Optional[ComponentEvidence],
        Field(
            description="Provides the ability to document evidence collected through various forms of extraction or analysis.",
            title="Evidence",
        ),
    ] = None
    releaseNotes: Annotated[
        Optional[ReleaseNotes],
        Field(description="Specifies optional release notes.", title="Release notes"),
    ] = None
    modelCard: Annotated[Optional[ModelCard], Field(title="AI/ML Model Card")] = None
    data: Annotated[
        Optional[List[ComponentData]],
        Field(
            description="This object SHOULD be specified for any component of type `data` and must not be specified for other component types.",
            title="Data",
        ),
    ] = None
    cryptoProperties: Annotated[
        Optional[CryptoProperties], Field(title="Cryptographic Properties")
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None
    tags: Annotated[Optional[Tags], Field(title="Tags")] = None
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Vulnerability(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the vulnerability elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            description="The identifier that uniquely identifies the vulnerability.",
            examples=["CVE-2021-39182", "GHSA-35m5-8cvj-8783", "SNYK-PYTHON-ENROCRYPT-1912876"],
            title="ID",
        ),
    ] = None
    source: Annotated[
        Optional[VulnerabilitySource],
        Field(description="The source that published the vulnerability."),
    ] = None
    references: Annotated[
        Optional[List[Reference]],
        Field(
            description="Zero or more pointers to vulnerabilities that are the equivalent of the vulnerability specified. Often times, the same vulnerability may exist in multiple sources of vulnerability intelligence, but have different identifiers. References provide a way to correlate vulnerabilities across multiple sources of vulnerability intelligence.",
            title="References",
        ),
    ] = None
    ratings: Annotated[
        Optional[List[Rating]], Field(description="List of vulnerability ratings", title="Ratings")
    ] = None
    cwes: Annotated[
        Optional[List[Cwe]],
        Field(
            description="List of Common Weaknesses Enumerations (CWEs) codes that describes this vulnerability.",
            examples=[399],
            title="CWEs",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="A description of the vulnerability as provided by the source.",
            title="Description",
        ),
    ] = None
    detail: Annotated[
        Optional[str],
        Field(
            description="If available, an in-depth description of the vulnerability as provided by the source organization. Details often include information useful in understanding root cause.",
            title="Details",
        ),
    ] = None
    recommendation: Annotated[
        Optional[str],
        Field(
            description="Recommendations of how the vulnerability can be remediated or mitigated.",
            title="Recommendation",
        ),
    ] = None
    workaround: Annotated[
        Optional[str],
        Field(
            description="A bypass, usually temporary, of the vulnerability that reduces its likelihood and/or impact. Workarounds often involve changes to configuration or deployments.",
            title="Workarounds",
        ),
    ] = None
    proofOfConcept: Annotated[
        Optional[ProofOfConcept],
        Field(
            description="Evidence used to reproduce the vulnerability.", title="Proof of Concept"
        ),
    ] = None
    advisories: Annotated[
        Optional[List[Advisory]],
        Field(
            description="Published advisories of the vulnerability if provided.",
            title="Advisories",
        ),
    ] = None
    created: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was created in the vulnerability database.",
            title="Created",
        ),
    ] = None
    published: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was first published.",
            title="Published",
        ),
    ] = None
    updated: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was last updated.",
            title="Updated",
        ),
    ] = None
    rejected: Annotated[
        Optional[datetime],
        Field(
            description="The date and time (timestamp) when the vulnerability record was rejected (if applicable).",
            title="Rejected",
        ),
    ] = None
    credits: Annotated[
        Optional[Credits],
        Field(
            description="Individuals or organizations credited with the discovery of the vulnerability.",
            title="Credits",
        ),
    ] = None
    tools: Annotated[
        Optional[Union[Tools, List[Tool]]],
        Field(
            description="The tool(s) used to identify, confirm, or score the vulnerability.",
            title="Tools",
        ),
    ] = None
    analysis: Annotated[
        Optional[Analysis],
        Field(
            description="An assessment of the impact and exploitability of the vulnerability.",
            title="Impact Analysis",
        ),
    ] = None
    affects: Annotated[
        Optional[List[Affect]],
        Field(
            description="The components or services that are affected by the vulnerability.",
            title="Affects",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


class Annotator(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        OrganizationalEntity, Field(description="The organization that created the annotation")
    ]
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(description="The person that created the annotation"),
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[
        Optional[Service], Field(description="The service that created the annotation")
    ] = None


class Annotator1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that created the annotation"),
    ] = None
    individual: Annotated[
        OrganizationalContact, Field(description="The person that created the annotation")
    ]
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[
        Optional[Service], Field(description="The service that created the annotation")
    ] = None


class Annotator2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that created the annotation"),
    ] = None
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(description="The person that created the annotation"),
    ] = None
    component: Annotated[
        Component, Field(description="The tool or component that created the annotation")
    ]
    service: Annotated[
        Optional[Service], Field(description="The service that created the annotation")
    ] = None


class Annotator3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    organization: Annotated[
        Optional[OrganizationalEntity],
        Field(description="The organization that created the annotation"),
    ] = None
    individual: Annotated[
        Optional[OrganizationalContact],
        Field(description="The person that created the annotation"),
    ] = None
    component: Annotated[
        Optional[Component], Field(description="The tool or component that created the annotation")
    ] = None
    service: Annotated[Service, Field(description="The service that created the annotation")]


class Annotations(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the annotation elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    subjects: Annotated[
        List[Union[RefLinkType, BomLinkElementType]],
        Field(
            description="The object in the BOM identified by its bom-ref. This is often a component or service, but may be any object type supporting bom-refs.",
            title="Subjects",
        ),
    ]
    annotator: Annotated[
        Union[Annotator, Annotator1, Annotator2, Annotator3],
        Field(
            description="The organization, person, component, or service which created the textual content of the annotation.",
            title="Annotator",
        ),
    ]
    timestamp: Annotated[
        datetime,
        Field(
            description="The date and time (timestamp) when the annotation was created.",
            title="Timestamp",
        ),
    ]
    text: Annotated[str, Field(description="The textual content of the annotation.", title="Text")]
    signature: Annotated[
        Optional[Signature],
        Field(
            description="Enveloped signature in [JSON Signature Format (JSF)](https://cyberphone.github.io/doc/security/jsf.html).",
            title="Signature",
        ),
    ] = None


class Formula(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    bom_ref: Annotated[
        Optional[RefType],
        Field(
            alias="bom-ref",
            description="An optional identifier which can be used to reference the formula elsewhere in the BOM. Every bom-ref must be unique within the BOM.\nValue SHOULD not start with the BOM-Link intro 'urn:cdx:' to avoid conflicts with BOM-Links.",
            title="BOM Reference",
        ),
    ] = None
    components: Annotated[
        Optional[List[Component]],
        Field(
            description="Transient components that are used in tasks that constitute one or more of this formula's workflows",
            title="Components",
        ),
    ] = None
    services: Annotated[
        Optional[List[Service]],
        Field(
            description="Transient services that are used in tasks that constitute one or more of this formula's workflows",
            title="Services",
        ),
    ] = None
    workflows: Annotated[
        Optional[List[Workflow]],
        Field(
            description="List of workflows that can be declared to accomplish specific orchestrated goals and independently triggered.",
            title="Workflows",
        ),
    ] = None
    properties: Annotated[
        Optional[List[Property]],
        Field(
            description="Provides the ability to document properties in a name-value store. This provides flexibility to include data not officially supported in the standard without having to use additional namespaces or create extensions. Unlike key-value stores, properties support duplicate names, each potentially having different values. Property names of interest to the general public are encouraged to be registered in the [CycloneDX Property Taxonomy](https://github.com/CycloneDX/cyclonedx-property-taxonomy). Formal registration is optional.",
            title="Properties",
        ),
    ] = None


Service.model_rebuild()
Targets.model_rebuild()
CycloneDX.model_rebuild()
Tools.model_rebuild()
Metadata.model_rebuild()
Pedigree.model_rebuild()
