from tempfile import NamedTemporaryFile

from unittest import IsolatedAsyncioTestCase

from ...cache.base import BaseCache
from ...core.profile import ProfileManager
from ...core.protocol_registry import ProtocolRegistry
from ...transport.wire_format import BaseWireFormat

from ..default_context import DefaultContextBuilder
from ..injection_context import InjectionContext


class TestDefaultContext(IsolatedAsyncioTestCase):
    async def test_build_context(self):
        """Test context init."""

        builder = DefaultContextBuilder()
        result = await builder.build_context()
        assert isinstance(result, InjectionContext)

        for cls in (
            BaseCache,
            BaseWireFormat,
            ProfileManager,
            ProtocolRegistry,
        ):
            assert isinstance(result.inject(cls), cls)

        builder = DefaultContextBuilder(
            settings={
                "timing.enabled": True,
                "timing.log.file": NamedTemporaryFile().name,
                "multitenant.admin_enabled": True,
            }
        )
        result = await builder.build_context()
        assert isinstance(result, InjectionContext)
