# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, constr, validator

from typing import Dict, Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.fee_rule import FeeRule
from lusid.models.fee_rule_upsert_request import FeeRuleUpsertRequest
from lusid.models.fee_rule_upsert_response import FeeRuleUpsertResponse
from lusid.models.resource_list_of_fee_rule import ResourceListOfFeeRule

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class TransactionFeesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeleteTransactionFeeRule: Deletes a fee rule.  # noqa: E501

        Deletes the rule for all effective time.    The rule will remain viewable at previous as at times, but it will no longer be considered by  GetApplicableFees.    This cannot be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_fee_rule(code, async_req=True)
        >>> result = thread.get()

        :param code: The fee rule code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_fee_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_transaction_fee_rule_with_http_info(code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_fee_rule_with_http_info(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteTransactionFeeRule: Deletes a fee rule.  # noqa: E501

        Deletes the rule for all effective time.    The rule will remain viewable at previous as at times, but it will no longer be considered by  GetApplicableFees.    This cannot be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_fee_rule_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The fee rule code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_fee_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactions/fees/rules/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_applicable_transaction_fees(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.")] = None, instrument_identifier_type : Annotated[Optional[StrictStr], Field( description="Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.")] = None, instrument_identifier : Annotated[Optional[StrictStr], Field( description="Optional. The Instrument Identifier to get properties for.")] = None, portfolio_scope : Annotated[Optional[StrictStr], Field( description="Optional. The scope of the portfolio to fetch properties from.")] = None, portfolio_code : Annotated[Optional[StrictStr], Field( description="Optional. The code of the portfolio to fetch properties from.")] = None, request_body : Annotated[Optional[Dict[str, StrictStr]], Field(description="Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".")] = None, **kwargs) -> ResourceListOfFeeRule:  # noqa: E501
        ...

    @overload
    def get_applicable_transaction_fees(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.")] = None, instrument_identifier_type : Annotated[Optional[StrictStr], Field( description="Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.")] = None, instrument_identifier : Annotated[Optional[StrictStr], Field( description="Optional. The Instrument Identifier to get properties for.")] = None, portfolio_scope : Annotated[Optional[StrictStr], Field( description="Optional. The scope of the portfolio to fetch properties from.")] = None, portfolio_code : Annotated[Optional[StrictStr], Field( description="Optional. The code of the portfolio to fetch properties from.")] = None, request_body : Annotated[Optional[Dict[str, StrictStr]], Field(description="Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfFeeRule:  # noqa: E501
        ...

    @validate_arguments
    def get_applicable_transaction_fees(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.")] = None, instrument_identifier_type : Annotated[Optional[StrictStr], Field( description="Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.")] = None, instrument_identifier : Annotated[Optional[StrictStr], Field( description="Optional. The Instrument Identifier to get properties for.")] = None, portfolio_scope : Annotated[Optional[StrictStr], Field( description="Optional. The scope of the portfolio to fetch properties from.")] = None, portfolio_code : Annotated[Optional[StrictStr], Field( description="Optional. The code of the portfolio to fetch properties from.")] = None, request_body : Annotated[Optional[Dict[str, StrictStr]], Field(description="Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfFeeRule, Awaitable[ResourceListOfFeeRule]]:  # noqa: E501
        """GetApplicableTransactionFees: Get the Fees and Commissions that may be applicable to a transaction.  # noqa: E501

        Additionally, matching can be based on the instrument's properties, its portfolio properties, and any additional property keys present in the data file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_applicable_transaction_fees(effective_at, as_at, instrument_identifier_type, instrument_identifier, portfolio_scope, portfolio_code, request_body, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param instrument_identifier_type: Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.
        :type instrument_identifier_type: str
        :param instrument_identifier: Optional. The Instrument Identifier to get properties for.
        :type instrument_identifier: str
        :param portfolio_scope: Optional. The scope of the portfolio to fetch properties from.
        :type portfolio_scope: str
        :param portfolio_code: Optional. The code of the portfolio to fetch properties from.
        :type portfolio_code: str
        :param request_body: Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".
        :type request_body: Dict[str, str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfFeeRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_applicable_transaction_fees_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_applicable_transaction_fees_with_http_info(effective_at, as_at, instrument_identifier_type, instrument_identifier, portfolio_scope, portfolio_code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def get_applicable_transaction_fees_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.")] = None, instrument_identifier_type : Annotated[Optional[StrictStr], Field( description="Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.")] = None, instrument_identifier : Annotated[Optional[StrictStr], Field( description="Optional. The Instrument Identifier to get properties for.")] = None, portfolio_scope : Annotated[Optional[StrictStr], Field( description="Optional. The scope of the portfolio to fetch properties from.")] = None, portfolio_code : Annotated[Optional[StrictStr], Field( description="Optional. The code of the portfolio to fetch properties from.")] = None, request_body : Annotated[Optional[Dict[str, StrictStr]], Field(description="Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetApplicableTransactionFees: Get the Fees and Commissions that may be applicable to a transaction.  # noqa: E501

        Additionally, matching can be based on the instrument's properties, its portfolio properties, and any additional property keys present in the data file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_applicable_transaction_fees_with_http_info(effective_at, as_at, instrument_identifier_type, instrument_identifier, portfolio_scope, portfolio_code, request_body, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to match rule definitions. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to match rule definitions. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param instrument_identifier_type: Optional. The unique identifier type to use, eg 'Figi' or 'LusidInstrumentId'.
        :type instrument_identifier_type: str
        :param instrument_identifier: Optional. The Instrument Identifier to get properties for.
        :type instrument_identifier: str
        :param portfolio_scope: Optional. The scope of the portfolio to fetch properties from.
        :type portfolio_scope: str
        :param portfolio_code: Optional. The code of the portfolio to fetch properties from.
        :type portfolio_code: str
        :param request_body: Any other property keys or fields, including the top-level fields of the              fee rule (e.g. \"ExecutionBroker\" and \"SettlementCurrency\" ) and those defined in AdditionalKeys, along with              their corresponding values that should be matched for fees. Eg. \"Instrument/default/Name=exampleValue\" or              \"AdditionalKey2=Value2\".
        :type request_body: Dict[str, str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfFeeRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'instrument_identifier_type',
            'instrument_identifier',
            'portfolio_scope',
            'portfolio_code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_applicable_transaction_fees" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('instrument_identifier_type') is not None:  # noqa: E501
            _query_params.append(('instrumentIdentifierType', _params['instrument_identifier_type']))

        if _params.get('instrument_identifier') is not None:  # noqa: E501
            _query_params.append(('instrumentIdentifier', _params['instrument_identifier']))

        if _params.get('portfolio_scope') is not None:  # noqa: E501
            _query_params.append(('portfolioScope', _params['portfolio_scope']))

        if _params.get('portfolio_code') is not None:  # noqa: E501
            _query_params.append(('portfolioCode', _params['portfolio_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfFeeRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactions/fees/$GetApplicableFees', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.")] = None, **kwargs) -> FeeRule:  # noqa: E501
        ...

    @overload
    def get_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> FeeRule:  # noqa: E501
        ...

    @validate_arguments
    def get_transaction_fee_rule(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FeeRule, Awaitable[FeeRule]]:  # noqa: E501
        """GetTransactionFeeRule: Retrieve the definition of single fee rule.  # noqa: E501

        Retrieves the fee rule definition at the given effective and as at times.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_fee_rule(code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param code: The fee rule code. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FeeRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_transaction_fee_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_transaction_fee_rule_with_http_info(code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transaction_fee_rule_with_http_info(self, code : Annotated[StrictStr, Field(..., description="The fee rule code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetTransactionFeeRule: Retrieve the definition of single fee rule.  # noqa: E501

        Retrieves the fee rule definition at the given effective and as at times.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_fee_rule_with_http_info(code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param code: The fee rule code. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the rule definition. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the rule definition. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FeeRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_fee_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FeeRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactions/fees/rules/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_transaction_fee_rules(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.")] = None, **kwargs) -> ResourceListOfFeeRule:  # noqa: E501
        ...

    @overload
    def list_transaction_fee_rules(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfFeeRule:  # noqa: E501
        ...

    @validate_arguments
    def list_transaction_fee_rules(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfFeeRule, Awaitable[ResourceListOfFeeRule]]:  # noqa: E501
        """ListTransactionFeeRules: List fee rules, with optional filtering.  # noqa: E501

        For more information about filtering results,  see https://support.lusid.com/knowledgebase/article/KA-01914.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_fee_rules(effective_at, as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.
        :type filter: str
        :param page: The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfFeeRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transaction_fee_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_transaction_fee_rules_with_http_info(effective_at, as_at, limit, filter, page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transaction_fee_rules_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListTransactionFeeRules: List fee rules, with optional filtering.  # noqa: E501

        For more information about filtering results,  see https://support.lusid.com/knowledgebase/article/KA-01914.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_fee_rules_with_http_info(effective_at, as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to retrieve the rule definitions. Defaults to the current LUSID  system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the rule definitions. Defaults to returning the latest version if not  specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.
        :type filter: str
        :param page: The pagination token to use to continue listing entities; this value is returned from the previous call. If  a pagination token is provided, the filter, effectiveAt and asAt fields must not have changed since the  original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfFeeRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'limit',
            'filter',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transaction_fee_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfFeeRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactions/fees/rules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_transaction_fee_rules(self, request_body : Annotated[Dict[str, FeeRuleUpsertRequest], Field(..., description="A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.")] = None, **kwargs) -> FeeRuleUpsertResponse:  # noqa: E501
        ...

    @overload
    def upsert_transaction_fee_rules(self, request_body : Annotated[Dict[str, FeeRuleUpsertRequest], Field(..., description="A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.")] = None, async_req: Optional[bool]=True, **kwargs) -> FeeRuleUpsertResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_transaction_fee_rules(self, request_body : Annotated[Dict[str, FeeRuleUpsertRequest], Field(..., description="A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FeeRuleUpsertResponse, Awaitable[FeeRuleUpsertResponse]]:  # noqa: E501
        """UpsertTransactionFeeRules: Upsert fee rules.  # noqa: E501

        To upsert a new rule, the code field must be left empty, a code will then be assigned and returned as part  of the response. To update an existing rule, include the fee code. It is possible to both create and update  fee rules in the same request.    The upsert is transactional - either all create/update operations will succeed or none of them will.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_transaction_fee_rules(request_body, effective_at, async_req=True)
        >>> result = thread.get()

        :param request_body: A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule. (required)
        :type request_body: Dict[str, FeeRuleUpsertRequest]
        :param effective_at: The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FeeRuleUpsertResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_transaction_fee_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_transaction_fee_rules_with_http_info(request_body, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_transaction_fee_rules_with_http_info(self, request_body : Annotated[Dict[str, FeeRuleUpsertRequest], Field(..., description="A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertTransactionFeeRules: Upsert fee rules.  # noqa: E501

        To upsert a new rule, the code field must be left empty, a code will then be assigned and returned as part  of the response. To update an existing rule, include the fee code. It is possible to both create and update  fee rules in the same request.    The upsert is transactional - either all create/update operations will succeed or none of them will.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_transaction_fee_rules_with_http_info(request_body, effective_at, async_req=True)
        >>> result = thread.get()

        :param request_body: A dictionary of upsert request identifiers to rule upsert requests. The request              identifiers are valid for the request only and can be used to link the upserted fee rule to the code of a              created fee rule. (required)
        :type request_body: Dict[str, FeeRuleUpsertRequest]
        :param effective_at: The effective datetime or cut label at which the rule will take effect. Defaults to the current LUSID  system datetime if not specified. In the case of an update, the changes will take place from this effective  time until the next effective time that the rule as been upserted at. For example, consider a rule that  already exists, and has previously had an update applied so that the definition will change on the first day  of the coming month. An upsert effective from the current day will only change the definition until the  first day of the coming month. An additional upsert at the same time (first day of the month) is required  if the newly-updated definition is to supersede the future definition.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FeeRuleUpsertResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_transaction_fee_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FeeRuleUpsertResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactions/fees/rules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
