# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 
from lusid.models.investor_record import InvestorRecord
from lusid.models.model_property import ModelProperty

class AccountHolder(BaseModel):
    """
    An Account Holder of an Investment Account.  # noqa: E501
    """
    key:  Optional[StrictStr] = Field(None,alias="key", description="A client-defined key used to identify the Account Holder, unique within the Investment Account") 
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="The scope in which the Investor Record lies.") 
    identifiers: Optional[Dict[str, ModelProperty]] = Field(None, description="Single Account Holder identifier that should target the desired Investor Record.")
    entity_unique_id:  Optional[StrictStr] = Field(None,alias="entityUniqueId", description="The unique InvestorRecord entity identifier") 
    investor_record: Optional[InvestorRecord] = Field(None, alias="investorRecord")
    __properties = ["key", "scope", "identifiers", "entityUniqueId", "investorRecord"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountHolder:
        """Create an instance of AccountHolder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in identifiers (dict)
        _field_dict = {}
        if self.identifiers:
            for _key in self.identifiers:
                if self.identifiers[_key]:
                    _field_dict[_key] = self.identifiers[_key].to_dict()
            _dict['identifiers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of investor_record
        if self.investor_record:
            _dict['investorRecord'] = self.investor_record.to_dict()
        # set to None if key (nullable) is None
        # and __fields_set__ contains the field
        if self.key is None and "key" in self.__fields_set__:
            _dict['key'] = None

        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        # set to None if identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.identifiers is None and "identifiers" in self.__fields_set__:
            _dict['identifiers'] = None

        # set to None if entity_unique_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_unique_id is None and "entity_unique_id" in self.__fields_set__:
            _dict['entityUniqueId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountHolder:
        """Create an instance of AccountHolder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountHolder.parse_obj(obj)

        _obj = AccountHolder.parse_obj({
            "key": obj.get("key"),
            "scope": obj.get("scope"),
            "identifiers": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("identifiers").items()
            )
            if obj.get("identifiers") is not None
            else None,
            "entity_unique_id": obj.get("entityUniqueId"),
            "investor_record": InvestorRecord.from_dict(obj.get("investorRecord")) if obj.get("investorRecord") is not None else None
        })
        return _obj
