# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class InvestmentPortfolioIdentifier(BaseModel):
    """
    InvestmentPortfolioIdentifier
    """
    key:  StrictStr = Field(...,alias="key", description="A client-defined key used to identify the Investment Portfolio, unique within the Investment Account") 
    portfolio_scope:  StrictStr = Field(...,alias="portfolioScope", description="The scope of the Investment Portfolio.") 
    portfolio_code:  StrictStr = Field(...,alias="portfolioCode", description="The code of the Investment Portfolio.") 
    __properties = ["key", "portfolioScope", "portfolioCode"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvestmentPortfolioIdentifier:
        """Create an instance of InvestmentPortfolioIdentifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvestmentPortfolioIdentifier:
        """Create an instance of InvestmentPortfolioIdentifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvestmentPortfolioIdentifier.parse_obj(obj)

        _obj = InvestmentPortfolioIdentifier.parse_obj({
            "key": obj.get("key"),
            "portfolio_scope": obj.get("portfolioScope"),
            "portfolio_code": obj.get("portfolioCode")
        })
        return _obj
