# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.date_range import DateRange
from lusid.models.resource_id import ResourceId

class ReconciliationTransactions(BaseModel):
    """
    Specification for the transactions of a scheduled reconciliation  # noqa: E501
    """
    transaction_window: Optional[DateRange] = Field(None, alias="transactionWindow")
    mapping_id: Optional[ResourceId] = Field(None, alias="mappingId")
    __properties = ["transactionWindow", "mappingId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciliationTransactions:
        """Create an instance of ReconciliationTransactions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of transaction_window
        if self.transaction_window:
            _dict['transactionWindow'] = self.transaction_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mapping_id
        if self.mapping_id:
            _dict['mappingId'] = self.mapping_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciliationTransactions:
        """Create an instance of ReconciliationTransactions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciliationTransactions.parse_obj(obj)

        _obj = ReconciliationTransactions.parse_obj({
            "transaction_window": DateRange.from_dict(obj.get("transactionWindow")) if obj.get("transactionWindow") is not None else None,
            "mapping_id": ResourceId.from_dict(obj.get("mappingId")) if obj.get("mappingId") is not None else None
        })
        return _obj
