# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool 
from lusid.models.date_or_diary_entry import DateOrDiaryEntry

class ValuationPointDataQueryParameters(BaseModel):
    """
    The parameters used in getting the ValuationPointData.  # noqa: E501
    """
    start: Optional[DateOrDiaryEntry] = None
    end: DateOrDiaryEntry = Field(...)
    exclude_cleardown_module: Optional[StrictBool] = Field(None, alias="excludeCleardownModule", description="By deafult this flag is set to false, if this is set to true, no cleardown module will be applied to the trial balance.")
    __properties = ["start", "end", "excludeCleardownModule"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ValuationPointDataQueryParameters:
        """Create an instance of ValuationPointDataQueryParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of start
        if self.start:
            _dict['start'] = self.start.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end
        if self.end:
            _dict['end'] = self.end.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ValuationPointDataQueryParameters:
        """Create an instance of ValuationPointDataQueryParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ValuationPointDataQueryParameters.parse_obj(obj)

        _obj = ValuationPointDataQueryParameters.parse_obj({
            "start": DateOrDiaryEntry.from_dict(obj.get("start")) if obj.get("start") is not None else None,
            "end": DateOrDiaryEntry.from_dict(obj.get("end")) if obj.get("end") is not None else None,
            "exclude_cleardown_module": obj.get("excludeCleardownModule")
        })
        return _obj
