# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceCustomFieldValueResult',
    'AwaitableGetServiceCustomFieldValueResult',
    'get_service_custom_field_value',
    'get_service_custom_field_value_output',
]

@pulumi.output_type
class GetServiceCustomFieldValueResult:
    """
    A collection of values returned by getServiceCustomFieldValue.
    """
    def __init__(__self__, custom_fields=None, id=None, service_id=None):
        if custom_fields and not isinstance(custom_fields, list):
            raise TypeError("Expected argument 'custom_fields' to be a list")
        pulumi.set(__self__, "custom_fields", custom_fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Sequence['outputs.GetServiceCustomFieldValueCustomFieldResult']:
        """
        A list of custom field values associated with the service. Each element contains:
        """
        return pulumi.get(self, "custom_fields")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the custom field.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")


class AwaitableGetServiceCustomFieldValueResult(GetServiceCustomFieldValueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceCustomFieldValueResult(
            custom_fields=self.custom_fields,
            id=self.id,
            service_id=self.service_id)


def get_service_custom_field_value(service_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceCustomFieldValueResult:
    """
    Use this data source to get information about service custom field values in PagerDuty.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_pagerduty as pagerduty

    # Create a service
    example_service = pagerduty.Service("example",
        name="Example Service",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_pagerduty_escalation_policy["id"])
    example = pagerduty.get_service_custom_field_value_output(service_id=example_service.id)
    pulumi.export("environmentValue", example.apply(lambda example: [field.value for field in example.custom_fields if field.name == "environment"][0]))
    # Set custom field values on the service
    example_service_custom_field_value = pagerduty.ServiceCustomFieldValue("example",
        service_id=example_service.id,
        custom_fields=[
            {
                "name": "environment",
                "value": json.dumps("production"),
            },
            {
                "name": "region",
                "value": json.dumps("us-east-1"),
            },
        ])
    ```


    :param _builtins.str service_id: The ID of the service to get custom field values for.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getServiceCustomFieldValue:getServiceCustomFieldValue', __args__, opts=opts, typ=GetServiceCustomFieldValueResult).value

    return AwaitableGetServiceCustomFieldValueResult(
        custom_fields=pulumi.get(__ret__, 'custom_fields'),
        id=pulumi.get(__ret__, 'id'),
        service_id=pulumi.get(__ret__, 'service_id'))
def get_service_custom_field_value_output(service_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceCustomFieldValueResult]:
    """
    Use this data source to get information about service custom field values in PagerDuty.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_pagerduty as pagerduty

    # Create a service
    example_service = pagerduty.Service("example",
        name="Example Service",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_pagerduty_escalation_policy["id"])
    example = pagerduty.get_service_custom_field_value_output(service_id=example_service.id)
    pulumi.export("environmentValue", example.apply(lambda example: [field.value for field in example.custom_fields if field.name == "environment"][0]))
    # Set custom field values on the service
    example_service_custom_field_value = pagerduty.ServiceCustomFieldValue("example",
        service_id=example_service.id,
        custom_fields=[
            {
                "name": "environment",
                "value": json.dumps("production"),
            },
            {
                "name": "region",
                "value": json.dumps("us-east-1"),
            },
        ])
    ```


    :param _builtins.str service_id: The ID of the service to get custom field values for.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getServiceCustomFieldValue:getServiceCustomFieldValue', __args__, opts=opts, typ=GetServiceCustomFieldValueResult)
    return __ret__.apply(lambda __response__: GetServiceCustomFieldValueResult(
        custom_fields=pulumi.get(__response__, 'custom_fields'),
        id=pulumi.get(__response__, 'id'),
        service_id=pulumi.get(__response__, 'service_id')))
