# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RulesetArgs', 'Ruleset']

@pulumi.input_type
class RulesetArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input['RulesetTeamArgs']] = None):
        """
        The set of arguments for constructing a Ruleset resource.
        :param pulumi.Input[_builtins.str] name: Name of the ruleset.
        :param pulumi.Input['RulesetTeamArgs'] team: Reference to the team that owns the ruleset. If none is specified, only admins have access.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input['RulesetTeamArgs']]:
        """
        Reference to the team that owns the ruleset. If none is specified, only admins have access.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input['RulesetTeamArgs']]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class _RulesetState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 team: Optional[pulumi.Input['RulesetTeamArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ruleset resources.
        :param pulumi.Input[_builtins.str] name: Name of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] routing_keys: Routing keys routed to this ruleset.
        :param pulumi.Input['RulesetTeamArgs'] team: Reference to the team that owns the ruleset. If none is specified, only admins have access.
        :param pulumi.Input[_builtins.str] type: Type of ruleset. Currently, only sets to `global`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_keys is not None:
            pulumi.set(__self__, "routing_keys", routing_keys)
        if team is not None:
            pulumi.set(__self__, "team", team)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="routingKeys")
    def routing_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Routing keys routed to this ruleset.
        """
        return pulumi.get(self, "routing_keys")

    @routing_keys.setter
    def routing_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "routing_keys", value)

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input['RulesetTeamArgs']]:
        """
        Reference to the team that owns the ruleset. If none is specified, only admins have access.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input['RulesetTeamArgs']]):
        pulumi.set(self, "team", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of ruleset. Currently, only sets to `global`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("pagerduty:index/ruleset:Ruleset")
class Ruleset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[Union['RulesetTeamArgs', 'RulesetTeamArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        foo = pagerduty.Team("foo", name="Engineering (Seattle)")
        foo_ruleset = pagerduty.Ruleset("foo",
            name="Primary Ruleset",
            team={
                "id": foo.id,
            })
        ```

        ## Import

        Rulesets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/ruleset:Ruleset main 19acac92-027a-4ea0-b06c-bbf516519601
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the ruleset.
        :param pulumi.Input[Union['RulesetTeamArgs', 'RulesetTeamArgsDict']] team: Reference to the team that owns the ruleset. If none is specified, only admins have access.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RulesetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        foo = pagerduty.Team("foo", name="Engineering (Seattle)")
        foo_ruleset = pagerduty.Ruleset("foo",
            name="Primary Ruleset",
            team={
                "id": foo.id,
            })
        ```

        ## Import

        Rulesets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/ruleset:Ruleset main 19acac92-027a-4ea0-b06c-bbf516519601
        ```

        :param str resource_name: The name of the resource.
        :param RulesetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RulesetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[Union['RulesetTeamArgs', 'RulesetTeamArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RulesetArgs.__new__(RulesetArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["team"] = team
            __props__.__dict__["routing_keys"] = None
            __props__.__dict__["type"] = None
        super(Ruleset, __self__).__init__(
            'pagerduty:index/ruleset:Ruleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            routing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            team: Optional[pulumi.Input[Union['RulesetTeamArgs', 'RulesetTeamArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ruleset':
        """
        Get an existing Ruleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] routing_keys: Routing keys routed to this ruleset.
        :param pulumi.Input[Union['RulesetTeamArgs', 'RulesetTeamArgsDict']] team: Reference to the team that owns the ruleset. If none is specified, only admins have access.
        :param pulumi.Input[_builtins.str] type: Type of ruleset. Currently, only sets to `global`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RulesetState.__new__(_RulesetState)

        __props__.__dict__["name"] = name
        __props__.__dict__["routing_keys"] = routing_keys
        __props__.__dict__["team"] = team
        __props__.__dict__["type"] = type
        return Ruleset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the ruleset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="routingKeys")
    def routing_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Routing keys routed to this ruleset.
        """
        return pulumi.get(self, "routing_keys")

    @_builtins.property
    @pulumi.getter
    def team(self) -> pulumi.Output[Optional['outputs.RulesetTeam']]:
        """
        Reference to the team that owns the ruleset. If none is specified, only admins have access.
        """
        return pulumi.get(self, "team")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of ruleset. Currently, only sets to `global`.
        """
        return pulumi.get(self, "type")

