# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from luminesce.models.order_by_direction import OrderByDirection

class OrderByTermDesign(BaseModel):
    """
    A single clause within an Order BY  # noqa: E501
    """
    field:  StrictStr = Field(...,alias="field", description="Name of the field to order by") 
    direction: Optional[OrderByDirection] = None
    table_alias:  Optional[StrictStr] = Field(None,alias="tableAlias", description="Table Alias of the field to order by") 
    __properties = ["field", "direction", "tableAlias"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderByTermDesign:
        """Create an instance of OrderByTermDesign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if table_alias (nullable) is None
        # and __fields_set__ contains the field
        if self.table_alias is None and "table_alias" in self.__fields_set__:
            _dict['tableAlias'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderByTermDesign:
        """Create an instance of OrderByTermDesign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrderByTermDesign.parse_obj(obj)

        _obj = OrderByTermDesign.parse_obj({
            "field": obj.get("field"),
            "direction": obj.get("direction"),
            "table_alias": obj.get("tableAlias")
        })
        return _obj
