
from stix2 import CustomObject
from stix2.properties import (
    ReferenceProperty,
    IDProperty, ListProperty, StringProperty,
    TimestampProperty, TypeProperty, BooleanProperty,
)
from stix2.v21.common import (
    ExternalReference,
)
from stix2.utils import NOW
from ._extensions import exploit_ExtensionDefinitionSMO

_type = 'exploit'
@CustomObject('exploit', [
    ('type', TypeProperty(_type, spec_version='2.1')),
    ('spec_version', StringProperty(fixed='2.1')),
    ('id', IDProperty(_type, spec_version='2.1')),
    ('created_by_ref', ReferenceProperty(valid_types='identity', spec_version='2.1')),
    ('created', TimestampProperty(default=lambda: NOW, precision='millisecond', precision_constraint='min')),
    ('modified', TimestampProperty(default=lambda: NOW, precision='millisecond', precision_constraint='min')),
    ('name', StringProperty(required=True)),
    ('description', StringProperty()),
    ('revoked', BooleanProperty(default=lambda: False)),
    ('vulnerability_ref', ReferenceProperty(valid_types='vulnerability', spec_version='2.1')),
    ('exploit_type', StringProperty()),
    ('proof_of_concept', StringProperty()),
    ('external_references', ListProperty(ExternalReference)),
    ('object_marking_refs', ListProperty(ReferenceProperty(valid_types='marking-definition', spec_version='2.1'))),
    # ('extensions', ExtensionsProperty(spec_version='2.1'))
], extension_name=exploit_ExtensionDefinitionSMO.id)
class Exploit(object):
    pass