from cloudcix.client import Client


class IAAS:
    """
    The IaaS application provides services that allow for management of IP Addresses, Subnets, and DNS records,
    along with accessing black and whitelists generated by CloudCIX and the direct management of CloudCIX Cloud
    infrastructure.
    """
    _application_name = 'iaas'

    allocation = Client(
        _application_name,
        'allocation/',
    )
    asn = Client(
        _application_name,
        'asn/',
    )
    attach = Client(
        _application_name,
        'attach/{resource_id}/parent/{parent_resource_id}/',
    )
    backup = Client(
        _application_name,
        'backup/',
    )
    backup_history = Client(
        _application_name,
        'backup_history/',
    )
    blacklist = Client(
        _application_name,
        'cix_blacklist/',
    )
    capacity = Client(
        _application_name,
        'capacity/{region_id}/',
    )
    ceph = Client(
        _application_name,
        'ceph/',
    )
    cloud = Client(
        _application_name,
        'cloud/',
    )
    cloud_bill = Client(
        _application_name,
        'cloud/pricing/',
    )
    detach = Client(
        _application_name,
        'detach/{resource_id}/',
    )
    domain = Client(
        _application_name,
        'domain/',
    )
    device = Client(
        _application_name,
        'device/',
    )
    device_type = Client(
        _application_name,
        'device_type/',
    )
    image = Client(
        _application_name,
        'image/',
    )
    interface = Client(
        _application_name,
        'interface/',
    )
    ip_address = Client(
        _application_name,
        'ip_address/',
    )
    ip_address_group = Client(
        _application_name,
        'ip_address_group/',
    )
    ip_validator = Client(
        _application_name,
        'ip_validator/',
    )
    metrics = Client(
        _application_name,
        'metrics/{region_id}/',
    )
    policy_log = Client(
        _application_name,
        'policy_log/{project_id}/',
    )
    project = Client(
        _application_name,
        'project/',
    )
    ptr_record = Client(
        _application_name,
        'ptr_record/',
    )
    record = Client(
        _application_name,
        'record/',
    )
    region_image = Client(
        _application_name,
        'region_image/',
    )
    region_storage_type = Client(
        _application_name,
        'region_storage_type/',
    )
    router = Client(
        _application_name,
        'router/',
    )
    run_robot = Client(
        _application_name,
        'run_robot/',
    )
    server = Client(
        _application_name,
        'server/',
    )
    server_type = Client(
        _application_name,
        'server_type/',
    )
    snapshot = Client(
        _application_name,
        'snapshot/',
    )
    snapshot_history = Client(
        _application_name,
        'snapshot_history/',
    )
    snapshot_tree = Client(
        _application_name,
        'snapshot_tree/{vm_id}/',
    )
    storage = Client(
        _application_name,
        'vm/{vm_id}/storage/',
    )
    storage_type = Client(
        _application_name,
        'storage_type/',
    )
    subnet = Client(
        _application_name,
        'subnet/',
    )
    subnet_space = Client(
        _application_name,
        'subnet_space/{allocation_id}/',
    )
    virtual_router = Client(
        _application_name,
        'virtual_router/',
    )
    vm = Client(
        _application_name,
        'vm/',
    )
    vm_history = Client(
        _application_name,
        'vm_history/',
    )
    vpn = Client(
        _application_name,
        'vpn/',
    )
    vpn_history = Client(
        _application_name,
        'vpn_history/',
    )
    vpn_status = Client(
        _application_name,
        'vpn_status/{vpn_id}/',
    )
    whitelist = Client(
        _application_name,
        'cix_whitelist/',
    )
