# Contributing

All contributions are welcome and greatly appreciated. Every little bit helps, and credit will always be given.

## Bug reports

When [reporting a bug](https://github.com/mmohaveri/python-tool-belt/issues) please include:

-   Your operating system name and version.
-   Any details about your local setup that might be helpful in troubleshooting.
-   Detailed steps to reproduce the bug.

## Documentation improvements

python-tool-belt could always use more documentation, whether as part of the official python-tool-belt docs or even on
the web in blog posts, articles, and such.

## Feature requests and feedback

The best way to send feedback is to file an issue [here](https://github.com/mmohaveri/python-tool-belt/issues).

If you are proposing a feature:

-   Explain in detail how it would work.
-   Keep the scope as narrow as possible, to make it easier to implement.
-   Remember that this is a volunteer-driven project, and that code contributions are welcome :)

## Development

To set up `python-tool-belt` for local development:

1. Fork [python-tool-belt](https://github.com/mmohaveri/python-tool-belt)
2. Clone your fork locally
3. Create a branch for local development
4. Apply changes
5. Add yourself to `AUTHORS.md`
6. Commit your changes and push your branch to GitHub
7. Submit a pull request through the GitHub website.

### Pull Request Guidelines

If you need some code review or feedback while you're developing the code just make the pull request.
Also please follow the following guidelines:

1. Use PEP 8 code style
    - 120 characters line limit
    - double quotes are preferred
    - don't forget newline at the end of the file
2. Commit messages should be self explanatory. It should answer following questions:
    - Why is this change necessary?
    - How does it address the issue?
    - What side effects does this change have?
3. Your branch should have just the right number of commits not too many, not too few.
    - Logically relevant changes SHOULD get committed together.
    - Logically irrelevant changes SHOULD NOT get committed together.
