import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.get_gcp_trigger_response_200_delivery_type import GetGcpTriggerResponse200DeliveryType
from ..models.get_gcp_trigger_response_200_subscription_mode import GetGcpTriggerResponse200SubscriptionMode
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.get_gcp_trigger_response_200_delivery_config import GetGcpTriggerResponse200DeliveryConfig
    from ..models.get_gcp_trigger_response_200_error_handler_args import GetGcpTriggerResponse200ErrorHandlerArgs
    from ..models.get_gcp_trigger_response_200_extra_perms import GetGcpTriggerResponse200ExtraPerms
    from ..models.get_gcp_trigger_response_200_retry import GetGcpTriggerResponse200Retry


T = TypeVar("T", bound="GetGcpTriggerResponse200")


@_attrs_define
class GetGcpTriggerResponse200:
    """
    Attributes:
        gcp_resource_path (str):
        topic_id (str):
        subscription_id (str):
        delivery_type (GetGcpTriggerResponse200DeliveryType):
        subscription_mode (GetGcpTriggerResponse200SubscriptionMode): The mode of subscription. 'existing' means using
            an existing GCP subscription, while 'create_update' involves creating or updating a new subscription.
        path (str):
        script_path (str):
        email (str):
        extra_perms (GetGcpTriggerResponse200ExtraPerms):
        workspace_id (str):
        edited_by (str):
        edited_at (datetime.datetime):
        is_flow (bool):
        enabled (bool):
        server_id (Union[Unset, str]):
        delivery_config (Union[Unset, GetGcpTriggerResponse200DeliveryConfig]):
        last_server_ping (Union[Unset, datetime.datetime]):
        error (Union[Unset, str]):
        error_handler_path (Union[Unset, str]):
        error_handler_args (Union[Unset, GetGcpTriggerResponse200ErrorHandlerArgs]): The arguments to pass to the script
            or flow
        retry (Union[Unset, GetGcpTriggerResponse200Retry]):
    """

    gcp_resource_path: str
    topic_id: str
    subscription_id: str
    delivery_type: GetGcpTriggerResponse200DeliveryType
    subscription_mode: GetGcpTriggerResponse200SubscriptionMode
    path: str
    script_path: str
    email: str
    extra_perms: "GetGcpTriggerResponse200ExtraPerms"
    workspace_id: str
    edited_by: str
    edited_at: datetime.datetime
    is_flow: bool
    enabled: bool
    server_id: Union[Unset, str] = UNSET
    delivery_config: Union[Unset, "GetGcpTriggerResponse200DeliveryConfig"] = UNSET
    last_server_ping: Union[Unset, datetime.datetime] = UNSET
    error: Union[Unset, str] = UNSET
    error_handler_path: Union[Unset, str] = UNSET
    error_handler_args: Union[Unset, "GetGcpTriggerResponse200ErrorHandlerArgs"] = UNSET
    retry: Union[Unset, "GetGcpTriggerResponse200Retry"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        gcp_resource_path = self.gcp_resource_path
        topic_id = self.topic_id
        subscription_id = self.subscription_id
        delivery_type = self.delivery_type.value

        subscription_mode = self.subscription_mode.value

        path = self.path
        script_path = self.script_path
        email = self.email
        extra_perms = self.extra_perms.to_dict()

        workspace_id = self.workspace_id
        edited_by = self.edited_by
        edited_at = self.edited_at.isoformat()

        is_flow = self.is_flow
        enabled = self.enabled
        server_id = self.server_id
        delivery_config: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.delivery_config, Unset):
            delivery_config = self.delivery_config.to_dict()

        last_server_ping: Union[Unset, str] = UNSET
        if not isinstance(self.last_server_ping, Unset):
            last_server_ping = self.last_server_ping.isoformat()

        error = self.error
        error_handler_path = self.error_handler_path
        error_handler_args: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.error_handler_args, Unset):
            error_handler_args = self.error_handler_args.to_dict()

        retry: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.retry, Unset):
            retry = self.retry.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "gcp_resource_path": gcp_resource_path,
                "topic_id": topic_id,
                "subscription_id": subscription_id,
                "delivery_type": delivery_type,
                "subscription_mode": subscription_mode,
                "path": path,
                "script_path": script_path,
                "email": email,
                "extra_perms": extra_perms,
                "workspace_id": workspace_id,
                "edited_by": edited_by,
                "edited_at": edited_at,
                "is_flow": is_flow,
                "enabled": enabled,
            }
        )
        if server_id is not UNSET:
            field_dict["server_id"] = server_id
        if delivery_config is not UNSET:
            field_dict["delivery_config"] = delivery_config
        if last_server_ping is not UNSET:
            field_dict["last_server_ping"] = last_server_ping
        if error is not UNSET:
            field_dict["error"] = error
        if error_handler_path is not UNSET:
            field_dict["error_handler_path"] = error_handler_path
        if error_handler_args is not UNSET:
            field_dict["error_handler_args"] = error_handler_args
        if retry is not UNSET:
            field_dict["retry"] = retry

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.get_gcp_trigger_response_200_delivery_config import GetGcpTriggerResponse200DeliveryConfig
        from ..models.get_gcp_trigger_response_200_error_handler_args import GetGcpTriggerResponse200ErrorHandlerArgs
        from ..models.get_gcp_trigger_response_200_extra_perms import GetGcpTriggerResponse200ExtraPerms
        from ..models.get_gcp_trigger_response_200_retry import GetGcpTriggerResponse200Retry

        d = src_dict.copy()
        gcp_resource_path = d.pop("gcp_resource_path")

        topic_id = d.pop("topic_id")

        subscription_id = d.pop("subscription_id")

        delivery_type = GetGcpTriggerResponse200DeliveryType(d.pop("delivery_type"))

        subscription_mode = GetGcpTriggerResponse200SubscriptionMode(d.pop("subscription_mode"))

        path = d.pop("path")

        script_path = d.pop("script_path")

        email = d.pop("email")

        extra_perms = GetGcpTriggerResponse200ExtraPerms.from_dict(d.pop("extra_perms"))

        workspace_id = d.pop("workspace_id")

        edited_by = d.pop("edited_by")

        edited_at = isoparse(d.pop("edited_at"))

        is_flow = d.pop("is_flow")

        enabled = d.pop("enabled")

        server_id = d.pop("server_id", UNSET)

        _delivery_config = d.pop("delivery_config", UNSET)
        delivery_config: Union[Unset, GetGcpTriggerResponse200DeliveryConfig]
        if isinstance(_delivery_config, Unset):
            delivery_config = UNSET
        else:
            delivery_config = GetGcpTriggerResponse200DeliveryConfig.from_dict(_delivery_config)

        _last_server_ping = d.pop("last_server_ping", UNSET)
        last_server_ping: Union[Unset, datetime.datetime]
        if isinstance(_last_server_ping, Unset):
            last_server_ping = UNSET
        else:
            last_server_ping = isoparse(_last_server_ping)

        error = d.pop("error", UNSET)

        error_handler_path = d.pop("error_handler_path", UNSET)

        _error_handler_args = d.pop("error_handler_args", UNSET)
        error_handler_args: Union[Unset, GetGcpTriggerResponse200ErrorHandlerArgs]
        if isinstance(_error_handler_args, Unset):
            error_handler_args = UNSET
        else:
            error_handler_args = GetGcpTriggerResponse200ErrorHandlerArgs.from_dict(_error_handler_args)

        _retry = d.pop("retry", UNSET)
        retry: Union[Unset, GetGcpTriggerResponse200Retry]
        if isinstance(_retry, Unset):
            retry = UNSET
        else:
            retry = GetGcpTriggerResponse200Retry.from_dict(_retry)

        get_gcp_trigger_response_200 = cls(
            gcp_resource_path=gcp_resource_path,
            topic_id=topic_id,
            subscription_id=subscription_id,
            delivery_type=delivery_type,
            subscription_mode=subscription_mode,
            path=path,
            script_path=script_path,
            email=email,
            extra_perms=extra_perms,
            workspace_id=workspace_id,
            edited_by=edited_by,
            edited_at=edited_at,
            is_flow=is_flow,
            enabled=enabled,
            server_id=server_id,
            delivery_config=delivery_config,
            last_server_ping=last_server_ping,
            error=error,
            error_handler_path=error_handler_path,
            error_handler_args=error_handler_args,
            retry=retry,
        )

        get_gcp_trigger_response_200.additional_properties = d
        return get_gcp_trigger_response_200

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
