---
toc_depth: 2
---

# Signatures options

## `show_signature`

- **:octicons-package-24: Type [`bool`][] :material-equal: `True`{ title="default value" }**
<!-- - **:octicons-project-template-24: Template :material-null:** (N/A) -->

Show methods and functions signatures.

Without it, just the function/method name is rendered.

```yaml title="in mkdocs.yml (global configuration)"
plugins:
- mkdocstrings:
    handlers:
      matlab:
        options:
          show_signature: true
```

```md title="or in docs/some_page.md (local configuration)"
::: matlab_callable
    options:
      show_signature: false
```

??? code ":material-file-code: `myfunction.m`"

    ```matlab
    --8<-- "docs/snippets/myfunction.m"
    ```

???+ preview

    === "With signature"

        ```markdown
        ::: myfunction
            options:
              show_signature: true
        ```

        ::: myfunction
            options:
              show_signature: true

    === "Without signature"

        ```markdown
        ::: myfunction
            options:
              show_signature: false
        ```

        ::: myfunction
            options:
              show_signature: false

## `show_signature_annotations`

- **:octicons-package-24: Type [`bool`][] :material-equal: `False`{ title="default value" }**
<!-- - **:octicons-project-template-24: Template :material-null:** (N/A) -->

Show the type annotations in methods and functions signatures.

Since the heading can become quite long when annotations are rendered, it is usually best to [separate the signature][separate_signature] from the heading.

```yaml title="in mkdocs.yml (global configuration)"
plugins:
- mkdocstrings:
    handlers:
      matlab:
        options:
          show_signature_annotations: true
```

```md title="or in docs/some_page.md (local configuration)"
::: path.to.module
    options:
      show_signature_annotations: false
```

??? code ":material-file-code: `myfunction.m`"

    ```matlab
    --8<-- "docs/snippets/myfunction.m"
    ```

???+ preview

    === "With signature annotations"

        ```markdown
        ::: myfunction
            options:
              show_signature: true
              show_signature_annotations: true
        ```

        ::: myfunction
            options:
              show_signature: true
              show_signature_annotations: true

    === "Without signature annotations"

        ```markdown
        ::: myfunction
            options:
              show_signature: true
              show_signature_annotations: false
        ```

        ::: myfunction
            options:
              show_signature: true
              show_signature_annotations: false


## `separate_signature`

- **:octicons-package-24: Type [`bool`][] :material-equal: `False`{ title="default value" }**
<!-- - **:octicons-project-template-24: Template :material-null:** (N/A) -->

Whether to put the whole signature in a code block below the heading.

```yaml title="in mkdocs.yml (global configuration)"
plugins:
- mkdocstrings:
    handlers:
      python:
        options:
          separate_signature: false
```

```md title="or in docs/some_page.md (local configuration)"
::: path.to.module
    options:
      separate_signature: true
```

??? code ":material-file-code: `myfunction.m`"

    ```matlab
    --8<-- "docs/snippets/myfunction.m"
    ```

???+ preview

    === "With separate signature"

        ```markdown
        ::: myfunction
            options:
              show_signature: true
              separate_signature: true
        ```

        ::: myfunction
            options:
              show_signature: true
              separate_signature: true

    === "Without separate signature"

        ```markdown
        ::: myfunction
            options:
              show_signature: true
              separate_signature: false
        ```

        ::: myfunction
            options:
              show_signature: true
              separate_signature: false

## `signature_crossrefs`

Whether to render cross-references for type annotations in signatures.

When signatures are separated from headings with the [`separate_signature`][] option and type annotations are shown with the [`show_signature_annotations`][] option, this option will render a cross-reference (link) for each type annotation in the signature.

```yaml title="in mkdocs.yml (global configuration)"
plugins:
- mkdocstrings:
    handlers:
      matlab:
        options:
          separate_signature: true
          show_signature_annotations: true
          signature_crossrefs: false
```

```md title="or in docs/some_page.md (local configuration)"
::: path.to.module
    options:
      separate_signature: true
      show_signature_annotations: true
      signature_crossrefs: true
```

??? code ":material-file-code: `myfunction.m`"

    ```matlab
    --8<-- "docs/snippets/myfunction.m"
    ```

???+ preview

    === "With separate signature"

        ```markdown
        ::: myfunction
            options:
              separate_signature: true
              show_signature_annotations: true
              signature_crossrefs: true
        ```

        ::: myfunction
            options:
              separate_signature: true
              show_signature_annotations: true
              signature_crossrefs: true

    === "Without separate signature"

        ```markdown
        ::: myfunction
            options:
              separate_signature: true
              show_signature_annotations: true
              signature_crossrefs: false
        ```

        ::: myfunction
            options:
              separate_signature: true
              show_signature_annotations: true
              signature_crossrefs: false
