from ccxt.base.types import Entry


class ImplicitAPI:
    v1_public_get_alerts = v1PublicGetAlerts = Entry('alerts', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_announcements = v1PublicGetAnnouncements = Entry('announcements', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_assets = v1PublicGetAssets = Entry('assets', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_book = v1PublicGetBook = Entry('book', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_candles = v1PublicGetCandles = Entry('candles', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_chains = v1PublicGetChains = Entry('chains', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_contracts = v1PublicGetContracts = Entry('contracts', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_index_price = v1PublicGetIndexPrice = Entry('index-price', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_index_prices = v1PublicGetIndexPrices = Entry('index-prices', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_margin_schedules = v1PublicGetMarginSchedules = Entry('margin-schedules', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_marketcapchart = v1PublicGetMarketcapchart = Entry('marketcapchart', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_marketcaps = v1PublicGetMarketcaps = Entry('marketcaps', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_pair = v1PublicGetPair = Entry('pair', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_pairs = v1PublicGetPairs = Entry('pairs', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_server_time = v1PublicGetServerTime = Entry('server-time', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_ticker = v1PublicGetTicker = Entry('ticker', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_tickers = v1PublicGetTickers = Entry('tickers', ['v1', 'public'], 'GET', {'cost': 1})
    v1_public_get_trades = v1PublicGetTrades = Entry('trades', ['v1', 'public'], 'GET', {'cost': 1})
    v1_private_get_user = v1PrivateGetUser = Entry('user', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders = v1PrivateGetOrders = Entry('orders', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders_by_client_order_id = v1PrivateGetOrdersByClientOrderId = Entry('orders/by-client-order-id', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders_history = v1PrivateGetOrdersHistory = Entry('orders/history', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders_history_by_client_order_id = v1PrivateGetOrdersHistoryByClientOrderId = Entry('orders/history/by-client-order-id', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders_history_offset = v1PrivateGetOrdersHistoryOffset = Entry('orders/history_offset', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_orders_id = v1PrivateGetOrdersId = Entry('orders/{id}', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_trades = v1PrivateGetTrades = Entry('trades', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_trades_history = v1PrivateGetTradesHistory = Entry('trades/history', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_trades_time = v1PrivateGetTradesTime = Entry('trades/time', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_trigger_orders = v1PrivateGetTriggerOrders = Entry('trigger-orders', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_airdrops = v1PrivateGetAccountAirdrops = Entry('account/airdrops', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_balance_updates = v1PrivateGetAccountBalanceUpdates = Entry('account/balance-updates', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_balances = v1PrivateGetAccountBalances = Entry('account/balances', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_balances_ll = v1PrivateGetAccountBalancesLl = Entry('account/balances/ll', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_balances_history = v1PrivateGetAccountBalancesHistory = Entry('account/balances/history', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_balances_commissions = v1PrivateGetAccountBalancesCommissions = Entry('account/balances/commissions', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_deposit_addresses = v1PrivateGetAccountDepositAddresses = Entry('account/deposit/addresses', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_deposits = v1PrivateGetAccountDeposits = Entry('account/deposits', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_fees = v1PrivateGetAccountFees = Entry('account/fees', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_funding_rate_payments = v1PrivateGetAccountFundingRatePayments = Entry('account/funding-rate-payments', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_leverage = v1PrivateGetAccountLeverage = Entry('account/leverage', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_lsp_assignments = v1PrivateGetAccountLspAssignments = Entry('account/lsp-assignments', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_margin = v1PrivateGetAccountMargin = Entry('account/margin', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_margin_all = v1PrivateGetAccountMarginAll = Entry('account/margin/all', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_notifications = v1PrivateGetAccountNotifications = Entry('account/notifications', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_position_updates = v1PrivateGetAccountPositionUpdates = Entry('account/position-updates', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_positions = v1PrivateGetAccountPositions = Entry('account/positions', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_realized_pnl = v1PrivateGetAccountRealizedPnl = Entry('account/realized-pnl', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_rebates = v1PrivateGetAccountRebates = Entry('account/rebates', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_referral_links = v1PrivateGetAccountReferralLinks = Entry('account/referral-links', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_sessions = v1PrivateGetAccountSessions = Entry('account/sessions', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_settings = v1PrivateGetAccountSettings = Entry('account/settings', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_settings_price_alert = v1PrivateGetAccountSettingsPriceAlert = Entry('account/settings/price-alert', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_transfers = v1PrivateGetAccountTransfers = Entry('account/transfers', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_unsubscribe = v1PrivateGetAccountUnsubscribe = Entry('account/unsubscribe', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_watchlist = v1PrivateGetAccountWatchlist = Entry('account/watchlist', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_withdrawal_addresses = v1PrivateGetAccountWithdrawalAddresses = Entry('account/withdrawal/addresses', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_withdrawal_addresses_id = v1PrivateGetAccountWithdrawalAddressesId = Entry('account/withdrawal/addresses/{id}', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_account_withdrawals = v1PrivateGetAccountWithdrawals = Entry('account/withdrawals', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_subaccounts = v1PrivateGetSubaccounts = Entry('subaccounts', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_airdrop = v1PrivateGetAirdrop = Entry('airdrop', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_airdrop_claim = v1PrivateGetAirdropClaim = Entry('airdrop/claim', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_commission_earned = v1PrivateGetAffiliateDashboardCommissionEarned = Entry('affiliate-dashboard/commission-earned', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_min_arkm_last_30d = v1PrivateGetAffiliateDashboardMinArkmLast30d = Entry('affiliate-dashboard/min-arkm-last-30d', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_points = v1PrivateGetAffiliateDashboardPoints = Entry('affiliate-dashboard/points', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_points_season_1 = v1PrivateGetAffiliateDashboardPointsSeason1 = Entry('affiliate-dashboard/points-season-1', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_points_season_2 = v1PrivateGetAffiliateDashboardPointsSeason2 = Entry('affiliate-dashboard/points-season-2', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_realized_pnl = v1PrivateGetAffiliateDashboardRealizedPnl = Entry('affiliate-dashboard/realized-pnl', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_rebate_balance = v1PrivateGetAffiliateDashboardRebateBalance = Entry('affiliate-dashboard/rebate-balance', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_referral_count = v1PrivateGetAffiliateDashboardReferralCount = Entry('affiliate-dashboard/referral-count', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_referrals_season_1 = v1PrivateGetAffiliateDashboardReferralsSeason1 = Entry('affiliate-dashboard/referrals-season-1', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_referrals_season_2 = v1PrivateGetAffiliateDashboardReferralsSeason2 = Entry('affiliate-dashboard/referrals-season-2', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_trading_volume_stats = v1PrivateGetAffiliateDashboardTradingVolumeStats = Entry('affiliate-dashboard/trading-volume-stats', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_volume_season_1 = v1PrivateGetAffiliateDashboardVolumeSeason1 = Entry('affiliate-dashboard/volume-season-1', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_volume_season_2 = v1PrivateGetAffiliateDashboardVolumeSeason2 = Entry('affiliate-dashboard/volume-season-2', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_affiliate_dashboard_api_key = v1PrivateGetAffiliateDashboardApiKey = Entry('affiliate-dashboard/api-key', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_competitions_opt_in_status = v1PrivateGetCompetitionsOptInStatus = Entry('competitions/opt-in-status', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_rewards_info = v1PrivateGetRewardsInfo = Entry('rewards/info', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_get_rewards_vouchers = v1PrivateGetRewardsVouchers = Entry('rewards/vouchers', ['v1', 'private'], 'GET', {'cost': 7.5})
    v1_private_post_orders_new = v1PrivatePostOrdersNew = Entry('orders/new', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_trigger_orders_new = v1PrivatePostTriggerOrdersNew = Entry('trigger-orders/new', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_orders_cancel = v1PrivatePostOrdersCancel = Entry('orders/cancel', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_trigger_orders_cancel = v1PrivatePostTriggerOrdersCancel = Entry('trigger-orders/cancel', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_orders_cancel_all = v1PrivatePostOrdersCancelAll = Entry('orders/cancel/all', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_trigger_orders_cancel_all = v1PrivatePostTriggerOrdersCancelAll = Entry('trigger-orders/cancel/all', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_orders_new_simple = v1PrivatePostOrdersNewSimple = Entry('orders/new/simple', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_deposit_addresses_new = v1PrivatePostAccountDepositAddressesNew = Entry('account/deposit/addresses/new', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_leverage = v1PrivatePostAccountLeverage = Entry('account/leverage', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_notifications_read = v1PrivatePostAccountNotificationsRead = Entry('account/notifications/read', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_referral_links = v1PrivatePostAccountReferralLinks = Entry('account/referral-links', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_sessions_delete = v1PrivatePostAccountSessionsDelete = Entry('account/sessions/delete', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_sessions_terminate_all = v1PrivatePostAccountSessionsTerminateAll = Entry('account/sessions/terminate-all', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_settings_update = v1PrivatePostAccountSettingsUpdate = Entry('account/settings/update', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_watchlist_add = v1PrivatePostAccountWatchlistAdd = Entry('account/watchlist/add', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_watchlist_remove = v1PrivatePostAccountWatchlistRemove = Entry('account/watchlist/remove', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_withdraw = v1PrivatePostAccountWithdraw = Entry('account/withdraw', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_account_withdrawal_addresses_confirm = v1PrivatePostAccountWithdrawalAddressesConfirm = Entry('account/withdrawal/addresses/confirm', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_subaccounts = v1PrivatePostSubaccounts = Entry('subaccounts', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_subaccounts_transfer = v1PrivatePostSubaccountsTransfer = Entry('subaccounts/transfer', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_subaccounts_perp_transfer = v1PrivatePostSubaccountsPerpTransfer = Entry('subaccounts/perp-transfer', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_subaccounts_update_settings = v1PrivatePostSubaccountsUpdateSettings = Entry('subaccounts/update-settings', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_airdrop = v1PrivatePostAirdrop = Entry('airdrop', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_api_key_create = v1PrivatePostApiKeyCreate = Entry('api-key/create', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_authenticate = v1PrivatePostAuthenticate = Entry('authenticate', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_competitions_opt_in = v1PrivatePostCompetitionsOptIn = Entry('competitions/opt-in', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_post_rewards_vouchers_claim = v1PrivatePostRewardsVouchersClaim = Entry('rewards/vouchers/claim', ['v1', 'private'], 'POST', {'cost': 7.5})
    v1_private_put_account_referral_links_id_slug = v1PrivatePutAccountReferralLinksIdSlug = Entry('account/referral-links/{id}/slug', ['v1', 'private'], 'PUT', {'cost': 7.5})
    v1_private_put_account_settings_price_alert = v1PrivatePutAccountSettingsPriceAlert = Entry('account/settings/price-alert', ['v1', 'private'], 'PUT', {'cost': 7.5})
    v1_private_put_account_withdrawal_addresses_id = v1PrivatePutAccountWithdrawalAddressesId = Entry('account/withdrawal/addresses/{id}', ['v1', 'private'], 'PUT', {'cost': 7.5})
    v1_private_put_subaccounts = v1PrivatePutSubaccounts = Entry('subaccounts', ['v1', 'private'], 'PUT', {'cost': 7.5})
    v1_private_put_api_key_update_id = v1PrivatePutApiKeyUpdateId = Entry('api-key/update/{id}', ['v1', 'private'], 'PUT', {'cost': 7.5})
    v1_private_delete_account_settings_price_alert = v1PrivateDeleteAccountSettingsPriceAlert = Entry('account/settings/price-alert', ['v1', 'private'], 'DELETE', {'cost': 7.5})
    v1_private_delete_account_withdrawal_addresses_id = v1PrivateDeleteAccountWithdrawalAddressesId = Entry('account/withdrawal/addresses/{id}', ['v1', 'private'], 'DELETE', {'cost': 7.5})
    v1_private_delete_subaccounts_subaccountid = v1PrivateDeleteSubaccountsSubaccountId = Entry('subaccounts/{subaccountId}', ['v1', 'private'], 'DELETE', {'cost': 7.5})
    v1_private_delete_api_key_id = v1PrivateDeleteApiKeyId = Entry('api-key/{id}', ['v1', 'private'], 'DELETE', {'cost': 7.5})
