# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.6.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CurrentUserEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'identity': 'str',
        'anonymous': 'bool',
        'provenance_permissions': 'PermissionsDTO',
        'counters_permissions': 'PermissionsDTO',
        'tenants_permissions': 'PermissionsDTO',
        'controller_permissions': 'PermissionsDTO',
        'policies_permissions': 'PermissionsDTO',
        'system_permissions': 'PermissionsDTO',
        'restricted_components_permissions': 'PermissionsDTO',
        'component_restriction_permissions': 'list[ComponentRestrictionPermissionDTO]',
        'can_version_flows': 'bool'
    }

    attribute_map = {
        'identity': 'identity',
        'anonymous': 'anonymous',
        'provenance_permissions': 'provenancePermissions',
        'counters_permissions': 'countersPermissions',
        'tenants_permissions': 'tenantsPermissions',
        'controller_permissions': 'controllerPermissions',
        'policies_permissions': 'policiesPermissions',
        'system_permissions': 'systemPermissions',
        'restricted_components_permissions': 'restrictedComponentsPermissions',
        'component_restriction_permissions': 'componentRestrictionPermissions',
        'can_version_flows': 'canVersionFlows'
    }

    def __init__(self, identity=None, anonymous=None, provenance_permissions=None, counters_permissions=None, tenants_permissions=None, controller_permissions=None, policies_permissions=None, system_permissions=None, restricted_components_permissions=None, component_restriction_permissions=None, can_version_flows=None):
        """
        CurrentUserEntity - a model defined in Swagger
        """

        self._identity = None
        self._anonymous = None
        self._provenance_permissions = None
        self._counters_permissions = None
        self._tenants_permissions = None
        self._controller_permissions = None
        self._policies_permissions = None
        self._system_permissions = None
        self._restricted_components_permissions = None
        self._component_restriction_permissions = None
        self._can_version_flows = None

        if identity is not None:
          self.identity = identity
        if anonymous is not None:
          self.anonymous = anonymous
        if provenance_permissions is not None:
          self.provenance_permissions = provenance_permissions
        if counters_permissions is not None:
          self.counters_permissions = counters_permissions
        if tenants_permissions is not None:
          self.tenants_permissions = tenants_permissions
        if controller_permissions is not None:
          self.controller_permissions = controller_permissions
        if policies_permissions is not None:
          self.policies_permissions = policies_permissions
        if system_permissions is not None:
          self.system_permissions = system_permissions
        if restricted_components_permissions is not None:
          self.restricted_components_permissions = restricted_components_permissions
        if component_restriction_permissions is not None:
          self.component_restriction_permissions = component_restriction_permissions
        if can_version_flows is not None:
          self.can_version_flows = can_version_flows

    @property
    def identity(self):
        """
        Gets the identity of this CurrentUserEntity.
        The user identity being serialized.

        :return: The identity of this CurrentUserEntity.
        :rtype: str
        """
        return self._identity

    @identity.setter
    def identity(self, identity):
        """
        Sets the identity of this CurrentUserEntity.
        The user identity being serialized.

        :param identity: The identity of this CurrentUserEntity.
        :type: str
        """

        self._identity = identity

    @property
    def anonymous(self):
        """
        Gets the anonymous of this CurrentUserEntity.
        Whether the current user is anonymous.

        :return: The anonymous of this CurrentUserEntity.
        :rtype: bool
        """
        return self._anonymous

    @anonymous.setter
    def anonymous(self, anonymous):
        """
        Sets the anonymous of this CurrentUserEntity.
        Whether the current user is anonymous.

        :param anonymous: The anonymous of this CurrentUserEntity.
        :type: bool
        """

        self._anonymous = anonymous

    @property
    def provenance_permissions(self):
        """
        Gets the provenance_permissions of this CurrentUserEntity.
        Permissions for querying provenance.

        :return: The provenance_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._provenance_permissions

    @provenance_permissions.setter
    def provenance_permissions(self, provenance_permissions):
        """
        Sets the provenance_permissions of this CurrentUserEntity.
        Permissions for querying provenance.

        :param provenance_permissions: The provenance_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._provenance_permissions = provenance_permissions

    @property
    def counters_permissions(self):
        """
        Gets the counters_permissions of this CurrentUserEntity.
        Permissions for accessing counters.

        :return: The counters_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._counters_permissions

    @counters_permissions.setter
    def counters_permissions(self, counters_permissions):
        """
        Sets the counters_permissions of this CurrentUserEntity.
        Permissions for accessing counters.

        :param counters_permissions: The counters_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._counters_permissions = counters_permissions

    @property
    def tenants_permissions(self):
        """
        Gets the tenants_permissions of this CurrentUserEntity.
        Permissions for accessing tenants.

        :return: The tenants_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._tenants_permissions

    @tenants_permissions.setter
    def tenants_permissions(self, tenants_permissions):
        """
        Sets the tenants_permissions of this CurrentUserEntity.
        Permissions for accessing tenants.

        :param tenants_permissions: The tenants_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._tenants_permissions = tenants_permissions

    @property
    def controller_permissions(self):
        """
        Gets the controller_permissions of this CurrentUserEntity.
        Permissions for accessing the controller.

        :return: The controller_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._controller_permissions

    @controller_permissions.setter
    def controller_permissions(self, controller_permissions):
        """
        Sets the controller_permissions of this CurrentUserEntity.
        Permissions for accessing the controller.

        :param controller_permissions: The controller_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._controller_permissions = controller_permissions

    @property
    def policies_permissions(self):
        """
        Gets the policies_permissions of this CurrentUserEntity.
        Permissions for accessing the policies.

        :return: The policies_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._policies_permissions

    @policies_permissions.setter
    def policies_permissions(self, policies_permissions):
        """
        Sets the policies_permissions of this CurrentUserEntity.
        Permissions for accessing the policies.

        :param policies_permissions: The policies_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._policies_permissions = policies_permissions

    @property
    def system_permissions(self):
        """
        Gets the system_permissions of this CurrentUserEntity.
        Permissions for accessing system.

        :return: The system_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._system_permissions

    @system_permissions.setter
    def system_permissions(self, system_permissions):
        """
        Sets the system_permissions of this CurrentUserEntity.
        Permissions for accessing system.

        :param system_permissions: The system_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._system_permissions = system_permissions

    @property
    def restricted_components_permissions(self):
        """
        Gets the restricted_components_permissions of this CurrentUserEntity.
        Permissions for accessing restricted components. Note: the read permission are not used and will always be false.

        :return: The restricted_components_permissions of this CurrentUserEntity.
        :rtype: PermissionsDTO
        """
        return self._restricted_components_permissions

    @restricted_components_permissions.setter
    def restricted_components_permissions(self, restricted_components_permissions):
        """
        Sets the restricted_components_permissions of this CurrentUserEntity.
        Permissions for accessing restricted components. Note: the read permission are not used and will always be false.

        :param restricted_components_permissions: The restricted_components_permissions of this CurrentUserEntity.
        :type: PermissionsDTO
        """

        self._restricted_components_permissions = restricted_components_permissions

    @property
    def component_restriction_permissions(self):
        """
        Gets the component_restriction_permissions of this CurrentUserEntity.
        Permissions for specific component restrictions.

        :return: The component_restriction_permissions of this CurrentUserEntity.
        :rtype: list[ComponentRestrictionPermissionDTO]
        """
        return self._component_restriction_permissions

    @component_restriction_permissions.setter
    def component_restriction_permissions(self, component_restriction_permissions):
        """
        Sets the component_restriction_permissions of this CurrentUserEntity.
        Permissions for specific component restrictions.

        :param component_restriction_permissions: The component_restriction_permissions of this CurrentUserEntity.
        :type: list[ComponentRestrictionPermissionDTO]
        """

        self._component_restriction_permissions = component_restriction_permissions

    @property
    def can_version_flows(self):
        """
        Gets the can_version_flows of this CurrentUserEntity.
        Whether the current user can version flows.

        :return: The can_version_flows of this CurrentUserEntity.
        :rtype: bool
        """
        return self._can_version_flows

    @can_version_flows.setter
    def can_version_flows(self, can_version_flows):
        """
        Sets the can_version_flows of this CurrentUserEntity.
        Whether the current user can version flows.

        :param can_version_flows: The can_version_flows of this CurrentUserEntity.
        :type: bool
        """

        self._can_version_flows = can_version_flows

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CurrentUserEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
