![image](https://raw.githubusercontent.com/cubert-hyperspectral/cuvis.sdk/main/branding/logo/banner.png)

# cuvis.ai

*The project is still maturing. We will make occasional breaking changes and add missing features on our way to v1.*

cuvis.ai is a software toolkit designed to facilitate the development of artificial intelligence (AI) and machine 
learning applications for hyperspectral measurements.

- **Website:** https://www.cubert-hyperspectral.com/
- **Source code:** https://github.com/cubert-hyperspectral/
- **Support:** http://support.cubert-hyperspectral.com/

This toolkit enables the creation of a graph from a set of different preexisting supervised and unsupervised nodes. 
Furthermore, it provides data preprocessing and output postprocessing, thus offering a comprehensive package for the 
development of AI capabilities for hyperspectral images. 

This repository is aimed at companies, universities and private enthusiasts alike. Its objective is to provide a 
foundation for the development of cutting-edge hyperspectral AI applications.


## Installation

### Prerequisites

If you want to directly work with cubert session files (.cu3s), you need to install cuvis C SDK from 
[here](https://cloud.cubert-gmbh.de/s/q3YiPZPJe5oXziZ).

All other needed packages will be installed via the requirements.txt. To do so run 

```
pip install .
```
from within your project environment

### Via pip

If you wish to use cuvis.ai within another project, from within your 
project environment, run 

```
pip install cuvis-ai
```

or add `cuvis-ai` to your project `requirements.txt` or `setup.py`.

## How to ...

### Getting started

We provide an additional example repository [here](https://github.com/cubert-hyperspectral/cuvis.ai.examples),
covering some basic applications.

Further, we provide a set of example measurements to explore [here](https://cloud.cubert-gmbh.de/s/SrkSRja5FKGS2Tw).
These measurements are also used by the examples mentioned above.

### Getting involved

cuvis.hub welcomes your enthusiasm and expertise!

With providing our SDK wrappers on GitHub, we aim for a community-driven open 
source application development by a diverse group of contributors.
Cubert GmbH aims for creating an open, inclusive, and positive community.
Feel free to branch/fork this repository for later merge requests, open 
issues or point us to your application specific projects.
Contact us, if you want your open source project to be included and shared 
on this hub; either if you search for direct support, collaborators or any 
other input or simply want your project being used by this community.
We ourselves try to expand the code base with further more specific 
applications using our wrappers to provide starting points for research 
projects, embedders or other users.

### Getting help

Directly code related issues can be posted here on the GitHub page, other, more 
general and application related issues should be directed to the 
aforementioned Cubert GmbH [support page](http://support.cubert-hyperspectral.com/).