# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.context_template_response import ContextTemplateResponse
from ..types.list_context_templates_response import ListContextTemplatesResponse
from ..types.success_response import SuccessResponse
from .raw_client import AsyncRawContextClient, RawContextClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContextClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContextClient
        """
        return self._raw_client

    def list_context_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListContextTemplatesResponse:
        """
        Lists all context templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListContextTemplatesResponse
            The list of context templates.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.context.list_context_templates()
        """
        _response = self._raw_client.list_context_templates(request_options=request_options)
        return _response.data

    def create_context_template(
        self, *, template: str, template_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Creates a new context template.

        Parameters
        ----------
        template : str
            The template content (max 1200 characters).

        template_id : str
            Unique identifier for the template (max 100 characters).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The created context template.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.context.create_context_template(
            template="template",
            template_id="template_id",
        )
        """
        _response = self._raw_client.create_context_template(
            template=template, template_id=template_id, request_options=request_options
        )
        return _response.data

    def get_context_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Retrieves a context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The context template.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.context.get_context_template(
            template_id="template_id",
        )
        """
        _response = self._raw_client.get_context_template(template_id, request_options=request_options)
        return _response.data

    def update_context_template(
        self, template_id: str, *, template: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Updates an existing context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        template : str
            The template content (max 1200 characters).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The updated context template.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.context.update_context_template(
            template_id="template_id",
            template="template",
        )
        """
        _response = self._raw_client.update_context_template(
            template_id, template=template, request_options=request_options
        )
        return _response.data

    def delete_context_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deletes a context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Template deleted successfully

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.context.delete_context_template(
            template_id="template_id",
        )
        """
        _response = self._raw_client.delete_context_template(template_id, request_options=request_options)
        return _response.data


class AsyncContextClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContextClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContextClient
        """
        return self._raw_client

    async def list_context_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListContextTemplatesResponse:
        """
        Lists all context templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListContextTemplatesResponse
            The list of context templates.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.context.list_context_templates()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_context_templates(request_options=request_options)
        return _response.data

    async def create_context_template(
        self, *, template: str, template_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Creates a new context template.

        Parameters
        ----------
        template : str
            The template content (max 1200 characters).

        template_id : str
            Unique identifier for the template (max 100 characters).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The created context template.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.context.create_context_template(
                template="template",
                template_id="template_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_context_template(
            template=template, template_id=template_id, request_options=request_options
        )
        return _response.data

    async def get_context_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Retrieves a context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The context template.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.context.get_context_template(
                template_id="template_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_context_template(template_id, request_options=request_options)
        return _response.data

    async def update_context_template(
        self, template_id: str, *, template: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ContextTemplateResponse:
        """
        Updates an existing context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        template : str
            The template content (max 1200 characters).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContextTemplateResponse
            The updated context template.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.context.update_context_template(
                template_id="template_id",
                template="template",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_context_template(
            template_id, template=template, request_options=request_options
        )
        return _response.data

    async def delete_context_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deletes a context template by template_id.

        Parameters
        ----------
        template_id : str
            Template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Template deleted successfully

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.context.delete_context_template(
                template_id="template_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_context_template(template_id, request_options=request_options)
        return _response.data
