# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.episode import Episode
from ...types.episode_mentions import EpisodeMentions
from ...types.episode_response import EpisodeResponse
from ...types.success_response import SuccessResponse
from .raw_client import AsyncRawEpisodeClient, RawEpisodeClient


class EpisodeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEpisodeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEpisodeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEpisodeClient
        """
        return self._raw_client

    def get_by_graph_id(
        self,
        graph_id: str,
        *,
        lastn: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EpisodeResponse:
        """
        Returns episodes by graph id.

        Parameters
        ----------
        graph_id : str
            Graph ID

        lastn : typing.Optional[int]
            The number of most recent episodes to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeResponse
            Episodes

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.graph.episode.get_by_graph_id(
            graph_id="graph_id",
            lastn=1,
        )
        """
        _response = self._raw_client.get_by_graph_id(graph_id, lastn=lastn, request_options=request_options)
        return _response.data

    def get_by_user_id(
        self,
        user_id: str,
        *,
        lastn: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EpisodeResponse:
        """
        Returns episodes by user id.

        Parameters
        ----------
        user_id : str
            User ID

        lastn : typing.Optional[int]
            The number of most recent episodes entries to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeResponse
            Episodes

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.graph.episode.get_by_user_id(
            user_id="user_id",
            lastn=1,
        )
        """
        _response = self._raw_client.get_by_user_id(user_id, lastn=lastn, request_options=request_options)
        return _response.data

    def get(self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None) -> Episode:
        """
        Returns episodes by UUID

        Parameters
        ----------
        uuid_ : str
            Episode UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Episode
            Episode

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.graph.episode.get(
            uuid_="uuid",
        )
        """
        _response = self._raw_client.get(uuid_, request_options=request_options)
        return _response.data

    def delete(self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes an episode by its UUID.

        Parameters
        ----------
        uuid_ : str
            Episode UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Episode deleted

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.graph.episode.delete(
            uuid_="uuid",
        )
        """
        _response = self._raw_client.delete(uuid_, request_options=request_options)
        return _response.data

    def get_nodes_and_edges(
        self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EpisodeMentions:
        """
        Returns nodes and edges mentioned in an episode

        Parameters
        ----------
        uuid_ : str
            Episode uuid

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeMentions
            Edges and nodes mentioned in an episode

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.graph.episode.get_nodes_and_edges(
            uuid_="uuid",
        )
        """
        _response = self._raw_client.get_nodes_and_edges(uuid_, request_options=request_options)
        return _response.data


class AsyncEpisodeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEpisodeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEpisodeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEpisodeClient
        """
        return self._raw_client

    async def get_by_graph_id(
        self,
        graph_id: str,
        *,
        lastn: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EpisodeResponse:
        """
        Returns episodes by graph id.

        Parameters
        ----------
        graph_id : str
            Graph ID

        lastn : typing.Optional[int]
            The number of most recent episodes to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeResponse
            Episodes

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.graph.episode.get_by_graph_id(
                graph_id="graph_id",
                lastn=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_graph_id(graph_id, lastn=lastn, request_options=request_options)
        return _response.data

    async def get_by_user_id(
        self,
        user_id: str,
        *,
        lastn: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EpisodeResponse:
        """
        Returns episodes by user id.

        Parameters
        ----------
        user_id : str
            User ID

        lastn : typing.Optional[int]
            The number of most recent episodes entries to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeResponse
            Episodes

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.graph.episode.get_by_user_id(
                user_id="user_id",
                lastn=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_user_id(user_id, lastn=lastn, request_options=request_options)
        return _response.data

    async def get(self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None) -> Episode:
        """
        Returns episodes by UUID

        Parameters
        ----------
        uuid_ : str
            Episode UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Episode
            Episode

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.graph.episode.get(
                uuid_="uuid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(uuid_, request_options=request_options)
        return _response.data

    async def delete(self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes an episode by its UUID.

        Parameters
        ----------
        uuid_ : str
            Episode UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Episode deleted

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.graph.episode.delete(
                uuid_="uuid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(uuid_, request_options=request_options)
        return _response.data

    async def get_nodes_and_edges(
        self, uuid_: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EpisodeMentions:
        """
        Returns nodes and edges mentioned in an episode

        Parameters
        ----------
        uuid_ : str
            Episode uuid

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EpisodeMentions
            Edges and nodes mentioned in an episode

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.graph.episode.get_nodes_and_edges(
                uuid_="uuid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_nodes_and_edges(uuid_, request_options=request_options)
        return _response.data
